# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UNIQ_IMAGES_METADATA = Metadata(
    id="acfae7c985924ad5290478ad1896665b095375db.boutiques",
    name="uniq_images",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UniqImagesParameters = typing.TypedDict('UniqImagesParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/uniq_images"]],
    "input_files": list[InputPathType],
})
UniqImagesParametersTagged = typing.TypedDict('UniqImagesParametersTagged', {
    "@type": typing.Literal["afni/uniq_images"],
    "input_files": list[InputPathType],
})


class UniqImagesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `UniqImagesParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    unique_files_list: OutputPathType
    """Generated list of filenames with unique images"""


def uniq_images_params(
    input_files: list[InputPathType],
) -> UniqImagesParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: List of image filenames to be processed.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/uniq_images",
        "input_files": input_files,
    }
    return params


def uniq_images_cargs(
    params: UniqImagesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("uniq_images")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def uniq_images_outputs(
    params: UniqImagesParameters,
    execution: Execution,
) -> UniqImagesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UniqImagesOutputs(
        root=execution.output_file("."),
        unique_files_list=execution.output_file("unique_images_list.txt"),
    )
    return ret


def uniq_images_execute(
    params: UniqImagesParameters,
    runner: Runner | None = None,
) -> UniqImagesOutputs:
    """
    uniq_images
    
    Simple program to read in a list of image filenames, determine which files
    have unique images inside, and echo out only a list of the filenames with
    unique images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UniqImagesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UNIQ_IMAGES_METADATA)
    params = execution.params(params)
    cargs = uniq_images_cargs(params, execution)
    ret = uniq_images_outputs(params, execution)
    execution.run(cargs)
    return ret


def uniq_images(
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> UniqImagesOutputs:
    """
    uniq_images
    
    Simple program to read in a list of image filenames, determine which files
    have unique images inside, and echo out only a list of the filenames with
    unique images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: List of image filenames to be processed.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UniqImagesOutputs`).
    """
    params = uniq_images_params(
        input_files=input_files,
    )
    return uniq_images_execute(params, runner)


__all__ = [
    "UNIQ_IMAGES_METADATA",
    "UniqImagesOutputs",
    "uniq_images",
    "uniq_images_execute",
    "uniq_images_params",
]
