# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1D_APAR2MAT_METADATA = Metadata(
    id="a38c141c8e7dcaa9be485e9b5281ec9cbae1bc6c.boutiques",
    name="1dApar2mat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dApar2matParameters = typing.TypedDict('V1dApar2matParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dApar2mat"]],
    "x_shift": float,
    "y_shift": float,
    "z_shift": float,
    "z_angle": float,
    "x_angle": float,
    "y_angle": float,
    "x_scale": float,
    "y_scale": float,
    "z_scale": float,
    "y_x_shear": float,
    "z_x_shear": float,
    "z_y_shear": float,
})
V1dApar2matParametersTagged = typing.TypedDict('V1dApar2matParametersTagged', {
    "@type": typing.Literal["afni/1dApar2mat"],
    "x_shift": float,
    "y_shift": float,
    "z_shift": float,
    "z_angle": float,
    "x_angle": float,
    "y_angle": float,
    "x_scale": float,
    "y_scale": float,
    "z_scale": float,
    "y_x_shear": float,
    "z_x_shear": float,
    "z_y_shear": float,
})


class V1dApar2matOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dApar2matParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_1d_apar2mat_params(
    x_shift: float,
    y_shift: float,
    z_shift: float,
    z_angle: float,
    x_angle: float,
    y_angle: float,
    x_scale: float,
    y_scale: float,
    z_scale: float,
    y_x_shear: float,
    z_x_shear: float,
    z_y_shear: float,
) -> V1dApar2matParametersTagged:
    """
    Build parameters.
    
    Args:
        x_shift: x-shift in mm.
        y_shift: y-shift in mm.
        z_shift: z-shift in mm.
        z_angle: z-angle (roll) in degrees.
        x_angle: x-angle (pitch) in degrees.
        y_angle: y-angle (yaw) in degrees.
        x_scale: x-scale factor in [0.10,10.0].
        y_scale: y-scale factor in [0.10,10.0].
        z_scale: z-scale factor in [0.10,10.0].
        y_x_shear: y/x-shear factor in [-0.3333,0.3333].
        z_x_shear: z/x-shear factor in [-0.3333,0.3333].
        z_y_shear: z/y-shear factor in [-0.3333,0.3333].
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dApar2mat",
        "x_shift": x_shift,
        "y_shift": y_shift,
        "z_shift": z_shift,
        "z_angle": z_angle,
        "x_angle": x_angle,
        "y_angle": y_angle,
        "x_scale": x_scale,
        "y_scale": y_scale,
        "z_scale": z_scale,
        "y_x_shear": y_x_shear,
        "z_x_shear": z_x_shear,
        "z_y_shear": z_y_shear,
    }
    return params


def v_1d_apar2mat_cargs(
    params: V1dApar2matParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dApar2mat")
    cargs.append(str(params.get("x_shift", None)))
    cargs.append(str(params.get("y_shift", None)))
    cargs.append(str(params.get("z_shift", None)))
    cargs.append(str(params.get("z_angle", None)))
    cargs.append(str(params.get("x_angle", None)))
    cargs.append(str(params.get("y_angle", None)))
    cargs.append(str(params.get("x_scale", None)))
    cargs.append(str(params.get("y_scale", None)))
    cargs.append(str(params.get("z_scale", None)))
    cargs.append(str(params.get("y_x_shear", None)))
    cargs.append(str(params.get("z_x_shear", None)))
    cargs.append(str(params.get("z_y_shear", None)))
    return cargs


def v_1d_apar2mat_outputs(
    params: V1dApar2matParameters,
    execution: Execution,
) -> V1dApar2matOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dApar2matOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_1d_apar2mat_execute(
    params: V1dApar2matParameters,
    runner: Runner | None = None,
) -> V1dApar2matOutputs:
    """
    1dApar2mat
    
    Computes the affine transformation matrix from the set of 3dAllineate
    parameters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dApar2matOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1D_APAR2MAT_METADATA)
    params = execution.params(params)
    cargs = v_1d_apar2mat_cargs(params, execution)
    ret = v_1d_apar2mat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1d_apar2mat(
    x_shift: float,
    y_shift: float,
    z_shift: float,
    z_angle: float,
    x_angle: float,
    y_angle: float,
    x_scale: float,
    y_scale: float,
    z_scale: float,
    y_x_shear: float,
    z_x_shear: float,
    z_y_shear: float,
    runner: Runner | None = None,
) -> V1dApar2matOutputs:
    """
    1dApar2mat
    
    Computes the affine transformation matrix from the set of 3dAllineate
    parameters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        x_shift: x-shift in mm.
        y_shift: y-shift in mm.
        z_shift: z-shift in mm.
        z_angle: z-angle (roll) in degrees.
        x_angle: x-angle (pitch) in degrees.
        y_angle: y-angle (yaw) in degrees.
        x_scale: x-scale factor in [0.10,10.0].
        y_scale: y-scale factor in [0.10,10.0].
        z_scale: z-scale factor in [0.10,10.0].
        y_x_shear: y/x-shear factor in [-0.3333,0.3333].
        z_x_shear: z/x-shear factor in [-0.3333,0.3333].
        z_y_shear: z/y-shear factor in [-0.3333,0.3333].
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dApar2matOutputs`).
    """
    params = v_1d_apar2mat_params(
        x_shift=x_shift,
        y_shift=y_shift,
        z_shift=z_shift,
        z_angle=z_angle,
        x_angle=x_angle,
        y_angle=y_angle,
        x_scale=x_scale,
        y_scale=y_scale,
        z_scale=z_scale,
        y_x_shear=y_x_shear,
        z_x_shear=z_x_shear,
        z_y_shear=z_y_shear,
    )
    return v_1d_apar2mat_execute(params, runner)


__all__ = [
    "V1dApar2matOutputs",
    "V_1D_APAR2MAT_METADATA",
    "v_1d_apar2mat",
    "v_1d_apar2mat_execute",
    "v_1d_apar2mat_params",
]
