# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1D_ASTRIP_METADATA = Metadata(
    id="cd3707044d51e37b30b478fdfc860e9d133d8ffa.boutiques",
    name="1dAstrip",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dAstripParameters = typing.TypedDict('V1dAstripParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dAstrip"]],
    "infile": InputPathType,
})
V1dAstripParametersTagged = typing.TypedDict('V1dAstripParametersTagged', {
    "@type": typing.Literal["afni/1dAstrip"],
    "infile": InputPathType,
})


class V1dAstripOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dAstripParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output file with only numeric characters."""


def v_1d_astrip_params(
    infile: InputPathType,
) -> V1dAstripParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input file from which non-numeric characters will be stripped.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dAstrip",
        "infile": infile,
    }
    return params


def v_1d_astrip_cargs(
    params: V1dAstripParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dAstrip")
    cargs.append("< " + execution.input_file(params.get("infile", None)))
    return cargs


def v_1d_astrip_outputs(
    params: V1dAstripParameters,
    execution: Execution,
) -> V1dAstripOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dAstripOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file("[OUTPUT_FILE]"),
    )
    return ret


def v_1d_astrip_execute(
    params: V1dAstripParameters,
    runner: Runner | None = None,
) -> V1dAstripOutputs:
    """
    1dAstrip
    
    Strips non-numeric characters from a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dAstripOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1D_ASTRIP_METADATA)
    params = execution.params(params)
    cargs = v_1d_astrip_cargs(params, execution)
    ret = v_1d_astrip_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1d_astrip(
    infile: InputPathType,
    runner: Runner | None = None,
) -> V1dAstripOutputs:
    """
    1dAstrip
    
    Strips non-numeric characters from a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file from which non-numeric characters will be stripped.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dAstripOutputs`).
    """
    params = v_1d_astrip_params(
        infile=infile,
    )
    return v_1d_astrip_execute(params, runner)


__all__ = [
    "V1dAstripOutputs",
    "V_1D_ASTRIP_METADATA",
    "v_1d_astrip",
    "v_1d_astrip_execute",
    "v_1d_astrip_params",
]
