# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1D_RPLOT_METADATA = Metadata(
    id="ada833cf3639916d08dbfba7a7122aa08a2a9451.boutiques",
    name="1dRplot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dRplotParameters = typing.TypedDict('V1dRplotParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dRplot"]],
    "input_file": InputPathType,
    "output_prefix": typing.NotRequired[str | None],
    "save_size": typing.NotRequired[list[float] | None],
    "TR": typing.NotRequired[float | None],
    "title": typing.NotRequired[str | None],
    "input_type": typing.NotRequired[typing.Literal["VOLREG", "XMAT"] | None],
    "legend_font_size": typing.NotRequired[float | None],
    "left_y_margin_text": typing.NotRequired[str | None],
    "right_y_margin_text": typing.NotRequired[str | None],
    "x_axis_label": typing.NotRequired[str | None],
    "y_axis_label": typing.NotRequired[str | None],
    "x_axis_range": typing.NotRequired[list[float] | None],
    "y_axis_range": typing.NotRequired[list[float] | None],
    "plot_char": typing.NotRequired[list[str] | None],
    "group_labels": typing.NotRequired[list[str] | None],
    "legend_show": bool,
    "legend_position": typing.NotRequired[typing.Literal["bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center"] | None],
    "save_plot": bool,
    "column_name_show": bool,
})
V1dRplotParametersTagged = typing.TypedDict('V1dRplotParametersTagged', {
    "@type": typing.Literal["afni/1dRplot"],
    "input_file": InputPathType,
    "output_prefix": typing.NotRequired[str | None],
    "save_size": typing.NotRequired[list[float] | None],
    "TR": typing.NotRequired[float | None],
    "title": typing.NotRequired[str | None],
    "input_type": typing.NotRequired[typing.Literal["VOLREG", "XMAT"] | None],
    "legend_font_size": typing.NotRequired[float | None],
    "left_y_margin_text": typing.NotRequired[str | None],
    "right_y_margin_text": typing.NotRequired[str | None],
    "x_axis_label": typing.NotRequired[str | None],
    "y_axis_label": typing.NotRequired[str | None],
    "x_axis_range": typing.NotRequired[list[float] | None],
    "y_axis_range": typing.NotRequired[list[float] | None],
    "plot_char": typing.NotRequired[list[str] | None],
    "group_labels": typing.NotRequired[list[str] | None],
    "legend_show": bool,
    "legend_position": typing.NotRequired[typing.Literal["bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center"] | None],
    "save_plot": bool,
    "column_name_show": bool,
})


class V1dRplotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dRplotParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_plot: OutputPathType | None
    """Output plot file"""


def v_1d_rplot_params(
    input_file: InputPathType,
    output_prefix: str | None = None,
    save_size: list[float] | None = None,
    tr: float | None = None,
    title: str | None = None,
    input_type: typing.Literal["VOLREG", "XMAT"] | None = None,
    legend_font_size: float | None = None,
    left_y_margin_text: str | None = None,
    right_y_margin_text: str | None = None,
    x_axis_label: str | None = None,
    y_axis_label: str | None = None,
    x_axis_range: list[float] | None = None,
    y_axis_range: list[float] | None = None,
    plot_char: list[str] | None = None,
    group_labels: list[str] | None = None,
    legend_show: bool = False,
    legend_position: typing.Literal["bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center"] | None = None,
    save_plot: bool = False,
    column_name_show: bool = False,
) -> V1dRplotParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input 1D file to plot.
        output_prefix: Output prefix. See also -save.
        save_size: Save figure size in pixels. Default is 2000 2000.
        tr: Sampling period, in seconds.
        title: Graph title. File name is used by default. Use NONE to be sure\
            no title is used.
        input_type: Type of data in 1D file. Choose from 'VOLREG' or 'XMAT'.
        legend_font_size: Font size for legend text.
        left_y_margin_text: Text to be placed at left Y margin. You need one\
            string per column.
        right_y_margin_text: Text to be placed at right Y margin. You need one\
            string per column.
        x_axis_label: Labels for the X axis.
        y_axis_label: Labels for the Y axis.
        x_axis_range: Range of X axis. STEP is optional.
        y_axis_range: Range of Y axis. STEP is optional.
        plot_char: Symbols for each column in input.
        group_labels: Legends assigned to each group. Default is no labeling.
        legend_show: Show legend.
        legend_position: Legend position. Choose from: bottomright, bottom,\
            bottomleft, left, topleft, top, topright, right, center.
        save_plot: Save plot and quit. No need for -prefix with this option.
        column_name_show: Show names of column in input.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dRplot",
        "input_file": input_file,
        "legend_show": legend_show,
        "save_plot": save_plot,
        "column_name_show": column_name_show,
    }
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    if save_size is not None:
        params["save_size"] = save_size
    if tr is not None:
        params["TR"] = tr
    if title is not None:
        params["title"] = title
    if input_type is not None:
        params["input_type"] = input_type
    if legend_font_size is not None:
        params["legend_font_size"] = legend_font_size
    if left_y_margin_text is not None:
        params["left_y_margin_text"] = left_y_margin_text
    if right_y_margin_text is not None:
        params["right_y_margin_text"] = right_y_margin_text
    if x_axis_label is not None:
        params["x_axis_label"] = x_axis_label
    if y_axis_label is not None:
        params["y_axis_label"] = y_axis_label
    if x_axis_range is not None:
        params["x_axis_range"] = x_axis_range
    if y_axis_range is not None:
        params["y_axis_range"] = y_axis_range
    if plot_char is not None:
        params["plot_char"] = plot_char
    if group_labels is not None:
        params["group_labels"] = group_labels
    if legend_position is not None:
        params["legend_position"] = legend_position
    return params


def v_1d_rplot_cargs(
    params: V1dRplotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dRplot")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    if params.get("save_size", None) is not None:
        cargs.extend([
            "-save.size",
            *map(str, params.get("save_size", None))
        ])
    if params.get("TR", None) is not None:
        cargs.extend([
            "-TR",
            str(params.get("TR", None))
        ])
    if params.get("title", None) is not None:
        cargs.extend([
            "-title",
            params.get("title", None)
        ])
    if params.get("input_type", None) is not None:
        cargs.extend([
            "-input_type",
            params.get("input_type", None)
        ])
    if params.get("legend_font_size", None) is not None:
        cargs.extend([
            "-leg.fontsize",
            str(params.get("legend_font_size", None))
        ])
    if params.get("left_y_margin_text", None) is not None:
        cargs.extend([
            "-col.text.lym",
            params.get("left_y_margin_text", None)
        ])
    if params.get("right_y_margin_text", None) is not None:
        cargs.extend([
            "-col.text.rym",
            params.get("right_y_margin_text", None)
        ])
    if params.get("x_axis_label", None) is not None:
        cargs.extend([
            "-xax.label",
            params.get("x_axis_label", None)
        ])
    if params.get("y_axis_label", None) is not None:
        cargs.extend([
            "-yax.label",
            params.get("y_axis_label", None)
        ])
    if params.get("x_axis_range", None) is not None:
        cargs.extend([
            "-xax.lim",
            *map(str, params.get("x_axis_range", None))
        ])
    if params.get("y_axis_range", None) is not None:
        cargs.extend([
            "-yax.lim",
            *map(str, params.get("y_axis_range", None))
        ])
    if params.get("plot_char", None) is not None:
        cargs.extend([
            "-col.plot.char",
            *params.get("plot_char", None)
        ])
    if params.get("group_labels", None) is not None:
        cargs.extend([
            "-grp.label",
            *params.get("group_labels", None)
        ])
    if params.get("legend_show", False):
        cargs.append("-leg.show")
    if params.get("legend_position", None) is not None:
        cargs.extend([
            "-leg.position",
            params.get("legend_position", None)
        ])
    if params.get("save_plot", False):
        cargs.append("-save")
    if params.get("column_name_show", False):
        cargs.append("-col.name.show")
    return cargs


def v_1d_rplot_outputs(
    params: V1dRplotParameters,
    execution: Execution,
) -> V1dRplotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dRplotOutputs(
        root=execution.output_file("."),
        output_plot=execution.output_file(params.get("output_prefix", None) + ".jpg") if (params.get("output_prefix") is not None) else None,
    )
    return ret


def v_1d_rplot_execute(
    params: V1dRplotParameters,
    runner: Runner | None = None,
) -> V1dRplotOutputs:
    """
    1dRplot
    
    Program for plotting a 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dRplotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1D_RPLOT_METADATA)
    params = execution.params(params)
    cargs = v_1d_rplot_cargs(params, execution)
    ret = v_1d_rplot_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1d_rplot(
    input_file: InputPathType,
    output_prefix: str | None = None,
    save_size: list[float] | None = None,
    tr: float | None = None,
    title: str | None = None,
    input_type: typing.Literal["VOLREG", "XMAT"] | None = None,
    legend_font_size: float | None = None,
    left_y_margin_text: str | None = None,
    right_y_margin_text: str | None = None,
    x_axis_label: str | None = None,
    y_axis_label: str | None = None,
    x_axis_range: list[float] | None = None,
    y_axis_range: list[float] | None = None,
    plot_char: list[str] | None = None,
    group_labels: list[str] | None = None,
    legend_show: bool = False,
    legend_position: typing.Literal["bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center"] | None = None,
    save_plot: bool = False,
    column_name_show: bool = False,
    runner: Runner | None = None,
) -> V1dRplotOutputs:
    """
    1dRplot
    
    Program for plotting a 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input 1D file to plot.
        output_prefix: Output prefix. See also -save.
        save_size: Save figure size in pixels. Default is 2000 2000.
        tr: Sampling period, in seconds.
        title: Graph title. File name is used by default. Use NONE to be sure\
            no title is used.
        input_type: Type of data in 1D file. Choose from 'VOLREG' or 'XMAT'.
        legend_font_size: Font size for legend text.
        left_y_margin_text: Text to be placed at left Y margin. You need one\
            string per column.
        right_y_margin_text: Text to be placed at right Y margin. You need one\
            string per column.
        x_axis_label: Labels for the X axis.
        y_axis_label: Labels for the Y axis.
        x_axis_range: Range of X axis. STEP is optional.
        y_axis_range: Range of Y axis. STEP is optional.
        plot_char: Symbols for each column in input.
        group_labels: Legends assigned to each group. Default is no labeling.
        legend_show: Show legend.
        legend_position: Legend position. Choose from: bottomright, bottom,\
            bottomleft, left, topleft, top, topright, right, center.
        save_plot: Save plot and quit. No need for -prefix with this option.
        column_name_show: Show names of column in input.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dRplotOutputs`).
    """
    params = v_1d_rplot_params(
        input_file=input_file,
        output_prefix=output_prefix,
        save_size=save_size,
        tr=tr,
        title=title,
        input_type=input_type,
        legend_font_size=legend_font_size,
        left_y_margin_text=left_y_margin_text,
        right_y_margin_text=right_y_margin_text,
        x_axis_label=x_axis_label,
        y_axis_label=y_axis_label,
        x_axis_range=x_axis_range,
        y_axis_range=y_axis_range,
        plot_char=plot_char,
        group_labels=group_labels,
        legend_show=legend_show,
        legend_position=legend_position,
        save_plot=save_plot,
        column_name_show=column_name_show,
    )
    return v_1d_rplot_execute(params, runner)


__all__ = [
    "V1dRplotOutputs",
    "V_1D_RPLOT_METADATA",
    "v_1d_rplot",
    "v_1d_rplot_execute",
    "v_1d_rplot_params",
]
