# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1D_SEM_METADATA = Metadata(
    id="6575bee84394160db744d2f6c5c4fb4c754de905.boutiques",
    name="1dSEM",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dSemParameters = typing.TypedDict('V1dSemParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dSEM"]],
    "theta": InputPathType,
    "correlation_matrix": InputPathType,
    "residual_variance": InputPathType,
    "degrees_of_freedom": float,
    "max_iterations": typing.NotRequired[int | None],
    "number_random_trials": typing.NotRequired[int | None],
    "limits": typing.NotRequired[list[float] | None],
    "calculate_cost": bool,
    "verbose": typing.NotRequired[int | None],
    "tree_growth": bool,
    "model_search": bool,
    "max_paths": typing.NotRequired[int | None],
    "stop_cost": typing.NotRequired[float | None],
    "forest_growth": bool,
    "grow_all": bool,
    "leafpicker": bool,
})
V1dSemParametersTagged = typing.TypedDict('V1dSemParametersTagged', {
    "@type": typing.Literal["afni/1dSEM"],
    "theta": InputPathType,
    "correlation_matrix": InputPathType,
    "residual_variance": InputPathType,
    "degrees_of_freedom": float,
    "max_iterations": typing.NotRequired[int | None],
    "number_random_trials": typing.NotRequired[int | None],
    "limits": typing.NotRequired[list[float] | None],
    "calculate_cost": bool,
    "verbose": typing.NotRequired[int | None],
    "tree_growth": bool,
    "model_search": bool,
    "max_paths": typing.NotRequired[int | None],
    "stop_cost": typing.NotRequired[float | None],
    "forest_growth": bool,
    "grow_all": bool,
    "leafpicker": bool,
})


class V1dSemOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dSemParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output printed to the terminal. This file may be redirected."""


def v_1d_sem_params(
    theta: InputPathType,
    correlation_matrix: InputPathType,
    residual_variance: InputPathType,
    degrees_of_freedom: float,
    max_iterations: int | None = None,
    number_random_trials: int | None = None,
    limits: list[float] | None = None,
    calculate_cost: bool = False,
    verbose: int | None = None,
    tree_growth: bool = False,
    model_search: bool = False,
    max_paths: int | None = None,
    stop_cost: float | None = None,
    forest_growth: bool = False,
    grow_all: bool = False,
    leafpicker: bool = False,
) -> V1dSemParametersTagged:
    """
    Build parameters.
    
    Args:
        theta: Connection matrix 1D file with initial representation.
        correlation_matrix: Correlation matrix 1D file.
        residual_variance: Residual variance vector 1D file.
        degrees_of_freedom: Degrees of freedom.
        max_iterations: Maximum number of iterations for convergence\
            (Default=10000). Values can range from 1 to any positive integer less\
            than 10000.
        number_random_trials: Number of random trials before optimization\
            (Default = 100).
        limits: Lower and upper limits for connection coefficients (Default =\
            -1.0 to 1.0).
        calculate_cost: No modeling at all, just calculate the cost function\
            for the coefficients as given in the theta file.
        verbose: Print info every nnnnn steps.
        tree_growth: Search for best model by growing a model for one\
            additional coefficient from the previous model for n-1 coefficients.
        model_search: Search for best model by growing a model for one\
            additional coefficient from the previous model for n-1 coefficients.
        max_paths: Maximum number of paths to include (Default = 1000).
        stop_cost: Stop searching for paths when cost function is below this\
            value (Default = 0.1).
        forest_growth: Search over all possible models by comparing models at\
            incrementally increasing number of path coefficients.
        grow_all: Search over all possible models by comparing models at\
            incrementally increasing number of path coefficients.
        leafpicker: Expands the search optimization to look at multiple paths\
            to avoid local minimum. This method is the default technique for tree\
            growth and standard coefficient searches.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dSEM",
        "theta": theta,
        "correlation_matrix": correlation_matrix,
        "residual_variance": residual_variance,
        "degrees_of_freedom": degrees_of_freedom,
        "calculate_cost": calculate_cost,
        "tree_growth": tree_growth,
        "model_search": model_search,
        "forest_growth": forest_growth,
        "grow_all": grow_all,
        "leafpicker": leafpicker,
    }
    if max_iterations is not None:
        params["max_iterations"] = max_iterations
    if number_random_trials is not None:
        params["number_random_trials"] = number_random_trials
    if limits is not None:
        params["limits"] = limits
    if verbose is not None:
        params["verbose"] = verbose
    if max_paths is not None:
        params["max_paths"] = max_paths
    if stop_cost is not None:
        params["stop_cost"] = stop_cost
    return params


def v_1d_sem_cargs(
    params: V1dSemParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dSEM")
    cargs.extend([
        "-theta",
        execution.input_file(params.get("theta", None))
    ])
    cargs.extend([
        "-C",
        execution.input_file(params.get("correlation_matrix", None))
    ])
    cargs.extend([
        "-psi",
        execution.input_file(params.get("residual_variance", None))
    ])
    cargs.extend([
        "-DF",
        str(params.get("degrees_of_freedom", None))
    ])
    if params.get("max_iterations", None) is not None:
        cargs.extend([
            "-max_iter",
            str(params.get("max_iterations", None))
        ])
    if params.get("number_random_trials", None) is not None:
        cargs.extend([
            "-nrand",
            str(params.get("number_random_trials", None))
        ])
    if params.get("limits", None) is not None:
        cargs.extend([
            "-limits",
            *map(str, params.get("limits", None))
        ])
    if params.get("calculate_cost", False):
        cargs.append("-calccost")
    if params.get("verbose", None) is not None:
        cargs.extend([
            "-verbose",
            str(params.get("verbose", None))
        ])
    if params.get("tree_growth", False):
        cargs.append("-tree_growth")
    if params.get("model_search", False):
        cargs.append("-model_search")
    if params.get("max_paths", None) is not None:
        cargs.extend([
            "-max_paths",
            str(params.get("max_paths", None))
        ])
    if params.get("stop_cost", None) is not None:
        cargs.extend([
            "-stop_cost",
            str(params.get("stop_cost", None))
        ])
    if params.get("forest_growth", False):
        cargs.append("-forest_growth")
    if params.get("grow_all", False):
        cargs.append("-grow_all")
    if params.get("leafpicker", False):
        cargs.append("-leafpicker")
    return cargs


def v_1d_sem_outputs(
    params: V1dSemParameters,
    execution: Execution,
) -> V1dSemOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dSemOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("output.txt"),
    )
    return ret


def v_1d_sem_execute(
    params: V1dSemParameters,
    runner: Runner | None = None,
) -> V1dSemOutputs:
    """
    1dSEM
    
    Computes path coefficients for connection matrix in Structural Equation
    Modeling (SEM).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dSemOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1D_SEM_METADATA)
    params = execution.params(params)
    cargs = v_1d_sem_cargs(params, execution)
    ret = v_1d_sem_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1d_sem(
    theta: InputPathType,
    correlation_matrix: InputPathType,
    residual_variance: InputPathType,
    degrees_of_freedom: float,
    max_iterations: int | None = None,
    number_random_trials: int | None = None,
    limits: list[float] | None = None,
    calculate_cost: bool = False,
    verbose: int | None = None,
    tree_growth: bool = False,
    model_search: bool = False,
    max_paths: int | None = None,
    stop_cost: float | None = None,
    forest_growth: bool = False,
    grow_all: bool = False,
    leafpicker: bool = False,
    runner: Runner | None = None,
) -> V1dSemOutputs:
    """
    1dSEM
    
    Computes path coefficients for connection matrix in Structural Equation
    Modeling (SEM).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        theta: Connection matrix 1D file with initial representation.
        correlation_matrix: Correlation matrix 1D file.
        residual_variance: Residual variance vector 1D file.
        degrees_of_freedom: Degrees of freedom.
        max_iterations: Maximum number of iterations for convergence\
            (Default=10000). Values can range from 1 to any positive integer less\
            than 10000.
        number_random_trials: Number of random trials before optimization\
            (Default = 100).
        limits: Lower and upper limits for connection coefficients (Default =\
            -1.0 to 1.0).
        calculate_cost: No modeling at all, just calculate the cost function\
            for the coefficients as given in the theta file.
        verbose: Print info every nnnnn steps.
        tree_growth: Search for best model by growing a model for one\
            additional coefficient from the previous model for n-1 coefficients.
        model_search: Search for best model by growing a model for one\
            additional coefficient from the previous model for n-1 coefficients.
        max_paths: Maximum number of paths to include (Default = 1000).
        stop_cost: Stop searching for paths when cost function is below this\
            value (Default = 0.1).
        forest_growth: Search over all possible models by comparing models at\
            incrementally increasing number of path coefficients.
        grow_all: Search over all possible models by comparing models at\
            incrementally increasing number of path coefficients.
        leafpicker: Expands the search optimization to look at multiple paths\
            to avoid local minimum. This method is the default technique for tree\
            growth and standard coefficient searches.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dSemOutputs`).
    """
    params = v_1d_sem_params(
        theta=theta,
        correlation_matrix=correlation_matrix,
        residual_variance=residual_variance,
        degrees_of_freedom=degrees_of_freedom,
        max_iterations=max_iterations,
        number_random_trials=number_random_trials,
        limits=limits,
        calculate_cost=calculate_cost,
        verbose=verbose,
        tree_growth=tree_growth,
        model_search=model_search,
        max_paths=max_paths,
        stop_cost=stop_cost,
        forest_growth=forest_growth,
        grow_all=grow_all,
        leafpicker=leafpicker,
    )
    return v_1d_sem_execute(params, runner)


__all__ = [
    "V1dSemOutputs",
    "V_1D_SEM_METADATA",
    "v_1d_sem",
    "v_1d_sem_execute",
    "v_1d_sem_params",
]
