# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DCAT_METADATA = Metadata(
    id="d5f06271d13f8fe77a286910bcbb6e690805b779.boutiques",
    name="1dcat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dcatParameters = typing.TypedDict('V1dcatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dcat"]],
    "input_files": list[InputPathType],
    "tsv_output": bool,
    "csv_output": bool,
    "nonconst_output": bool,
    "nonfixed_output": bool,
    "number_format": typing.NotRequired[str | None],
    "stack_output": bool,
    "column_row_selection": typing.NotRequired[str | None],
    "ok_empty": bool,
})
V1dcatParametersTagged = typing.TypedDict('V1dcatParametersTagged', {
    "@type": typing.Literal["afni/1dcat"],
    "input_files": list[InputPathType],
    "tsv_output": bool,
    "csv_output": bool,
    "nonconst_output": bool,
    "nonfixed_output": bool,
    "number_format": typing.NotRequired[str | None],
    "stack_output": bool,
    "column_row_selection": typing.NotRequired[str | None],
    "ok_empty": bool,
})


class V1dcatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dcatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    concatenated_output: OutputPathType
    """Concatenated output in specified format"""


def v_1dcat_params(
    input_files: list[InputPathType],
    tsv_output: bool = False,
    csv_output: bool = False,
    nonconst_output: bool = False,
    nonfixed_output: bool = False,
    number_format: str | None = None,
    stack_output: bool = False,
    column_row_selection: str | None = None,
    ok_empty: bool = False,
) -> V1dcatParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input 1D or TSV/CSV files to concatenate.
        tsv_output: Output in TSV format with tabs as separators and a header\
            line.
        csv_output: Output in CSV format with commas as separators and a header\
            line.
        nonconst_output: Omit columns that are identically constant from the\
            output.
        nonfixed_output: Keep only columns marked as 'free' in the 3dAllineate\
            header.
        number_format: Specify the format of the numbers to be output.
        stack_output: Stack the columns of the resulting matrix in the output.
        column_row_selection: Apply the same column/row selection string to all\
            filenames on the command line.
        ok_empty: Exit quietly when encountering an empty file on disk.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dcat",
        "input_files": input_files,
        "tsv_output": tsv_output,
        "csv_output": csv_output,
        "nonconst_output": nonconst_output,
        "nonfixed_output": nonfixed_output,
        "stack_output": stack_output,
        "ok_empty": ok_empty,
    }
    if number_format is not None:
        params["number_format"] = number_format
    if column_row_selection is not None:
        params["column_row_selection"] = column_row_selection
    return params


def v_1dcat_cargs(
    params: V1dcatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dcat")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("tsv_output", False):
        cargs.append("-tsvout")
    if params.get("csv_output", False):
        cargs.append("-csvout")
    if params.get("nonconst_output", False):
        cargs.append("-nonconst")
    if params.get("nonfixed_output", False):
        cargs.append("-nonfixed")
    if params.get("number_format", None) is not None:
        cargs.extend([
            "-form",
            params.get("number_format", None)
        ])
    if params.get("stack_output", False):
        cargs.append("-stack")
    if params.get("column_row_selection", None) is not None:
        cargs.extend([
            "-sel",
            params.get("column_row_selection", None)
        ])
    if params.get("ok_empty", False):
        cargs.append("-OKempty")
    return cargs


def v_1dcat_outputs(
    params: V1dcatParameters,
    execution: Execution,
) -> V1dcatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dcatOutputs(
        root=execution.output_file("."),
        concatenated_output=execution.output_file("stdout"),
    )
    return ret


def v_1dcat_execute(
    params: V1dcatParameters,
    runner: Runner | None = None,
) -> V1dcatOutputs:
    """
    1dcat
    
    Concatenates columns of multiple 1D or TSV/CSV files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dcatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DCAT_METADATA)
    params = execution.params(params)
    cargs = v_1dcat_cargs(params, execution)
    ret = v_1dcat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dcat(
    input_files: list[InputPathType],
    tsv_output: bool = False,
    csv_output: bool = False,
    nonconst_output: bool = False,
    nonfixed_output: bool = False,
    number_format: str | None = None,
    stack_output: bool = False,
    column_row_selection: str | None = None,
    ok_empty: bool = False,
    runner: Runner | None = None,
) -> V1dcatOutputs:
    """
    1dcat
    
    Concatenates columns of multiple 1D or TSV/CSV files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input 1D or TSV/CSV files to concatenate.
        tsv_output: Output in TSV format with tabs as separators and a header\
            line.
        csv_output: Output in CSV format with commas as separators and a header\
            line.
        nonconst_output: Omit columns that are identically constant from the\
            output.
        nonfixed_output: Keep only columns marked as 'free' in the 3dAllineate\
            header.
        number_format: Specify the format of the numbers to be output.
        stack_output: Stack the columns of the resulting matrix in the output.
        column_row_selection: Apply the same column/row selection string to all\
            filenames on the command line.
        ok_empty: Exit quietly when encountering an empty file on disk.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dcatOutputs`).
    """
    params = v_1dcat_params(
        input_files=input_files,
        tsv_output=tsv_output,
        csv_output=csv_output,
        nonconst_output=nonconst_output,
        nonfixed_output=nonfixed_output,
        number_format=number_format,
        stack_output=stack_output,
        column_row_selection=column_row_selection,
        ok_empty=ok_empty,
    )
    return v_1dcat_execute(params, runner)


__all__ = [
    "V1dcatOutputs",
    "V_1DCAT_METADATA",
    "v_1dcat",
    "v_1dcat_execute",
    "v_1dcat_params",
]
