# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DGEN_ARMA11_METADATA = Metadata(
    id="ff8bfe0d494d40be078d851adeaa60fadc2b914e.boutiques",
    name="1dgenARMA11",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dgenArma11Parameters = typing.TypedDict('V1dgenArma11Parameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dgenARMA11"]],
    "length": typing.NotRequired[float | None],
    "length_alt": typing.NotRequired[float | None],
    "num_series": typing.NotRequired[float | None],
    "param_a": typing.NotRequired[float | None],
    "param_b": typing.NotRequired[float | None],
    "param_lam": typing.NotRequired[float | None],
    "std_dev": typing.NotRequired[float | None],
    "normalize": bool,
    "seed": typing.NotRequired[float | None],
    "corcut": typing.NotRequired[float | None],
    "arma31": typing.NotRequired[str | None],
    "arma51": typing.NotRequired[str | None],
})
V1dgenArma11ParametersTagged = typing.TypedDict('V1dgenArma11ParametersTagged', {
    "@type": typing.Literal["afni/1dgenARMA11"],
    "length": typing.NotRequired[float | None],
    "length_alt": typing.NotRequired[float | None],
    "num_series": typing.NotRequired[float | None],
    "param_a": typing.NotRequired[float | None],
    "param_b": typing.NotRequired[float | None],
    "param_lam": typing.NotRequired[float | None],
    "std_dev": typing.NotRequired[float | None],
    "normalize": bool,
    "seed": typing.NotRequired[float | None],
    "corcut": typing.NotRequired[float | None],
    "arma31": typing.NotRequired[str | None],
    "arma51": typing.NotRequired[str | None],
})


class V1dgenArma11Outputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dgenArma11Parameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output: OutputPathType
    """Generated ARMA(1,1) time series"""


def v_1dgen_arma11_params(
    length: float | None = None,
    length_alt: float | None = None,
    num_series: float | None = None,
    param_a: float | None = None,
    param_b: float | None = None,
    param_lam: float | None = None,
    std_dev: float | None = None,
    normalize: bool = False,
    seed: float | None = None,
    corcut: float | None = None,
    arma31: str | None = None,
    arma51: str | None = None,
) -> V1dgenArma11ParametersTagged:
    """
    Build parameters.
    
    Args:
        length: Specify the length of the time series vector to generate\
            (equivalent to -len option).
        length_alt: Specify the length of the time series vector to generate\
            (equivalent to -num option).
        num_series: The number of time series vectors to generate; defaults to\
            1 if not given.
        param_a: Specify ARMA(1,1) parameters 'a'.
        param_b: Specify ARMA(1,1) parameter 'b' directly.
        param_lam: Specify ARMA(1,1) parameter 'b' indirectly.
        std_dev: Set standard deviation of results [default=1].
        normalize: Normalize time series so sum of squares is 1.
        seed: Set random number seed.
        corcut: Specify a cutoff for the correlation coefficient r(k) of noise\
            samples at k units apart. Default is 0.00010.
        arma31: Specify parameters for a restricted ARMA(3,1) model: -arma31 a\
            r theta vrat.
        arma51: Specify parameters for a restricted ARMA(5,1) model: -arma51 a\
            r1 theta1 r2 theta2 vrat.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dgenARMA11",
        "normalize": normalize,
    }
    if length is not None:
        params["length"] = length
    if length_alt is not None:
        params["length_alt"] = length_alt
    if num_series is not None:
        params["num_series"] = num_series
    if param_a is not None:
        params["param_a"] = param_a
    if param_b is not None:
        params["param_b"] = param_b
    if param_lam is not None:
        params["param_lam"] = param_lam
    if std_dev is not None:
        params["std_dev"] = std_dev
    if seed is not None:
        params["seed"] = seed
    if corcut is not None:
        params["corcut"] = corcut
    if arma31 is not None:
        params["arma31"] = arma31
    if arma51 is not None:
        params["arma51"] = arma51
    return params


def v_1dgen_arma11_cargs(
    params: V1dgenArma11Parameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dgenARMA11")
    if params.get("length", None) is not None:
        cargs.extend([
            "-num",
            str(params.get("length", None))
        ])
    if params.get("length_alt", None) is not None:
        cargs.extend([
            "-len",
            str(params.get("length_alt", None))
        ])
    if params.get("num_series", None) is not None:
        cargs.extend([
            "-nvec",
            str(params.get("num_series", None))
        ])
    if params.get("param_a", None) is not None:
        cargs.extend([
            "-a",
            str(params.get("param_a", None))
        ])
    if params.get("param_b", None) is not None:
        cargs.extend([
            "-b",
            str(params.get("param_b", None))
        ])
    if params.get("param_lam", None) is not None:
        cargs.extend([
            "-lam",
            str(params.get("param_lam", None))
        ])
    if params.get("std_dev", None) is not None:
        cargs.extend([
            "-sig",
            str(params.get("std_dev", None))
        ])
    if params.get("normalize", False):
        cargs.append("-norm")
    if params.get("seed", None) is not None:
        cargs.extend([
            "-seed",
            str(params.get("seed", None))
        ])
    if params.get("corcut", None) is not None:
        cargs.extend([
            "-CORcut",
            str(params.get("corcut", None))
        ])
    if params.get("arma31", None) is not None:
        cargs.extend([
            "-arma31",
            params.get("arma31", None)
        ])
    if params.get("arma51", None) is not None:
        cargs.extend([
            "-arma51",
            params.get("arma51", None)
        ])
    return cargs


def v_1dgen_arma11_outputs(
    params: V1dgenArma11Parameters,
    execution: Execution,
) -> V1dgenArma11Outputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dgenArma11Outputs(
        root=execution.output_file("."),
        output=execution.output_file("stdout"),
    )
    return ret


def v_1dgen_arma11_execute(
    params: V1dgenArma11Parameters,
    runner: Runner | None = None,
) -> V1dgenArma11Outputs:
    """
    1dgenARMA11
    
    Program to generate an ARMA(1,1) time series, for simulation studies.
    Results are written to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dgenArma11Outputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DGEN_ARMA11_METADATA)
    params = execution.params(params)
    cargs = v_1dgen_arma11_cargs(params, execution)
    ret = v_1dgen_arma11_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dgen_arma11(
    length: float | None = None,
    length_alt: float | None = None,
    num_series: float | None = None,
    param_a: float | None = None,
    param_b: float | None = None,
    param_lam: float | None = None,
    std_dev: float | None = None,
    normalize: bool = False,
    seed: float | None = None,
    corcut: float | None = None,
    arma31: str | None = None,
    arma51: str | None = None,
    runner: Runner | None = None,
) -> V1dgenArma11Outputs:
    """
    1dgenARMA11
    
    Program to generate an ARMA(1,1) time series, for simulation studies.
    Results are written to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        length: Specify the length of the time series vector to generate\
            (equivalent to -len option).
        length_alt: Specify the length of the time series vector to generate\
            (equivalent to -num option).
        num_series: The number of time series vectors to generate; defaults to\
            1 if not given.
        param_a: Specify ARMA(1,1) parameters 'a'.
        param_b: Specify ARMA(1,1) parameter 'b' directly.
        param_lam: Specify ARMA(1,1) parameter 'b' indirectly.
        std_dev: Set standard deviation of results [default=1].
        normalize: Normalize time series so sum of squares is 1.
        seed: Set random number seed.
        corcut: Specify a cutoff for the correlation coefficient r(k) of noise\
            samples at k units apart. Default is 0.00010.
        arma31: Specify parameters for a restricted ARMA(3,1) model: -arma31 a\
            r theta vrat.
        arma51: Specify parameters for a restricted ARMA(5,1) model: -arma51 a\
            r1 theta1 r2 theta2 vrat.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dgenArma11Outputs`).
    """
    params = v_1dgen_arma11_params(
        length=length,
        length_alt=length_alt,
        num_series=num_series,
        param_a=param_a,
        param_b=param_b,
        param_lam=param_lam,
        std_dev=std_dev,
        normalize=normalize,
        seed=seed,
        corcut=corcut,
        arma31=arma31,
        arma51=arma51,
    )
    return v_1dgen_arma11_execute(params, runner)


__all__ = [
    "V1dgenArma11Outputs",
    "V_1DGEN_ARMA11_METADATA",
    "v_1dgen_arma11",
    "v_1dgen_arma11_execute",
    "v_1dgen_arma11_params",
]
