# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DGRAYPLOT_METADATA = Metadata(
    id="1671e36eb3ebce31da681edce7afe7614f8969c2.boutiques",
    name="1dgrayplot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dgrayplotParameters = typing.TypedDict('V1dgrayplotParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dgrayplot"]],
    "tsfile": InputPathType,
    "install": bool,
    "ignore": typing.NotRequired[float | None],
    "flip": bool,
    "sep": bool,
    "use": typing.NotRequired[float | None],
    "ps": bool,
})
V1dgrayplotParametersTagged = typing.TypedDict('V1dgrayplotParametersTagged', {
    "@type": typing.Literal["afni/1dgrayplot"],
    "tsfile": InputPathType,
    "install": bool,
    "ignore": typing.NotRequired[float | None],
    "flip": bool,
    "sep": bool,
    "use": typing.NotRequired[float | None],
    "ps": bool,
})


class V1dgrayplotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dgrayplotParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_1dgrayplot_params(
    tsfile: InputPathType,
    install: bool = False,
    ignore: float | None = None,
    flip: bool = False,
    sep: bool = False,
    use: float | None = None,
    ps: bool = False,
) -> V1dgrayplotParametersTagged:
    """
    Build parameters.
    
    Args:
        tsfile: Input time series file (*.1D format).
        install: Install a new X11 colormap (for X11 PseudoColor).
        ignore: Skip first 'nn' rows in the input file [default = 0].
        flip: Plot x and y axes interchanged [default: data columns plotted\
            DOWN the screen].
        sep: Separate scales for each column.
        use: Plot 'mm' points [default: all of them].
        ps: Don't draw plot in a window; write it to stdout in PostScript\
            format.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dgrayplot",
        "tsfile": tsfile,
        "install": install,
        "flip": flip,
        "sep": sep,
        "ps": ps,
    }
    if ignore is not None:
        params["ignore"] = ignore
    if use is not None:
        params["use"] = use
    return params


def v_1dgrayplot_cargs(
    params: V1dgrayplotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dgrayplot")
    cargs.append(execution.input_file(params.get("tsfile", None)))
    if params.get("install", False):
        cargs.append("-install")
    if params.get("ignore", None) is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore", None))
        ])
    if params.get("flip", False):
        cargs.append("-flip")
    if params.get("sep", False):
        cargs.append("-sep")
    if params.get("use", None) is not None:
        cargs.extend([
            "-use",
            str(params.get("use", None))
        ])
    if params.get("ps", False):
        cargs.append("-ps")
    return cargs


def v_1dgrayplot_outputs(
    params: V1dgrayplotParameters,
    execution: Execution,
) -> V1dgrayplotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dgrayplotOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_1dgrayplot_execute(
    params: V1dgrayplotParameters,
    runner: Runner | None = None,
) -> V1dgrayplotOutputs:
    """
    1dgrayplot
    
    Graphs the columns of a *.1D type time series file to the screen in
    grayscale.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dgrayplotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DGRAYPLOT_METADATA)
    params = execution.params(params)
    cargs = v_1dgrayplot_cargs(params, execution)
    ret = v_1dgrayplot_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dgrayplot(
    tsfile: InputPathType,
    install: bool = False,
    ignore: float | None = None,
    flip: bool = False,
    sep: bool = False,
    use: float | None = None,
    ps: bool = False,
    runner: Runner | None = None,
) -> V1dgrayplotOutputs:
    """
    1dgrayplot
    
    Graphs the columns of a *.1D type time series file to the screen in
    grayscale.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tsfile: Input time series file (*.1D format).
        install: Install a new X11 colormap (for X11 PseudoColor).
        ignore: Skip first 'nn' rows in the input file [default = 0].
        flip: Plot x and y axes interchanged [default: data columns plotted\
            DOWN the screen].
        sep: Separate scales for each column.
        use: Plot 'mm' points [default: all of them].
        ps: Don't draw plot in a window; write it to stdout in PostScript\
            format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dgrayplotOutputs`).
    """
    params = v_1dgrayplot_params(
        tsfile=tsfile,
        install=install,
        ignore=ignore,
        flip=flip,
        sep=sep,
        use=use,
        ps=ps,
    )
    return v_1dgrayplot_execute(params, runner)


__all__ = [
    "V1dgrayplotOutputs",
    "V_1DGRAYPLOT_METADATA",
    "v_1dgrayplot",
    "v_1dgrayplot_execute",
    "v_1dgrayplot_params",
]
