# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DMATCALC_METADATA = Metadata(
    id="3d885ad283a58a557b3d058e1282611af7f67092.boutiques",
    name="1dmatcalc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dmatcalcParameters = typing.TypedDict('V1dmatcalcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dmatcalc"]],
    "expression": typing.NotRequired[str | None],
})
V1dmatcalcParametersTagged = typing.TypedDict('V1dmatcalcParametersTagged', {
    "@type": typing.Literal["afni/1dmatcalc"],
    "expression": typing.NotRequired[str | None],
})


class V1dmatcalcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dmatcalcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output file resulting from the evaluated expression"""


def v_1dmatcalc_params(
    expression: str | None = None,
) -> V1dmatcalcParametersTagged:
    """
    Build parameters.
    
    Args:
        expression: Expression to evaluate the RPN matrix-valued operations.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dmatcalc",
    }
    if expression is not None:
        params["expression"] = expression
    return params


def v_1dmatcalc_cargs(
    params: V1dmatcalcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dmatcalc")
    if params.get("expression", None) is not None:
        cargs.append(params.get("expression", None))
    return cargs


def v_1dmatcalc_outputs(
    params: V1dmatcalcParameters,
    execution: Execution,
) -> V1dmatcalcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dmatcalcOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("[OUTPUT_FILE]"),
    )
    return ret


def v_1dmatcalc_execute(
    params: V1dmatcalcParameters,
    runner: Runner | None = None,
) -> V1dmatcalcOutputs:
    """
    1dmatcalc
    
    A tool to evaluate space-delimited RPN (Reverse Polish Notation)
    matrix-valued expressions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dmatcalcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DMATCALC_METADATA)
    params = execution.params(params)
    cargs = v_1dmatcalc_cargs(params, execution)
    ret = v_1dmatcalc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dmatcalc(
    expression: str | None = None,
    runner: Runner | None = None,
) -> V1dmatcalcOutputs:
    """
    1dmatcalc
    
    A tool to evaluate space-delimited RPN (Reverse Polish Notation)
    matrix-valued expressions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        expression: Expression to evaluate the RPN matrix-valued operations.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dmatcalcOutputs`).
    """
    params = v_1dmatcalc_params(
        expression=expression,
    )
    return v_1dmatcalc_execute(params, runner)


__all__ = [
    "V1dmatcalcOutputs",
    "V_1DMATCALC_METADATA",
    "v_1dmatcalc",
    "v_1dmatcalc_execute",
    "v_1dmatcalc_params",
]
