# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DPLOT_PY_METADATA = Metadata(
    id="54469a5d1d850e8fb26589beb5a767a8545a6eec.boutiques",
    name="1dplot.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dplotPyParameters = typing.TypedDict('V1dplotPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dplot.py"]],
    "infiles": list[InputPathType],
    "prefix": str,
    "help": bool,
    "boxplot_on": bool,
    "bplot_view": typing.NotRequired[str | None],
    "margin_off": bool,
    "scale": typing.NotRequired[list[str] | None],
    "xfile": typing.NotRequired[InputPathType | None],
    "xvals": typing.NotRequired[list[float] | None],
    "yaxis": typing.NotRequired[list[str] | None],
    "ylabels": typing.NotRequired[list[str] | None],
    "ylabels_maxlen": typing.NotRequired[float | None],
    "legend_on": bool,
    "legend_labels": typing.NotRequired[list[str] | None],
    "legend_locs": typing.NotRequired[list[str] | None],
    "xlabel": typing.NotRequired[str | None],
    "title": typing.NotRequired[str | None],
    "reverse_order": bool,
    "sepscl": bool,
    "one_graph": bool,
    "dpi": typing.NotRequired[float | None],
    "figsize": typing.NotRequired[list[float] | None],
    "fontsize": typing.NotRequired[float | None],
    "fontfamily": typing.NotRequired[str | None],
    "fontstyles": typing.NotRequired[str | None],
    "colors": typing.NotRequired[list[str] | None],
    "patches": typing.NotRequired[list[str] | None],
    "censor_trs": typing.NotRequired[list[str] | None],
    "censor_files": typing.NotRequired[list[InputPathType] | None],
    "censor_hline": typing.NotRequired[list[str] | None],
    "censor_rgb": typing.NotRequired[str | None],
    "bkgd_color": typing.NotRequired[str | None],
})
V1dplotPyParametersTagged = typing.TypedDict('V1dplotPyParametersTagged', {
    "@type": typing.Literal["afni/1dplot.py"],
    "infiles": list[InputPathType],
    "prefix": str,
    "help": bool,
    "boxplot_on": bool,
    "bplot_view": typing.NotRequired[str | None],
    "margin_off": bool,
    "scale": typing.NotRequired[list[str] | None],
    "xfile": typing.NotRequired[InputPathType | None],
    "xvals": typing.NotRequired[list[float] | None],
    "yaxis": typing.NotRequired[list[str] | None],
    "ylabels": typing.NotRequired[list[str] | None],
    "ylabels_maxlen": typing.NotRequired[float | None],
    "legend_on": bool,
    "legend_labels": typing.NotRequired[list[str] | None],
    "legend_locs": typing.NotRequired[list[str] | None],
    "xlabel": typing.NotRequired[str | None],
    "title": typing.NotRequired[str | None],
    "reverse_order": bool,
    "sepscl": bool,
    "one_graph": bool,
    "dpi": typing.NotRequired[float | None],
    "figsize": typing.NotRequired[list[float] | None],
    "fontsize": typing.NotRequired[float | None],
    "fontfamily": typing.NotRequired[str | None],
    "fontstyles": typing.NotRequired[str | None],
    "colors": typing.NotRequired[list[str] | None],
    "patches": typing.NotRequired[list[str] | None],
    "censor_trs": typing.NotRequired[list[str] | None],
    "censor_files": typing.NotRequired[list[InputPathType] | None],
    "censor_hline": typing.NotRequired[list[str] | None],
    "censor_rgb": typing.NotRequired[str | None],
    "bkgd_color": typing.NotRequired[str | None],
})


class V1dplotPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dplotPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image: OutputPathType
    """Output image file, default to .jpg"""


def v_1dplot_py_params(
    infiles: list[InputPathType],
    prefix: str,
    help_: bool = False,
    boxplot_on: bool = False,
    bplot_view: str | None = None,
    margin_off: bool = False,
    scale: list[str] | None = None,
    xfile: InputPathType | None = None,
    xvals: list[float] | None = None,
    yaxis: list[str] | None = None,
    ylabels: list[str] | None = None,
    ylabels_maxlen: float | None = None,
    legend_on: bool = False,
    legend_labels: list[str] | None = None,
    legend_locs: list[str] | None = None,
    xlabel: str | None = None,
    title: str | None = None,
    reverse_order: bool = False,
    sepscl: bool = False,
    one_graph: bool = False,
    dpi: float | None = None,
    figsize: list[float] | None = None,
    fontsize: float | None = None,
    fontfamily: str | None = None,
    fontstyles: str | None = None,
    colors: list[str] | None = None,
    patches: list[str] | None = None,
    censor_trs: list[str] | None = None,
    censor_files: list[InputPathType] | None = None,
    censor_hline: list[str] | None = None,
    censor_rgb: str | None = None,
    bkgd_color: str | None = None,
) -> V1dplotPyParametersTagged:
    """
    Build parameters.
    
    Args:
        infiles: One or more file names of text files. Each column in this file\
            will be treated as a separate time series for plotting.
        prefix: Output filename or prefix. Default output image type is .jpg.
        help_: See helpfile.
        boxplot_on: A fun feature to show an additional boxplot adjacent to\
            each time series.
        bplot_view: Adjust view for boxplots when using censoring.
        margin_off: Fill the plot frame completely, thus no labels, frame, or\
            titles will be visible.
        scale: Provide a list of scales to apply to the y-values.
        xfile: One way to input x-values explicitly: as a "1D" file containing\
            a single file of numbers.
        xvals: Provide exactly 3 numbers for x-values: start, stop, and\
            stepsize.
        yaxis: Optional range for each 'infile' y-axis.
        ylabels: Optional text labels for each 'infile' column.
        ylabels_maxlen: allows y-axis labels to wrap into multiple rows, each\
            of length <= which the user can decide.
        legend_on: Turn on the plotting of a legend in the plot(s).
        legend_labels: Optional legend labels, if using '-legend_on'.
        legend_locs: Optional legend locations, if using '-legend_on'.
        xlabel: Optional text labels for the abscissa/x-axis.
        title: Optional title for the set of plots.
        reverse_order: Reverses the order of plotted time series.
        sepscl: Make each graph have its own y-range.
        one_graph: Plot multiple infiles in a single subplot.
        dpi: Choose the output image's DPI. Default value is 150.
        figsize: Choose the output image's dimensions (units are inches).
        fontsize: Change image fontsize; default is 10.
        fontfamily: Change font-family used; default is monospace.
        fontstyles: Add a specific font name; should match with chosen\
            font-family.
        colors: Decide what color(s) to cycle through in plots (one or more).
        patches: Specify run lengths for background patches to distinguish runs.
        censor_trs: Specify time points where censoring has occurred using AFNI\
            index notation.
        censor_files: Specify time points where censoring has occurred using\
            one or more 1D files.
        censor_hline: Add a dotted horizontal line to the plot, representing\
            the censor threshold.
        censor_rgb: Choose the color of the censoring background; default is:\
            [1, 0.7, 0.7].
        bkgd_color: Change the background color outside of the plot windows.\
            Default is 0.9.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dplot.py",
        "infiles": infiles,
        "prefix": prefix,
        "help": help_,
        "boxplot_on": boxplot_on,
        "margin_off": margin_off,
        "legend_on": legend_on,
        "reverse_order": reverse_order,
        "sepscl": sepscl,
        "one_graph": one_graph,
    }
    if bplot_view is not None:
        params["bplot_view"] = bplot_view
    if scale is not None:
        params["scale"] = scale
    if xfile is not None:
        params["xfile"] = xfile
    if xvals is not None:
        params["xvals"] = xvals
    if yaxis is not None:
        params["yaxis"] = yaxis
    if ylabels is not None:
        params["ylabels"] = ylabels
    if ylabels_maxlen is not None:
        params["ylabels_maxlen"] = ylabels_maxlen
    if legend_labels is not None:
        params["legend_labels"] = legend_labels
    if legend_locs is not None:
        params["legend_locs"] = legend_locs
    if xlabel is not None:
        params["xlabel"] = xlabel
    if title is not None:
        params["title"] = title
    if dpi is not None:
        params["dpi"] = dpi
    if figsize is not None:
        params["figsize"] = figsize
    if fontsize is not None:
        params["fontsize"] = fontsize
    if fontfamily is not None:
        params["fontfamily"] = fontfamily
    if fontstyles is not None:
        params["fontstyles"] = fontstyles
    if colors is not None:
        params["colors"] = colors
    if patches is not None:
        params["patches"] = patches
    if censor_trs is not None:
        params["censor_trs"] = censor_trs
    if censor_files is not None:
        params["censor_files"] = censor_files
    if censor_hline is not None:
        params["censor_hline"] = censor_hline
    if censor_rgb is not None:
        params["censor_rgb"] = censor_rgb
    if bkgd_color is not None:
        params["bkgd_color"] = bkgd_color
    return params


def v_1dplot_py_cargs(
    params: V1dplotPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dplot.py")
    cargs.extend([
        "-infiles",
        *[execution.input_file(f) for f in params.get("infiles", None)]
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("help", False):
        cargs.append("-h")
    if params.get("boxplot_on", False):
        cargs.append("-boxplot_on")
    if params.get("bplot_view", None) is not None:
        cargs.extend([
            "-bplot_view",
            params.get("bplot_view", None)
        ])
    if params.get("margin_off", False):
        cargs.append("-margin_off")
    if params.get("scale", None) is not None:
        cargs.extend([
            "-scale",
            *params.get("scale", None)
        ])
    if params.get("xfile", None) is not None:
        cargs.extend([
            "-xfile",
            execution.input_file(params.get("xfile", None))
        ])
    if params.get("xvals", None) is not None:
        cargs.extend([
            "-xvals",
            *map(str, params.get("xvals", None))
        ])
    if params.get("yaxis", None) is not None:
        cargs.extend([
            "-yaxis",
            *params.get("yaxis", None)
        ])
    if params.get("ylabels", None) is not None:
        cargs.extend([
            "-ylabels",
            *params.get("ylabels", None)
        ])
    if params.get("ylabels_maxlen", None) is not None:
        cargs.extend([
            "-ylabels_maxlen",
            str(params.get("ylabels_maxlen", None))
        ])
    if params.get("legend_on", False):
        cargs.append("-legend_on")
    if params.get("legend_labels", None) is not None:
        cargs.extend([
            "-legend_labels",
            *params.get("legend_labels", None)
        ])
    if params.get("legend_locs", None) is not None:
        cargs.extend([
            "-legend_locs",
            *params.get("legend_locs", None)
        ])
    if params.get("xlabel", None) is not None:
        cargs.extend([
            "-xlabel",
            params.get("xlabel", None)
        ])
    if params.get("title", None) is not None:
        cargs.extend([
            "-title",
            params.get("title", None)
        ])
    if params.get("reverse_order", False):
        cargs.append("-reverse_order")
    if params.get("sepscl", False):
        cargs.append("-sepscl")
    if params.get("one_graph", False):
        cargs.append("-one_graph")
    if params.get("dpi", None) is not None:
        cargs.extend([
            "-dpi",
            str(params.get("dpi", None))
        ])
    if params.get("figsize", None) is not None:
        cargs.extend([
            "-figsize",
            *map(str, params.get("figsize", None))
        ])
    if params.get("fontsize", None) is not None:
        cargs.extend([
            "-fontsize",
            str(params.get("fontsize", None))
        ])
    if params.get("fontfamily", None) is not None:
        cargs.extend([
            "-fontfamily",
            params.get("fontfamily", None)
        ])
    if params.get("fontstyles", None) is not None:
        cargs.extend([
            "-fontstyles",
            params.get("fontstyles", None)
        ])
    if params.get("colors", None) is not None:
        cargs.extend([
            "-colors",
            *params.get("colors", None)
        ])
    if params.get("patches", None) is not None:
        cargs.extend([
            "-patches",
            *params.get("patches", None)
        ])
    if params.get("censor_trs", None) is not None:
        cargs.extend([
            "-censor_trs",
            *params.get("censor_trs", None)
        ])
    if params.get("censor_files", None) is not None:
        cargs.extend([
            "-censor_files",
            *[execution.input_file(f) for f in params.get("censor_files", None)]
        ])
    if params.get("censor_hline", None) is not None:
        cargs.extend([
            "-censor_hline",
            *params.get("censor_hline", None)
        ])
    if params.get("censor_rgb", None) is not None:
        cargs.extend([
            "-censor_RGB",
            params.get("censor_rgb", None)
        ])
    if params.get("bkgd_color", None) is not None:
        cargs.extend([
            "-bkgd_color",
            params.get("bkgd_color", None)
        ])
    return cargs


def v_1dplot_py_outputs(
    params: V1dplotPyParameters,
    execution: Execution,
) -> V1dplotPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dplotPyOutputs(
        root=execution.output_file("."),
        output_image=execution.output_file(params.get("prefix", None) + ".jpg"),
    )
    return ret


def v_1dplot_py_execute(
    params: V1dplotPyParameters,
    runner: Runner | None = None,
) -> V1dplotPyOutputs:
    """
    1dplot.py
    
    This program is for making images to visualize columns of numbers from 1D
    text files. It uses Python, particularly matplotlib, to create plots.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dplotPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DPLOT_PY_METADATA)
    params = execution.params(params)
    cargs = v_1dplot_py_cargs(params, execution)
    ret = v_1dplot_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dplot_py(
    infiles: list[InputPathType],
    prefix: str,
    help_: bool = False,
    boxplot_on: bool = False,
    bplot_view: str | None = None,
    margin_off: bool = False,
    scale: list[str] | None = None,
    xfile: InputPathType | None = None,
    xvals: list[float] | None = None,
    yaxis: list[str] | None = None,
    ylabels: list[str] | None = None,
    ylabels_maxlen: float | None = None,
    legend_on: bool = False,
    legend_labels: list[str] | None = None,
    legend_locs: list[str] | None = None,
    xlabel: str | None = None,
    title: str | None = None,
    reverse_order: bool = False,
    sepscl: bool = False,
    one_graph: bool = False,
    dpi: float | None = None,
    figsize: list[float] | None = None,
    fontsize: float | None = None,
    fontfamily: str | None = None,
    fontstyles: str | None = None,
    colors: list[str] | None = None,
    patches: list[str] | None = None,
    censor_trs: list[str] | None = None,
    censor_files: list[InputPathType] | None = None,
    censor_hline: list[str] | None = None,
    censor_rgb: str | None = None,
    bkgd_color: str | None = None,
    runner: Runner | None = None,
) -> V1dplotPyOutputs:
    """
    1dplot.py
    
    This program is for making images to visualize columns of numbers from 1D
    text files. It uses Python, particularly matplotlib, to create plots.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infiles: One or more file names of text files. Each column in this file\
            will be treated as a separate time series for plotting.
        prefix: Output filename or prefix. Default output image type is .jpg.
        help_: See helpfile.
        boxplot_on: A fun feature to show an additional boxplot adjacent to\
            each time series.
        bplot_view: Adjust view for boxplots when using censoring.
        margin_off: Fill the plot frame completely, thus no labels, frame, or\
            titles will be visible.
        scale: Provide a list of scales to apply to the y-values.
        xfile: One way to input x-values explicitly: as a "1D" file containing\
            a single file of numbers.
        xvals: Provide exactly 3 numbers for x-values: start, stop, and\
            stepsize.
        yaxis: Optional range for each 'infile' y-axis.
        ylabels: Optional text labels for each 'infile' column.
        ylabels_maxlen: allows y-axis labels to wrap into multiple rows, each\
            of length <= which the user can decide.
        legend_on: Turn on the plotting of a legend in the plot(s).
        legend_labels: Optional legend labels, if using '-legend_on'.
        legend_locs: Optional legend locations, if using '-legend_on'.
        xlabel: Optional text labels for the abscissa/x-axis.
        title: Optional title for the set of plots.
        reverse_order: Reverses the order of plotted time series.
        sepscl: Make each graph have its own y-range.
        one_graph: Plot multiple infiles in a single subplot.
        dpi: Choose the output image's DPI. Default value is 150.
        figsize: Choose the output image's dimensions (units are inches).
        fontsize: Change image fontsize; default is 10.
        fontfamily: Change font-family used; default is monospace.
        fontstyles: Add a specific font name; should match with chosen\
            font-family.
        colors: Decide what color(s) to cycle through in plots (one or more).
        patches: Specify run lengths for background patches to distinguish runs.
        censor_trs: Specify time points where censoring has occurred using AFNI\
            index notation.
        censor_files: Specify time points where censoring has occurred using\
            one or more 1D files.
        censor_hline: Add a dotted horizontal line to the plot, representing\
            the censor threshold.
        censor_rgb: Choose the color of the censoring background; default is:\
            [1, 0.7, 0.7].
        bkgd_color: Change the background color outside of the plot windows.\
            Default is 0.9.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dplotPyOutputs`).
    """
    params = v_1dplot_py_params(
        infiles=infiles,
        prefix=prefix,
        help_=help_,
        boxplot_on=boxplot_on,
        bplot_view=bplot_view,
        margin_off=margin_off,
        scale=scale,
        xfile=xfile,
        xvals=xvals,
        yaxis=yaxis,
        ylabels=ylabels,
        ylabels_maxlen=ylabels_maxlen,
        legend_on=legend_on,
        legend_labels=legend_labels,
        legend_locs=legend_locs,
        xlabel=xlabel,
        title=title,
        reverse_order=reverse_order,
        sepscl=sepscl,
        one_graph=one_graph,
        dpi=dpi,
        figsize=figsize,
        fontsize=fontsize,
        fontfamily=fontfamily,
        fontstyles=fontstyles,
        colors=colors,
        patches=patches,
        censor_trs=censor_trs,
        censor_files=censor_files,
        censor_hline=censor_hline,
        censor_rgb=censor_rgb,
        bkgd_color=bkgd_color,
    )
    return v_1dplot_py_execute(params, runner)


__all__ = [
    "V1dplotPyOutputs",
    "V_1DPLOT_PY_METADATA",
    "v_1dplot_py",
    "v_1dplot_py_execute",
    "v_1dplot_py_params",
]
