# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DSUM_METADATA = Metadata(
    id="076f7885b357064e414a836c5044b162ef80dacc.boutiques",
    name="1dsum",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dsumParameters = typing.TypedDict('V1dsumParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/1dsum"]],
    "input_files": list[InputPathType],
    "ignore_rows": typing.NotRequired[float | None],
    "use_rows": typing.NotRequired[float | None],
    "mean_flag": bool,
    "nocomment_flag": bool,
    "okempty_flag": bool,
})
V1dsumParametersTagged = typing.TypedDict('V1dsumParametersTagged', {
    "@type": typing.Literal["afni/1dsum"],
    "input_files": list[InputPathType],
    "ignore_rows": typing.NotRequired[float | None],
    "use_rows": typing.NotRequired[float | None],
    "mean_flag": bool,
    "nocomment_flag": bool,
    "okempty_flag": bool,
})


class V1dsumOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dsumParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Sum or average of columns in the input files"""


def v_1dsum_params(
    input_files: list[InputPathType],
    ignore_rows: float | None = None,
    use_rows: float | None = None,
    mean_flag: bool = False,
    nocomment_flag: bool = False,
    okempty_flag: bool = False,
) -> V1dsumParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input ASCII files with numbers arranged in rows and\
            columns.
        ignore_rows: Skip the first nn rows of each file.
        use_rows: Use only mm rows from each file.
        mean_flag: Compute the average instead of the sum.
        nocomment_flag: Do not reproduce comments from the header of the first\
            input file to the output.
        okempty_flag: If encountering an empty 1D file, print 0 and exit\
            quietly instead of exiting with an error message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/1dsum",
        "input_files": input_files,
        "mean_flag": mean_flag,
        "nocomment_flag": nocomment_flag,
        "okempty_flag": okempty_flag,
    }
    if ignore_rows is not None:
        params["ignore_rows"] = ignore_rows
    if use_rows is not None:
        params["use_rows"] = use_rows
    return params


def v_1dsum_cargs(
    params: V1dsumParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dsum")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("ignore_rows", None) is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore_rows", None))
        ])
    if params.get("use_rows", None) is not None:
        cargs.extend([
            "-use",
            str(params.get("use_rows", None))
        ])
    if params.get("mean_flag", False):
        cargs.append("-mean")
    if params.get("nocomment_flag", False):
        cargs.append("-nocomment")
    if params.get("okempty_flag", False):
        cargs.append("-OKempty")
    return cargs


def v_1dsum_outputs(
    params: V1dsumParameters,
    execution: Execution,
) -> V1dsumOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dsumOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("output.txt"),
    )
    return ret


def v_1dsum_execute(
    params: V1dsumParameters,
    runner: Runner | None = None,
) -> V1dsumOutputs:
    """
    1dsum
    
    Sum or average columns of ASCII files with numbers arranged in rows and
    columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dsumOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DSUM_METADATA)
    params = execution.params(params)
    cargs = v_1dsum_cargs(params, execution)
    ret = v_1dsum_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dsum(
    input_files: list[InputPathType],
    ignore_rows: float | None = None,
    use_rows: float | None = None,
    mean_flag: bool = False,
    nocomment_flag: bool = False,
    okempty_flag: bool = False,
    runner: Runner | None = None,
) -> V1dsumOutputs:
    """
    1dsum
    
    Sum or average columns of ASCII files with numbers arranged in rows and
    columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input ASCII files with numbers arranged in rows and\
            columns.
        ignore_rows: Skip the first nn rows of each file.
        use_rows: Use only mm rows from each file.
        mean_flag: Compute the average instead of the sum.
        nocomment_flag: Do not reproduce comments from the header of the first\
            input file to the output.
        okempty_flag: If encountering an empty 1D file, print 0 and exit\
            quietly instead of exiting with an error message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dsumOutputs`).
    """
    params = v_1dsum_params(
        input_files=input_files,
        ignore_rows=ignore_rows,
        use_rows=use_rows,
        mean_flag=mean_flag,
        nocomment_flag=nocomment_flag,
        okempty_flag=okempty_flag,
    )
    return v_1dsum_execute(params, runner)


__all__ = [
    "V1dsumOutputs",
    "V_1DSUM_METADATA",
    "v_1dsum",
    "v_1dsum_execute",
    "v_1dsum_params",
]
