# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_24SWAP_METADATA = Metadata(
    id="da742d50523f632410ceb194d0365bc9b69d8087.boutiques",
    name="24swap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V24swapParameters = typing.TypedDict('V24swapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/24swap"]],
    "quiet": bool,
    "pattern": typing.NotRequired[str | None],
    "input_files": list[InputPathType],
})
V24swapParametersTagged = typing.TypedDict('V24swapParametersTagged', {
    "@type": typing.Literal["afni/24swap"],
    "quiet": bool,
    "pattern": typing.NotRequired[str | None],
    "input_files": list[InputPathType],
})


class V24swapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V24swapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_24swap_params(
    input_files: list[InputPathType],
    quiet: bool = False,
    pattern: str | None = None,
) -> V24swapParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input file(s) to swap bytes.
        quiet: Operate quietly.
        pattern: Pattern that determines the pattern of 2 and 4 byte swaps.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/24swap",
        "quiet": quiet,
        "input_files": input_files,
    }
    if pattern is not None:
        params["pattern"] = pattern
    return params


def v_24swap_cargs(
    params: V24swapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("24swap")
    if params.get("quiet", False):
        cargs.append("-q")
    if params.get("pattern", None) is not None:
        cargs.extend([
            "-pattern",
            params.get("pattern", None)
        ])
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def v_24swap_outputs(
    params: V24swapParameters,
    execution: Execution,
) -> V24swapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V24swapOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_24swap_execute(
    params: V24swapParameters,
    runner: Runner | None = None,
) -> V24swapOutputs:
    """
    24swap
    
    Swaps bytes pairs and/or quadruples on the files listed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V24swapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_24SWAP_METADATA)
    params = execution.params(params)
    cargs = v_24swap_cargs(params, execution)
    ret = v_24swap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_24swap(
    input_files: list[InputPathType],
    quiet: bool = False,
    pattern: str | None = None,
    runner: Runner | None = None,
) -> V24swapOutputs:
    """
    24swap
    
    Swaps bytes pairs and/or quadruples on the files listed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input file(s) to swap bytes.
        quiet: Operate quietly.
        pattern: Pattern that determines the pattern of 2 and 4 byte swaps.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V24swapOutputs`).
    """
    params = v_24swap_params(
        quiet=quiet,
        pattern=pattern,
        input_files=input_files,
    )
    return v_24swap_execute(params, runner)


__all__ = [
    "V24swapOutputs",
    "V_24SWAP_METADATA",
    "v_24swap",
    "v_24swap_execute",
    "v_24swap_params",
]
