# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_2D_IM_REG_METADATA = Metadata(
    id="32da490dea2c5596f84ae91dd7499565aaa2b274.boutiques",
    name="2dImReg",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V2dImRegParameters = typing.TypedDict('V2dImRegParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/2dImReg"]],
    "input_file": InputPathType,
    "base_file": typing.NotRequired[InputPathType | None],
    "base": typing.NotRequired[float | None],
    "nofine": bool,
    "fine_blur": typing.NotRequired[float | None],
    "fine_dxy": typing.NotRequired[float | None],
    "fine_dphi": typing.NotRequired[float | None],
    "prefix": str,
    "dprefix": typing.NotRequired[str | None],
    "dmm": bool,
    "rprefix": typing.NotRequired[str | None],
    "debug": bool,
})
V2dImRegParametersTagged = typing.TypedDict('V2dImRegParametersTagged', {
    "@type": typing.Literal["afni/2dImReg"],
    "input_file": InputPathType,
    "base_file": typing.NotRequired[InputPathType | None],
    "base": typing.NotRequired[float | None],
    "nofine": bool,
    "fine_blur": typing.NotRequired[float | None],
    "fine_dxy": typing.NotRequired[float | None],
    "fine_dphi": typing.NotRequired[float | None],
    "prefix": str,
    "dprefix": typing.NotRequired[str | None],
    "dmm": bool,
    "rprefix": typing.NotRequired[str | None],
    "debug": bool,
})


class V2dImRegOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V2dImRegParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Output 3d+time dataset"""
    dx_file: OutputPathType | None
    """File containing dx registration parameters in pixels/mm"""
    dy_file: OutputPathType | None
    """File containing dy registration parameters in pixels/mm"""
    psi_file: OutputPathType | None
    """File containing psi registration parameters in degrees"""
    oldrms_file: OutputPathType | None
    """File containing the volume RMS error for the original dataset"""
    newrms_file: OutputPathType | None
    """File containing the volume RMS error for the registered dataset"""


def v_2d_im_reg_params(
    input_file: InputPathType,
    prefix: str,
    base_file: InputPathType | None = None,
    base: float | None = None,
    nofine: bool = False,
    fine_blur: float | None = None,
    fine_dxy: float | None = None,
    fine_dphi: float | None = None,
    dprefix: str | None = None,
    dmm: bool = False,
    rprefix: str | None = None,
    debug: bool = False,
) -> V2dImRegParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Filename of input 3d+time dataset to process.
        prefix: Prefix name for output 3d+time dataset.
        base_file: Filename of 3d+time dataset for base image (default =\
            current input dataset).
        base: Time index for base image (0 <= num) (default: num = 3).
        nofine: Deactivate fine fit phase of image registration (default: fine\
            fit is active).
        fine_blur: FWHM of blurring prior to registration (in pixels) (default:\
            blur = 1.0).
        fine_dxy: Convergence tolerance for translations (in pixels) (default:\
            dxy = 0.07).
        fine_dphi: Convergence tolerance for rotations (in degrees) (default:\
            dphi = 0.21).
        dprefix: Write files containing the registration parameters for each\
            slice in chronological order.
        dmm: Change dx and dy output format from pixels to mm.
        rprefix: Write files containing the volume RMS error for the original\
            and the registered datasets.
        debug: Lots of additional output to screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/2dImReg",
        "input_file": input_file,
        "nofine": nofine,
        "prefix": prefix,
        "dmm": dmm,
        "debug": debug,
    }
    if base_file is not None:
        params["base_file"] = base_file
    if base is not None:
        params["base"] = base
    if fine_blur is not None:
        params["fine_blur"] = fine_blur
    if fine_dxy is not None:
        params["fine_dxy"] = fine_dxy
    if fine_dphi is not None:
        params["fine_dphi"] = fine_dphi
    if dprefix is not None:
        params["dprefix"] = dprefix
    if rprefix is not None:
        params["rprefix"] = rprefix
    return params


def v_2d_im_reg_cargs(
    params: V2dImRegParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("2dImReg")
    cargs.append(execution.input_file(params.get("input_file", None)))
    if params.get("base_file", None) is not None:
        cargs.append(execution.input_file(params.get("base_file", None)))
    if params.get("base", None) is not None:
        cargs.append(str(params.get("base", None)))
    if params.get("nofine", False):
        cargs.append("-nofine")
    if params.get("fine_blur", None) is not None:
        cargs.append(str(params.get("fine_blur", None)))
    if params.get("fine_dxy", None) is not None:
        cargs.append(str(params.get("fine_dxy", None)))
    if params.get("fine_dphi", None) is not None:
        cargs.append(str(params.get("fine_dphi", None)))
    cargs.append(params.get("prefix", None))
    if params.get("dprefix", None) is not None:
        cargs.append(params.get("dprefix", None))
    if params.get("dmm", False):
        cargs.append("-dmm")
    if params.get("rprefix", None) is not None:
        cargs.append(params.get("rprefix", None))
    if params.get("debug", False):
        cargs.append("-debug")
    return cargs


def v_2d_im_reg_outputs(
    params: V2dImRegParameters,
    execution: Execution,
) -> V2dImRegOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V2dImRegOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + ".nii"),
        dx_file=execution.output_file(params.get("dprefix", None) + ".dx") if (params.get("dprefix") is not None) else None,
        dy_file=execution.output_file(params.get("dprefix", None) + ".dy") if (params.get("dprefix") is not None) else None,
        psi_file=execution.output_file(params.get("dprefix", None) + ".psi") if (params.get("dprefix") is not None) else None,
        oldrms_file=execution.output_file(params.get("rprefix", None) + ".oldrms") if (params.get("rprefix") is not None) else None,
        newrms_file=execution.output_file(params.get("rprefix", None) + ".newrms") if (params.get("rprefix") is not None) else None,
    )
    return ret


def v_2d_im_reg_execute(
    params: V2dImRegParameters,
    runner: Runner | None = None,
) -> V2dImRegOutputs:
    """
    2dImReg
    
    2D image registration tool for 3D+time datasets, aligning images on a
    slice-by-slice basis to a specified base image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dImRegOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_2D_IM_REG_METADATA)
    params = execution.params(params)
    cargs = v_2d_im_reg_cargs(params, execution)
    ret = v_2d_im_reg_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_2d_im_reg(
    input_file: InputPathType,
    prefix: str,
    base_file: InputPathType | None = None,
    base: float | None = None,
    nofine: bool = False,
    fine_blur: float | None = None,
    fine_dxy: float | None = None,
    fine_dphi: float | None = None,
    dprefix: str | None = None,
    dmm: bool = False,
    rprefix: str | None = None,
    debug: bool = False,
    runner: Runner | None = None,
) -> V2dImRegOutputs:
    """
    2dImReg
    
    2D image registration tool for 3D+time datasets, aligning images on a
    slice-by-slice basis to a specified base image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Filename of input 3d+time dataset to process.
        prefix: Prefix name for output 3d+time dataset.
        base_file: Filename of 3d+time dataset for base image (default =\
            current input dataset).
        base: Time index for base image (0 <= num) (default: num = 3).
        nofine: Deactivate fine fit phase of image registration (default: fine\
            fit is active).
        fine_blur: FWHM of blurring prior to registration (in pixels) (default:\
            blur = 1.0).
        fine_dxy: Convergence tolerance for translations (in pixels) (default:\
            dxy = 0.07).
        fine_dphi: Convergence tolerance for rotations (in degrees) (default:\
            dphi = 0.21).
        dprefix: Write files containing the registration parameters for each\
            slice in chronological order.
        dmm: Change dx and dy output format from pixels to mm.
        rprefix: Write files containing the volume RMS error for the original\
            and the registered datasets.
        debug: Lots of additional output to screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dImRegOutputs`).
    """
    params = v_2d_im_reg_params(
        input_file=input_file,
        base_file=base_file,
        base=base,
        nofine=nofine,
        fine_blur=fine_blur,
        fine_dxy=fine_dxy,
        fine_dphi=fine_dphi,
        prefix=prefix,
        dprefix=dprefix,
        dmm=dmm,
        rprefix=rprefix,
        debug=debug,
    )
    return v_2d_im_reg_execute(params, runner)


__all__ = [
    "V2dImRegOutputs",
    "V_2D_IM_REG_METADATA",
    "v_2d_im_reg",
    "v_2d_im_reg_execute",
    "v_2d_im_reg_params",
]
