# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_2PERM_METADATA = Metadata(
    id="540f8e1f8b85823bcf0dba52846ee4ef33340eca.boutiques",
    name="2perm",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V2permParameters = typing.TypedDict('V2permParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/2perm"]],
    "prefix": typing.NotRequired[str | None],
    "comma": bool,
    "bottom_int": float,
    "top_int": float,
    "subset1_size": typing.NotRequired[float | None],
    "subset2_size": typing.NotRequired[float | None],
})
V2permParametersTagged = typing.TypedDict('V2permParametersTagged', {
    "@type": typing.Literal["afni/2perm"],
    "prefix": typing.NotRequired[str | None],
    "comma": bool,
    "bottom_int": float,
    "top_int": float,
    "subset1_size": typing.NotRequired[float | None],
    "subset2_size": typing.NotRequired[float | None],
})


class V2permOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V2permParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    file_a: OutputPathType | None
    """First subset output file"""
    file_b: OutputPathType | None
    """Second subset output file"""


def v_2perm_params(
    bottom_int: float,
    top_int: float,
    prefix: str | None = None,
    comma: bool = False,
    subset1_size: float | None = None,
    subset2_size: float | None = None,
) -> V2permParametersTagged:
    """
    Build parameters.
    
    Args:
        bottom_int: Bottom integer of the range.
        top_int: Top integer of the range.
        prefix: Prefix for output files (default 'AFNIroolz').
        comma: Write each file as a single row of comma-separated numbers.
        subset1_size: Size of the first subset (optional, default is half the\
            range).
        subset2_size: Size of the second subset (optional, default is half the\
            range).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/2perm",
        "comma": comma,
        "bottom_int": bottom_int,
        "top_int": top_int,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if subset1_size is not None:
        params["subset1_size"] = subset1_size
    if subset2_size is not None:
        params["subset2_size"] = subset2_size
    return params


def v_2perm_cargs(
    params: V2permParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("2perm")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("comma", False):
        cargs.append("-comma")
    cargs.append(str(params.get("bottom_int", None)))
    cargs.append(str(params.get("top_int", None)))
    if params.get("subset1_size", None) is not None:
        cargs.append(str(params.get("subset1_size", None)))
    if params.get("subset2_size", None) is not None:
        cargs.append(str(params.get("subset2_size", None)))
    return cargs


def v_2perm_outputs(
    params: V2permParameters,
    execution: Execution,
) -> V2permOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V2permOutputs(
        root=execution.output_file("."),
        file_a=execution.output_file(params.get("prefix", None) + "_A") if (params.get("prefix") is not None) else None,
        file_b=execution.output_file(params.get("prefix", None) + "_B") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_2perm_execute(
    params: V2permParameters,
    runner: Runner | None = None,
) -> V2permOutputs:
    """
    2perm
    
    Generates two random non-overlapping subsets of a given set of integers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2permOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_2PERM_METADATA)
    params = execution.params(params)
    cargs = v_2perm_cargs(params, execution)
    ret = v_2perm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_2perm(
    bottom_int: float,
    top_int: float,
    prefix: str | None = None,
    comma: bool = False,
    subset1_size: float | None = None,
    subset2_size: float | None = None,
    runner: Runner | None = None,
) -> V2permOutputs:
    """
    2perm
    
    Generates two random non-overlapping subsets of a given set of integers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        bottom_int: Bottom integer of the range.
        top_int: Top integer of the range.
        prefix: Prefix for output files (default 'AFNIroolz').
        comma: Write each file as a single row of comma-separated numbers.
        subset1_size: Size of the first subset (optional, default is half the\
            range).
        subset2_size: Size of the second subset (optional, default is half the\
            range).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2permOutputs`).
    """
    params = v_2perm_params(
        prefix=prefix,
        comma=comma,
        bottom_int=bottom_int,
        top_int=top_int,
        subset1_size=subset1_size,
        subset2_size=subset2_size,
    )
    return v_2perm_execute(params, runner)


__all__ = [
    "V2permOutputs",
    "V_2PERM_METADATA",
    "v_2perm",
    "v_2perm_execute",
    "v_2perm_params",
]
