# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ABOVERLAP_METADATA = Metadata(
    id="38bc7ba550719cb365421b65b249f4f2cd07a334.boutiques",
    name="3dABoverlap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAboverlapParameters = typing.TypedDict('V3dAboverlapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dABoverlap"]],
    "dataset_a": InputPathType,
    "dataset_b": InputPathType,
    "no_automask": bool,
    "quiet": bool,
    "verbose": bool,
})
V3dAboverlapParametersTagged = typing.TypedDict('V3dAboverlapParametersTagged', {
    "@type": typing.Literal["afni/3dABoverlap"],
    "dataset_a": InputPathType,
    "dataset_b": InputPathType,
    "no_automask": bool,
    "quiet": bool,
    "verbose": bool,
})


class V3dAboverlapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAboverlapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_aboverlap_params(
    dataset_a: InputPathType,
    dataset_b: InputPathType,
    no_automask: bool = False,
    quiet: bool = False,
    verbose: bool = False,
) -> V3dAboverlapParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset_a: First input dataset.
        dataset_b: Second input dataset.
        no_automask: Consider input datasets as masks (automask does not work\
            on mask datasets).
        quiet: Be as quiet as possible (without being entirely mute).
        verbose: Print out some progress reports (to stderr).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dABoverlap",
        "dataset_a": dataset_a,
        "dataset_b": dataset_b,
        "no_automask": no_automask,
        "quiet": quiet,
        "verbose": verbose,
    }
    return params


def v_3d_aboverlap_cargs(
    params: V3dAboverlapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dABoverlap")
    cargs.append(execution.input_file(params.get("dataset_a", None)))
    cargs.append(execution.input_file(params.get("dataset_b", None)))
    if params.get("no_automask", False):
        cargs.append("-no_automask")
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("verbose", False):
        cargs.append("-verb")
    return cargs


def v_3d_aboverlap_outputs(
    params: V3dAboverlapParameters,
    execution: Execution,
) -> V3dAboverlapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAboverlapOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_aboverlap_execute(
    params: V3dAboverlapParameters,
    runner: Runner | None = None,
) -> V3dAboverlapOutputs:
    """
    3dABoverlap
    
    Counts various metrics about how the automasks of datasets A and B overlap
    or don't overlap.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAboverlapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ABOVERLAP_METADATA)
    params = execution.params(params)
    cargs = v_3d_aboverlap_cargs(params, execution)
    ret = v_3d_aboverlap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_aboverlap(
    dataset_a: InputPathType,
    dataset_b: InputPathType,
    no_automask: bool = False,
    quiet: bool = False,
    verbose: bool = False,
    runner: Runner | None = None,
) -> V3dAboverlapOutputs:
    """
    3dABoverlap
    
    Counts various metrics about how the automasks of datasets A and B overlap
    or don't overlap.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset_a: First input dataset.
        dataset_b: Second input dataset.
        no_automask: Consider input datasets as masks (automask does not work\
            on mask datasets).
        quiet: Be as quiet as possible (without being entirely mute).
        verbose: Print out some progress reports (to stderr).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAboverlapOutputs`).
    """
    params = v_3d_aboverlap_params(
        dataset_a=dataset_a,
        dataset_b=dataset_b,
        no_automask=no_automask,
        quiet=quiet,
        verbose=verbose,
    )
    return v_3d_aboverlap_execute(params, runner)


__all__ = [
    "V3dAboverlapOutputs",
    "V_3D_ABOVERLAP_METADATA",
    "v_3d_aboverlap",
    "v_3d_aboverlap_execute",
    "v_3d_aboverlap_params",
]
