# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_AFNITO_NIML_METADATA = Metadata(
    id="229e46c8f508be2928f7052893ed55235b23d00a.boutiques",
    name="3dAFNItoNIML",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAfnitoNimlParameters = typing.TypedDict('V3dAfnitoNimlParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dAFNItoNIML"]],
    "dset": InputPathType,
    "data": bool,
    "ascii": bool,
    "tcp": typing.NotRequired[str | None],
})
V3dAfnitoNimlParametersTagged = typing.TypedDict('V3dAfnitoNimlParametersTagged', {
    "@type": typing.Literal["afni/3dAFNItoNIML"],
    "dset": InputPathType,
    "data": bool,
    "ascii": bool,
    "tcp": typing.NotRequired[str | None],
})


class V3dAfnitoNimlOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAfnitoNimlParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_afnito_niml_params(
    dset: InputPathType,
    data: bool = False,
    ascii_: bool = False,
    tcp: str | None = None,
) -> V3dAfnitoNimlParametersTagged:
    """
    Build parameters.
    
    Args:
        dset: AFNI dataset.
        data: Also put the data into the output (will be huge).
        ascii_: Format in ASCII, not binary (even huger).
        tcp: Instead of stdout, send the dataset to a socket. Implies '-data'\
            as well.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dAFNItoNIML",
        "dset": dset,
        "data": data,
        "ascii": ascii_,
    }
    if tcp is not None:
        params["tcp"] = tcp
    return params


def v_3d_afnito_niml_cargs(
    params: V3dAfnitoNimlParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAFNItoNIML")
    cargs.append(execution.input_file(params.get("dset", None)))
    if params.get("data", False):
        cargs.append("-data")
    if params.get("ascii", False):
        cargs.append("-ascii")
    if params.get("tcp", None) is not None:
        cargs.extend([
            "-tcp",
            params.get("tcp", None)
        ])
    return cargs


def v_3d_afnito_niml_outputs(
    params: V3dAfnitoNimlParameters,
    execution: Execution,
) -> V3dAfnitoNimlOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAfnitoNimlOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_afnito_niml_execute(
    params: V3dAfnitoNimlParameters,
    runner: Runner | None = None,
) -> V3dAfnitoNimlOutputs:
    """
    3dAFNItoNIML
    
    Dumps AFNI dataset header information to stdout in NIML format. Mostly for
    debugging and testing purposes!.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAfnitoNimlOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_AFNITO_NIML_METADATA)
    params = execution.params(params)
    cargs = v_3d_afnito_niml_cargs(params, execution)
    ret = v_3d_afnito_niml_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_afnito_niml(
    dset: InputPathType,
    data: bool = False,
    ascii_: bool = False,
    tcp: str | None = None,
    runner: Runner | None = None,
) -> V3dAfnitoNimlOutputs:
    """
    3dAFNItoNIML
    
    Dumps AFNI dataset header information to stdout in NIML format. Mostly for
    debugging and testing purposes!.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: AFNI dataset.
        data: Also put the data into the output (will be huge).
        ascii_: Format in ASCII, not binary (even huger).
        tcp: Instead of stdout, send the dataset to a socket. Implies '-data'\
            as well.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAfnitoNimlOutputs`).
    """
    params = v_3d_afnito_niml_params(
        dset=dset,
        data=data,
        ascii_=ascii_,
        tcp=tcp,
    )
    return v_3d_afnito_niml_execute(params, runner)


__all__ = [
    "V3dAfnitoNimlOutputs",
    "V_3D_AFNITO_NIML_METADATA",
    "v_3d_afnito_niml",
    "v_3d_afnito_niml_execute",
    "v_3d_afnito_niml_params",
]
