# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_AMP_TO_RSFC_METADATA = Metadata(
    id="d93e2359a57d357c7b1980a76378dde19262abcb.boutiques",
    name="3dAmpToRSFC",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAmpToRsfcParameters = typing.TypedDict('V3dAmpToRsfcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dAmpToRSFC"]],
    "in_amp": typing.NotRequired[InputPathType | None],
    "in_pow": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "band": list[float],
    "mask": typing.NotRequired[InputPathType | None],
    "nifti": bool,
})
V3dAmpToRsfcParametersTagged = typing.TypedDict('V3dAmpToRsfcParametersTagged', {
    "@type": typing.Literal["afni/3dAmpToRSFC"],
    "in_amp": typing.NotRequired[InputPathType | None],
    "in_pow": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "band": list[float],
    "mask": typing.NotRequired[InputPathType | None],
    "nifti": bool,
})


class V3dAmpToRsfcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAmpToRsfcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_alff: OutputPathType
    """Amplitude of low frequency fluctuations (L1 sum)."""
    output_malff: OutputPathType
    """ALFF divided by the mean value within the input/estimated whole brain
    mask (mean-scaled ALFF)."""
    output_falff: OutputPathType
    """ALFF divided by sum of full amplitude spectrum (fractional ALFF)."""
    output_rsfa: OutputPathType
    """Square-root of summed square of low frequency fluctuations (L2 sum)."""
    output_mrsfa: OutputPathType
    """RSFA divided by the mean value within the input/estimated whole brain
    mask (mean-scaled RSFA)."""
    output_frsfa: OutputPathType
    """ALFF divided by sum of full amplitude spectrum (fractional RSFA)."""


def v_3d_amp_to_rsfc_params(
    prefix: str,
    band: list[float],
    in_amp: InputPathType | None = None,
    in_pow: InputPathType | None = None,
    mask: InputPathType | None = None,
    nifti: bool = False,
) -> V3dAmpToRsfcParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Output file prefix; file names will be: PREFIX_ALFF,\
            PREFIX_FALFF, etc.
        band: Lower and upper boundaries of the low frequency fluctuations\
            (LFFs), within the interval [FBOT, FTOP].
        in_amp: Input file of one-sided spectral amplitudes, such as output by\
            3dLombScargle.
        in_pow: Input file of a one-sided power spectrum, such as output by\
            3dLombScargle.
        mask: Volume mask of voxels to include for calculations.
        nifti: Output files as *.nii.gz (default is BRIK/HEAD).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dAmpToRSFC",
        "prefix": prefix,
        "band": band,
        "nifti": nifti,
    }
    if in_amp is not None:
        params["in_amp"] = in_amp
    if in_pow is not None:
        params["in_pow"] = in_pow
    if mask is not None:
        params["mask"] = mask
    return params


def v_3d_amp_to_rsfc_cargs(
    params: V3dAmpToRsfcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAmpToRSFC")
    if params.get("in_amp", None) is not None:
        cargs.extend([
            "-in_amp",
            execution.input_file(params.get("in_amp", None))
        ])
    if params.get("in_pow", None) is not None:
        cargs.extend([
            "-in_pow",
            execution.input_file(params.get("in_pow", None))
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-band",
        *map(str, params.get("band", None))
    ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("nifti", False):
        cargs.append("-nifti")
    return cargs


def v_3d_amp_to_rsfc_outputs(
    params: V3dAmpToRsfcParameters,
    execution: Execution,
) -> V3dAmpToRsfcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAmpToRsfcOutputs(
        root=execution.output_file("."),
        output_alff=execution.output_file(params.get("prefix", None) + "_ALFF"),
        output_malff=execution.output_file(params.get("prefix", None) + "_MALFF"),
        output_falff=execution.output_file(params.get("prefix", None) + "_FALFF"),
        output_rsfa=execution.output_file(params.get("prefix", None) + "_RSFA"),
        output_mrsfa=execution.output_file(params.get("prefix", None) + "_MRSFA"),
        output_frsfa=execution.output_file(params.get("prefix", None) + "_FRSFA"),
    )
    return ret


def v_3d_amp_to_rsfc_execute(
    params: V3dAmpToRsfcParameters,
    runner: Runner | None = None,
) -> V3dAmpToRsfcOutputs:
    """
    3dAmpToRSFC
    
    Convert spectral amplitudes into standard RSFC parameters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAmpToRsfcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_AMP_TO_RSFC_METADATA)
    params = execution.params(params)
    cargs = v_3d_amp_to_rsfc_cargs(params, execution)
    ret = v_3d_amp_to_rsfc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_amp_to_rsfc(
    prefix: str,
    band: list[float],
    in_amp: InputPathType | None = None,
    in_pow: InputPathType | None = None,
    mask: InputPathType | None = None,
    nifti: bool = False,
    runner: Runner | None = None,
) -> V3dAmpToRsfcOutputs:
    """
    3dAmpToRSFC
    
    Convert spectral amplitudes into standard RSFC parameters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output file prefix; file names will be: PREFIX_ALFF,\
            PREFIX_FALFF, etc.
        band: Lower and upper boundaries of the low frequency fluctuations\
            (LFFs), within the interval [FBOT, FTOP].
        in_amp: Input file of one-sided spectral amplitudes, such as output by\
            3dLombScargle.
        in_pow: Input file of a one-sided power spectrum, such as output by\
            3dLombScargle.
        mask: Volume mask of voxels to include for calculations.
        nifti: Output files as *.nii.gz (default is BRIK/HEAD).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAmpToRsfcOutputs`).
    """
    params = v_3d_amp_to_rsfc_params(
        in_amp=in_amp,
        in_pow=in_pow,
        prefix=prefix,
        band=band,
        mask=mask,
        nifti=nifti,
    )
    return v_3d_amp_to_rsfc_execute(params, runner)


__all__ = [
    "V3dAmpToRsfcOutputs",
    "V_3D_AMP_TO_RSFC_METADATA",
    "v_3d_amp_to_rsfc",
    "v_3d_amp_to_rsfc_execute",
    "v_3d_amp_to_rsfc_params",
]
