# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ANHIST_METADATA = Metadata(
    id="c40972f414c2d5996b16432a9c6b6450fc0e7b2a.boutiques",
    name="3dAnhist",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAnhistParameters = typing.TypedDict('V3dAnhistParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dAnhist"]],
    "dataset": InputPathType,
    "quiet": bool,
    "dump_histogram": bool,
    "no_scurve": bool,
    "winsorize": typing.NotRequired[str | None],
    "top_2peaks": bool,
    "label": typing.NotRequired[str | None],
    "filename": typing.NotRequired[str | None],
})
V3dAnhistParametersTagged = typing.TypedDict('V3dAnhistParametersTagged', {
    "@type": typing.Literal["afni/3dAnhist"],
    "dataset": InputPathType,
    "quiet": bool,
    "dump_histogram": bool,
    "no_scurve": bool,
    "winsorize": typing.NotRequired[str | None],
    "top_2peaks": bool,
    "label": typing.NotRequired[str | None],
    "filename": typing.NotRequired[str | None],
})


class V3dAnhistOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAnhistParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_1_d: OutputPathType
    """Dumped histogram data"""
    output_ps: OutputPathType
    """Plot of histogram data"""


def v_3d_anhist_params(
    dataset: InputPathType,
    quiet: bool = False,
    dump_histogram: bool = False,
    no_scurve: bool = False,
    winsorize: str | None = None,
    top_2peaks: bool = False,
    label: str | None = None,
    filename: str | None = None,
) -> V3dAnhistParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset, should be T1-weighted high-res brain image\
            (shorts only).
        quiet: Suppress progress reports.
        dump_histogram: Dump histogram data to Anhist.1D and plot to Anhist.ps.
        no_scurve: Do not fit histogram with curves.
        winsorize: Apply Winsorizing filter prior to histogram scan. Can\
            specify number of times (e.g., -w7).
        top_2peaks: Analyze top 2 peaks only, for overlap, etc.
        label: Use specified label for Anhist.ps plot file instead of the input\
            dataset filename.
        filename: Use specified filename instead of 'Anhist'.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dAnhist",
        "dataset": dataset,
        "quiet": quiet,
        "dump_histogram": dump_histogram,
        "no_scurve": no_scurve,
        "top_2peaks": top_2peaks,
    }
    if winsorize is not None:
        params["winsorize"] = winsorize
    if label is not None:
        params["label"] = label
    if filename is not None:
        params["filename"] = filename
    return params


def v_3d_anhist_cargs(
    params: V3dAnhistParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAnhist")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("quiet", False):
        cargs.append("-q")
    if params.get("dump_histogram", False):
        cargs.append("-h")
    if params.get("no_scurve", False):
        cargs.append("-F")
    if params.get("winsorize", None) is not None:
        cargs.extend([
            "-w",
            params.get("winsorize", None)
        ])
    if params.get("top_2peaks", False):
        cargs.append("-2")
    if params.get("label", None) is not None:
        cargs.extend([
            "-label",
            params.get("label", None)
        ])
    if params.get("filename", None) is not None:
        cargs.extend([
            "-fname",
            params.get("filename", None)
        ])
    return cargs


def v_3d_anhist_outputs(
    params: V3dAnhistParameters,
    execution: Execution,
) -> V3dAnhistOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAnhistOutputs(
        root=execution.output_file("."),
        output_1_d=execution.output_file("Anhist.1D"),
        output_ps=execution.output_file("Anhist.ps"),
    )
    return ret


def v_3d_anhist_execute(
    params: V3dAnhistParameters,
    runner: Runner | None = None,
) -> V3dAnhistOutputs:
    """
    3dAnhist
    
    Tool to analyze histogram peaks in a T1-weighted high-res brain image
    dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAnhistOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ANHIST_METADATA)
    params = execution.params(params)
    cargs = v_3d_anhist_cargs(params, execution)
    ret = v_3d_anhist_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_anhist(
    dataset: InputPathType,
    quiet: bool = False,
    dump_histogram: bool = False,
    no_scurve: bool = False,
    winsorize: str | None = None,
    top_2peaks: bool = False,
    label: str | None = None,
    filename: str | None = None,
    runner: Runner | None = None,
) -> V3dAnhistOutputs:
    """
    3dAnhist
    
    Tool to analyze histogram peaks in a T1-weighted high-res brain image
    dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset, should be T1-weighted high-res brain image\
            (shorts only).
        quiet: Suppress progress reports.
        dump_histogram: Dump histogram data to Anhist.1D and plot to Anhist.ps.
        no_scurve: Do not fit histogram with curves.
        winsorize: Apply Winsorizing filter prior to histogram scan. Can\
            specify number of times (e.g., -w7).
        top_2peaks: Analyze top 2 peaks only, for overlap, etc.
        label: Use specified label for Anhist.ps plot file instead of the input\
            dataset filename.
        filename: Use specified filename instead of 'Anhist'.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAnhistOutputs`).
    """
    params = v_3d_anhist_params(
        dataset=dataset,
        quiet=quiet,
        dump_histogram=dump_histogram,
        no_scurve=no_scurve,
        winsorize=winsorize,
        top_2peaks=top_2peaks,
        label=label,
        filename=filename,
    )
    return v_3d_anhist_execute(params, runner)


__all__ = [
    "V3dAnhistOutputs",
    "V_3D_ANHIST_METADATA",
    "v_3d_anhist",
    "v_3d_anhist_execute",
    "v_3d_anhist_params",
]
