# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ATTRIBUTE_METADATA = Metadata(
    id="e6921eafc1dfa857e7555005a71fea332d795365.boutiques",
    name="3dAttribute",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAttributeParameters = typing.TypedDict('V3dAttributeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dAttribute"]],
    "all": bool,
    "name": bool,
    "center": bool,
    "ssep": typing.NotRequired[str | None],
    "sprep": typing.NotRequired[str | None],
    "quote": bool,
    "aname": str,
    "dset": InputPathType,
})
V3dAttributeParametersTagged = typing.TypedDict('V3dAttributeParametersTagged', {
    "@type": typing.Literal["afni/3dAttribute"],
    "all": bool,
    "name": bool,
    "center": bool,
    "ssep": typing.NotRequired[str | None],
    "sprep": typing.NotRequired[str | None],
    "quote": bool,
    "aname": str,
    "dset": InputPathType,
})


class V3dAttributeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAttributeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout: OutputPathType
    """Output of the attribute value"""


def v_3d_attribute_params(
    aname: str,
    dset: InputPathType,
    all_: bool = False,
    name: bool = False,
    center: bool = False,
    ssep: str | None = None,
    sprep: str | None = None,
    quote: bool = False,
) -> V3dAttributeParametersTagged:
    """
    Build parameters.
    
    Args:
        aname: Attribute name to be printed from the dataset.
        dset: Dataset from which the attribute value will be printed.
        all_: Print all attributes from the dataset.
        name: Include attribute name in the output.
        center: Print the center of volume in RAI coordinates.
        ssep: Use string SSEP as a separator between strings for multiple\
            sub-bricks.
        sprep: Use string SPREP to replace blank space in string attributes.
        quote: Use single quote around each string.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dAttribute",
        "all": all_,
        "name": name,
        "center": center,
        "quote": quote,
        "aname": aname,
        "dset": dset,
    }
    if ssep is not None:
        params["ssep"] = ssep
    if sprep is not None:
        params["sprep"] = sprep
    return params


def v_3d_attribute_cargs(
    params: V3dAttributeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAttribute")
    if params.get("all", False):
        cargs.append("-all")
    if params.get("name", False):
        cargs.append("-name")
    if params.get("center", False):
        cargs.append("-center")
    if params.get("ssep", None) is not None:
        cargs.extend([
            "-ssep",
            params.get("ssep", None)
        ])
    if params.get("sprep", None) is not None:
        cargs.extend([
            "-sprep",
            params.get("sprep", None)
        ])
    if params.get("quote", False):
        cargs.append("-quote")
    cargs.append(params.get("aname", None))
    cargs.append(execution.input_file(params.get("dset", None)))
    return cargs


def v_3d_attribute_outputs(
    params: V3dAttributeParameters,
    execution: Execution,
) -> V3dAttributeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAttributeOutputs(
        root=execution.output_file("."),
        stdout=execution.output_file("stdout"),
    )
    return ret


def v_3d_attribute_execute(
    params: V3dAttributeParameters,
    runner: Runner | None = None,
) -> V3dAttributeOutputs:
    """
    3dAttribute
    
    Prints the value of the attribute 'aname' from the header of the dataset
    'dset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAttributeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ATTRIBUTE_METADATA)
    params = execution.params(params)
    cargs = v_3d_attribute_cargs(params, execution)
    ret = v_3d_attribute_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_attribute(
    aname: str,
    dset: InputPathType,
    all_: bool = False,
    name: bool = False,
    center: bool = False,
    ssep: str | None = None,
    sprep: str | None = None,
    quote: bool = False,
    runner: Runner | None = None,
) -> V3dAttributeOutputs:
    """
    3dAttribute
    
    Prints the value of the attribute 'aname' from the header of the dataset
    'dset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        aname: Attribute name to be printed from the dataset.
        dset: Dataset from which the attribute value will be printed.
        all_: Print all attributes from the dataset.
        name: Include attribute name in the output.
        center: Print the center of volume in RAI coordinates.
        ssep: Use string SSEP as a separator between strings for multiple\
            sub-bricks.
        sprep: Use string SPREP to replace blank space in string attributes.
        quote: Use single quote around each string.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAttributeOutputs`).
    """
    params = v_3d_attribute_params(
        all_=all_,
        name=name,
        center=center,
        ssep=ssep,
        sprep=sprep,
        quote=quote,
        aname=aname,
        dset=dset,
    )
    return v_3d_attribute_execute(params, runner)


__all__ = [
    "V3dAttributeOutputs",
    "V_3D_ATTRIBUTE_METADATA",
    "v_3d_attribute",
    "v_3d_attribute_execute",
    "v_3d_attribute_params",
]
