# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_AUTOMASK_METADATA = Metadata(
    id="d0aea979aa7a9af4ee597051955d1bd0cc99a3b1.boutiques",
    name="3dAutomask",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAutomaskParameters = typing.TypedDict('V3dAutomaskParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dAutomask"]],
    "prefix": typing.NotRequired[str | None],
    "apply_prefix": typing.NotRequired[str | None],
    "clfrac": typing.NotRequired[float | None],
    "dilate": typing.NotRequired[int | None],
    "erode": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "in_file": InputPathType,
})
V3dAutomaskParametersTagged = typing.TypedDict('V3dAutomaskParametersTagged', {
    "@type": typing.Literal["afni/3dAutomask"],
    "prefix": typing.NotRequired[str | None],
    "apply_prefix": typing.NotRequired[str | None],
    "clfrac": typing.NotRequired[float | None],
    "dilate": typing.NotRequired[int | None],
    "erode": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "in_file": InputPathType,
})


class V3dAutomaskOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dAutomaskParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    brain_file: OutputPathType | None
    """Output file from 3dautomask."""
    mask_file: OutputPathType | None
    """Output image file name."""


def v_3d_automask_params(
    in_file: InputPathType,
    prefix: str | None = None,
    apply_prefix: str | None = None,
    clfrac: float | None = None,
    dilate: int | None = None,
    erode: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
) -> V3dAutomaskParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dautomask.
        prefix: Write mask into dataset with prefix 'ppp'. [Default ==\
            'automask'].
        apply_prefix: Apply mask to input dataset and save masked dataset.
        clfrac: Sets the clip level fraction (must be 0.1-0.9). a small value\
            will tend to make the mask larger [default = 0.5].
        dilate: Dilate the mask outwards.
        erode: Erode the mask inwards.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dAutomask",
        "in_file": in_file,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if apply_prefix is not None:
        params["apply_prefix"] = apply_prefix
    if clfrac is not None:
        params["clfrac"] = clfrac
    if dilate is not None:
        params["dilate"] = dilate
    if erode is not None:
        params["erode"] = erode
    if outputtype is not None:
        params["outputtype"] = outputtype
    return params


def v_3d_automask_cargs(
    params: V3dAutomaskParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAutomask")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("apply_prefix", None) is not None:
        cargs.extend([
            "-apply_prefix",
            params.get("apply_prefix", None)
        ])
    if params.get("clfrac", None) is not None:
        cargs.extend([
            "-clfrac",
            str(params.get("clfrac", None))
        ])
    if params.get("dilate", None) is not None:
        cargs.extend([
            "-dilate",
            str(params.get("dilate", None))
        ])
    if params.get("erode", None) is not None:
        cargs.extend([
            "-erode",
            str(params.get("erode", None))
        ])
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    cargs.append(execution.input_file(params.get("in_file", None)))
    return cargs


def v_3d_automask_outputs(
    params: V3dAutomaskParameters,
    execution: Execution,
) -> V3dAutomaskOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAutomaskOutputs(
        root=execution.output_file("."),
        brain_file=execution.output_file(params.get("apply_prefix", None)) if (params.get("apply_prefix") is not None) else None,
        mask_file=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_automask_execute(
    params: V3dAutomaskParameters,
    runner: Runner | None = None,
) -> V3dAutomaskOutputs:
    """
    3dAutomask
    
    Create a brain-only mask of the image using AFNI 3dAutomask command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAutomaskOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_AUTOMASK_METADATA)
    params = execution.params(params)
    cargs = v_3d_automask_cargs(params, execution)
    ret = v_3d_automask_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_automask(
    in_file: InputPathType,
    prefix: str | None = None,
    apply_prefix: str | None = None,
    clfrac: float | None = None,
    dilate: int | None = None,
    erode: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    runner: Runner | None = None,
) -> V3dAutomaskOutputs:
    """
    3dAutomask
    
    Create a brain-only mask of the image using AFNI 3dAutomask command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dautomask.
        prefix: Write mask into dataset with prefix 'ppp'. [Default ==\
            'automask'].
        apply_prefix: Apply mask to input dataset and save masked dataset.
        clfrac: Sets the clip level fraction (must be 0.1-0.9). a small value\
            will tend to make the mask larger [default = 0.5].
        dilate: Dilate the mask outwards.
        erode: Erode the mask inwards.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAutomaskOutputs`).
    """
    params = v_3d_automask_params(
        prefix=prefix,
        apply_prefix=apply_prefix,
        clfrac=clfrac,
        dilate=dilate,
        erode=erode,
        outputtype=outputtype,
        in_file=in_file,
    )
    return v_3d_automask_execute(params, runner)


__all__ = [
    "V3dAutomaskOutputs",
    "V_3D_AUTOMASK_METADATA",
    "v_3d_automask",
    "v_3d_automask_execute",
    "v_3d_automask_params",
]
