# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_BRAIN_SYNC_METADATA = Metadata(
    id="36cb746b4c748e8e57c312e3792ccd7d013e7b17.boutiques",
    name="3dBrainSync",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dBrainSyncParameters = typing.TypedDict('V3dBrainSyncParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dBrainSync"]],
    "inset1": InputPathType,
    "inset2": InputPathType,
    "qprefix": typing.NotRequired[str | None],
    "pprefix": typing.NotRequired[str | None],
    "normalize": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "verb": bool,
})
V3dBrainSyncParametersTagged = typing.TypedDict('V3dBrainSyncParametersTagged', {
    "@type": typing.Literal["afni/3dBrainSync"],
    "inset1": InputPathType,
    "inset2": InputPathType,
    "qprefix": typing.NotRequired[str | None],
    "pprefix": typing.NotRequired[str | None],
    "normalize": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "verb": bool,
})


class V3dBrainSyncOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dBrainSyncParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    qprefix_output: OutputPathType | None
    """Output dataset after orthogonal matrix transformation"""
    pprefix_output: OutputPathType | None
    """Output dataset after permutation transformation"""
    qprefix_sval: OutputPathType | None
    """Singular values from the BC' decomposition"""
    qprefix_qmat: OutputPathType | None
    """Q matrix"""
    pprefix_perm: OutputPathType | None
    """Permutation indexes p(i)"""


def v_3d_brain_sync_params(
    inset1: InputPathType,
    inset2: InputPathType,
    qprefix: str | None = None,
    pprefix: str | None = None,
    normalize: bool = False,
    mask: InputPathType | None = None,
    verb: bool = False,
) -> V3dBrainSyncParametersTagged:
    """
    Build parameters.
    
    Args:
        inset1: Reference dataset.
        inset2: Dataset to be matched to the reference dataset.
        qprefix: Specifies the output dataset to be used for the orthogonal\
            matrix transformation.
        pprefix: Specifies the output dataset to be used for the permutation\
            transformation.
        normalize: Normalize the output dataset(s) so that each time series has\
            sum-of-squares = 1.
        mask: Only operate on nonzero voxels in the mask dataset.
        verb: Print some progress reports and auxiliary information.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dBrainSync",
        "inset1": inset1,
        "inset2": inset2,
        "normalize": normalize,
        "verb": verb,
    }
    if qprefix is not None:
        params["qprefix"] = qprefix
    if pprefix is not None:
        params["pprefix"] = pprefix
    if mask is not None:
        params["mask"] = mask
    return params


def v_3d_brain_sync_cargs(
    params: V3dBrainSyncParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dBrainSync")
    cargs.extend([
        "-inset1",
        execution.input_file(params.get("inset1", None))
    ])
    cargs.extend([
        "-inset2",
        execution.input_file(params.get("inset2", None))
    ])
    if params.get("qprefix", None) is not None:
        cargs.extend([
            "-Qprefix",
            params.get("qprefix", None)
        ])
    if params.get("pprefix", None) is not None:
        cargs.extend([
            "-Pprefix",
            params.get("pprefix", None)
        ])
    if params.get("normalize", False):
        cargs.append("-normalize")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("verb", False):
        cargs.append("-verb")
    return cargs


def v_3d_brain_sync_outputs(
    params: V3dBrainSyncParameters,
    execution: Execution,
) -> V3dBrainSyncOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dBrainSyncOutputs(
        root=execution.output_file("."),
        qprefix_output=execution.output_file(params.get("qprefix", None) + ".nii") if (params.get("qprefix") is not None) else None,
        pprefix_output=execution.output_file(params.get("pprefix", None) + ".nii") if (params.get("pprefix") is not None) else None,
        qprefix_sval=execution.output_file(params.get("qprefix", None) + ".sval.1D") if (params.get("qprefix") is not None) else None,
        qprefix_qmat=execution.output_file(params.get("qprefix", None) + ".qmat.1D") if (params.get("qprefix") is not None) else None,
        pprefix_perm=execution.output_file(params.get("pprefix", None) + ".perm.1D") if (params.get("pprefix") is not None) else None,
    )
    return ret


def v_3d_brain_sync_execute(
    params: V3dBrainSyncParameters,
    runner: Runner | None = None,
) -> V3dBrainSyncOutputs:
    """
    3dBrainSync
    
    'Synchronizes' the -inset2 dataset to match the -inset1 dataset, using
    orthogonal or permutation transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dBrainSyncOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_BRAIN_SYNC_METADATA)
    params = execution.params(params)
    cargs = v_3d_brain_sync_cargs(params, execution)
    ret = v_3d_brain_sync_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_brain_sync(
    inset1: InputPathType,
    inset2: InputPathType,
    qprefix: str | None = None,
    pprefix: str | None = None,
    normalize: bool = False,
    mask: InputPathType | None = None,
    verb: bool = False,
    runner: Runner | None = None,
) -> V3dBrainSyncOutputs:
    """
    3dBrainSync
    
    'Synchronizes' the -inset2 dataset to match the -inset1 dataset, using
    orthogonal or permutation transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inset1: Reference dataset.
        inset2: Dataset to be matched to the reference dataset.
        qprefix: Specifies the output dataset to be used for the orthogonal\
            matrix transformation.
        pprefix: Specifies the output dataset to be used for the permutation\
            transformation.
        normalize: Normalize the output dataset(s) so that each time series has\
            sum-of-squares = 1.
        mask: Only operate on nonzero voxels in the mask dataset.
        verb: Print some progress reports and auxiliary information.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dBrainSyncOutputs`).
    """
    params = v_3d_brain_sync_params(
        inset1=inset1,
        inset2=inset2,
        qprefix=qprefix,
        pprefix=pprefix,
        normalize=normalize,
        mask=mask,
        verb=verb,
    )
    return v_3d_brain_sync_execute(params, runner)


__all__ = [
    "V3dBrainSyncOutputs",
    "V_3D_BRAIN_SYNC_METADATA",
    "v_3d_brain_sync",
    "v_3d_brain_sync_execute",
    "v_3d_brain_sync_params",
]
