# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_BRICK_STAT_METADATA = Metadata(
    id="e3c343d74218f80738d6518abc69819afe7c7458.boutiques",
    name="3dBrickStat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dBrickStatParameters = typing.TypedDict('V3dBrickStatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dBrickStat"]],
    "dataset": str,
    "quick": bool,
    "slow": bool,
    "min": bool,
    "max": bool,
    "mean": bool,
    "sum": bool,
    "var": bool,
    "stdev": bool,
    "count": bool,
    "volume": bool,
    "positive": bool,
    "negative": bool,
    "zero": bool,
    "non_positive": bool,
    "non_negative": bool,
    "non_zero": bool,
    "absolute": bool,
    "nan": bool,
    "nonan": bool,
    "mask": typing.NotRequired[str | None],
    "mrange": typing.NotRequired[list[float] | None],
    "mvalue": typing.NotRequired[float | None],
    "automask": bool,
    "percentile": typing.NotRequired[list[float] | None],
    "perclist": typing.NotRequired[list[float] | None],
    "median": bool,
    "perc_quiet": bool,
    "ver": bool,
    "help": bool,
})
V3dBrickStatParametersTagged = typing.TypedDict('V3dBrickStatParametersTagged', {
    "@type": typing.Literal["afni/3dBrickStat"],
    "dataset": str,
    "quick": bool,
    "slow": bool,
    "min": bool,
    "max": bool,
    "mean": bool,
    "sum": bool,
    "var": bool,
    "stdev": bool,
    "count": bool,
    "volume": bool,
    "positive": bool,
    "negative": bool,
    "zero": bool,
    "non_positive": bool,
    "non_negative": bool,
    "non_zero": bool,
    "absolute": bool,
    "nan": bool,
    "nonan": bool,
    "mask": typing.NotRequired[str | None],
    "mrange": typing.NotRequired[list[float] | None],
    "mvalue": typing.NotRequired[float | None],
    "automask": bool,
    "percentile": typing.NotRequired[list[float] | None],
    "perclist": typing.NotRequired[list[float] | None],
    "median": bool,
    "perc_quiet": bool,
    "ver": bool,
    "help": bool,
})


class V3dBrickStatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dBrickStatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    console_output: OutputPathType
    """Console output of computed statistics"""


def v_3d_brick_stat_params(
    dataset: str,
    quick: bool = False,
    slow: bool = False,
    min_: bool = False,
    max_: bool = False,
    mean: bool = False,
    sum_: bool = False,
    var: bool = False,
    stdev: bool = False,
    count: bool = False,
    volume: bool = False,
    positive: bool = False,
    negative: bool = False,
    zero: bool = False,
    non_positive: bool = False,
    non_negative: bool = False,
    non_zero: bool = False,
    absolute: bool = False,
    nan: bool = False,
    nonan: bool = False,
    mask: str | None = None,
    mrange: list[float] | None = None,
    mvalue: float | None = None,
    automask: bool = False,
    percentile: list[float] | None = None,
    perclist: list[float] | None = None,
    median: bool = False,
    perc_quiet: bool = False,
    ver: bool = False,
    help_: bool = False,
) -> V3dBrickStatParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        quick: Get the information from the header only (default).
        slow: Read the whole dataset to find the min and max values.
        min_: Print the minimum value in dataset.
        max_: Print the maximum value in dataset (default).
        mean: Print the mean value in dataset.
        sum_: Print the sum of values in the dataset.
        var: Print the variance in the dataset.
        stdev: Print the standard deviation in the dataset.
        count: Print the number of voxels included.
        volume: Print the volume of voxels included in microliters.
        positive: Include only positive voxel values.
        negative: Include only negative voxel values.
        zero: Include only zero voxel values.
        non_positive: Include only voxel values 0 or negative.
        non_negative: Include only voxel values 0 or greater.
        non_zero: Include only voxel values not equal to 0.
        absolute: Use absolute value of voxel values for all calculations.
        nan: Include only voxel values that are NaN or inf. Forces -slow mode.
        nonan: Exclude voxel values that are NaN or inf.
        mask: Use the specified dataset as mask to include/exclude voxels.
        mrange: Only accept values between MIN and MAX (inclusive) from the\
            mask.
        mvalue: Only accept values equal to VAL from the mask.
        automask: Automatically compute mask for dataset. Cannot be combined\
            with -mask.
        percentile: Compute and print percentile values from p0% to p1% at a\
            step of ps%. Only one sub-brick is accepted as input with this option.
        perclist: Like -percentile, but output the given percentiles.
        median: Shortcut for -percentile 50 1 50 (or -perclist 1 50).
        perc_quiet: Only print percentile results, not input percentile cutoffs.
        ver: Print author and version info.
        help_: Print help screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dBrickStat",
        "dataset": dataset,
        "quick": quick,
        "slow": slow,
        "min": min_,
        "max": max_,
        "mean": mean,
        "sum": sum_,
        "var": var,
        "stdev": stdev,
        "count": count,
        "volume": volume,
        "positive": positive,
        "negative": negative,
        "zero": zero,
        "non_positive": non_positive,
        "non_negative": non_negative,
        "non_zero": non_zero,
        "absolute": absolute,
        "nan": nan,
        "nonan": nonan,
        "automask": automask,
        "median": median,
        "perc_quiet": perc_quiet,
        "ver": ver,
        "help": help_,
    }
    if mask is not None:
        params["mask"] = mask
    if mrange is not None:
        params["mrange"] = mrange
    if mvalue is not None:
        params["mvalue"] = mvalue
    if percentile is not None:
        params["percentile"] = percentile
    if perclist is not None:
        params["perclist"] = perclist
    return params


def v_3d_brick_stat_cargs(
    params: V3dBrickStatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dBrickStat")
    cargs.append(params.get("dataset", None))
    if params.get("quick", False):
        cargs.append("-quick")
    if params.get("slow", False):
        cargs.append("-slow")
    if params.get("min", False):
        cargs.append("-min")
    if params.get("max", False):
        cargs.append("-max")
    if params.get("mean", False):
        cargs.append("-mean")
    if params.get("sum", False):
        cargs.append("-sum")
    if params.get("var", False):
        cargs.append("-var")
    if params.get("stdev", False):
        cargs.append("-stdev")
    if params.get("count", False):
        cargs.append("-count")
    if params.get("volume", False):
        cargs.append("-volume")
    if params.get("positive", False):
        cargs.append("-positive")
    if params.get("negative", False):
        cargs.append("-negative")
    if params.get("zero", False):
        cargs.append("-zero")
    if params.get("non_positive", False):
        cargs.append("-non-positive")
    if params.get("non_negative", False):
        cargs.append("-non-negative")
    if params.get("non_zero", False):
        cargs.append("-non-zero")
    if params.get("absolute", False):
        cargs.append("-absolute")
    if params.get("nan", False):
        cargs.append("-nan")
    if params.get("nonan", False):
        cargs.append("-nonan")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            params.get("mask", None)
        ])
    if params.get("mrange", None) is not None:
        cargs.extend([
            "-mrange",
            *map(str, params.get("mrange", None))
        ])
    if params.get("mvalue", None) is not None:
        cargs.extend([
            "-mvalue",
            str(params.get("mvalue", None))
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("percentile", None) is not None:
        cargs.extend([
            "-percentile",
            *map(str, params.get("percentile", None))
        ])
    if params.get("perclist", None) is not None:
        cargs.extend([
            "-perclist",
            *map(str, params.get("perclist", None))
        ])
    if params.get("median", False):
        cargs.append("-median")
    if params.get("perc_quiet", False):
        cargs.append("-perc_quiet")
    if params.get("ver", False):
        cargs.append("-ver")
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def v_3d_brick_stat_outputs(
    params: V3dBrickStatParameters,
    execution: Execution,
) -> V3dBrickStatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dBrickStatOutputs(
        root=execution.output_file("."),
        console_output=execution.output_file("output.txt"),
    )
    return ret


def v_3d_brick_stat_execute(
    params: V3dBrickStatParameters,
    runner: Runner | None = None,
) -> V3dBrickStatOutputs:
    """
    3dBrickStat
    
    Compute voxel statistics of an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dBrickStatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_BRICK_STAT_METADATA)
    params = execution.params(params)
    cargs = v_3d_brick_stat_cargs(params, execution)
    ret = v_3d_brick_stat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_brick_stat(
    dataset: str,
    quick: bool = False,
    slow: bool = False,
    min_: bool = False,
    max_: bool = False,
    mean: bool = False,
    sum_: bool = False,
    var: bool = False,
    stdev: bool = False,
    count: bool = False,
    volume: bool = False,
    positive: bool = False,
    negative: bool = False,
    zero: bool = False,
    non_positive: bool = False,
    non_negative: bool = False,
    non_zero: bool = False,
    absolute: bool = False,
    nan: bool = False,
    nonan: bool = False,
    mask: str | None = None,
    mrange: list[float] | None = None,
    mvalue: float | None = None,
    automask: bool = False,
    percentile: list[float] | None = None,
    perclist: list[float] | None = None,
    median: bool = False,
    perc_quiet: bool = False,
    ver: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dBrickStatOutputs:
    """
    3dBrickStat
    
    Compute voxel statistics of an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        quick: Get the information from the header only (default).
        slow: Read the whole dataset to find the min and max values.
        min_: Print the minimum value in dataset.
        max_: Print the maximum value in dataset (default).
        mean: Print the mean value in dataset.
        sum_: Print the sum of values in the dataset.
        var: Print the variance in the dataset.
        stdev: Print the standard deviation in the dataset.
        count: Print the number of voxels included.
        volume: Print the volume of voxels included in microliters.
        positive: Include only positive voxel values.
        negative: Include only negative voxel values.
        zero: Include only zero voxel values.
        non_positive: Include only voxel values 0 or negative.
        non_negative: Include only voxel values 0 or greater.
        non_zero: Include only voxel values not equal to 0.
        absolute: Use absolute value of voxel values for all calculations.
        nan: Include only voxel values that are NaN or inf. Forces -slow mode.
        nonan: Exclude voxel values that are NaN or inf.
        mask: Use the specified dataset as mask to include/exclude voxels.
        mrange: Only accept values between MIN and MAX (inclusive) from the\
            mask.
        mvalue: Only accept values equal to VAL from the mask.
        automask: Automatically compute mask for dataset. Cannot be combined\
            with -mask.
        percentile: Compute and print percentile values from p0% to p1% at a\
            step of ps%. Only one sub-brick is accepted as input with this option.
        perclist: Like -percentile, but output the given percentiles.
        median: Shortcut for -percentile 50 1 50 (or -perclist 1 50).
        perc_quiet: Only print percentile results, not input percentile cutoffs.
        ver: Print author and version info.
        help_: Print help screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dBrickStatOutputs`).
    """
    params = v_3d_brick_stat_params(
        dataset=dataset,
        quick=quick,
        slow=slow,
        min_=min_,
        max_=max_,
        mean=mean,
        sum_=sum_,
        var=var,
        stdev=stdev,
        count=count,
        volume=volume,
        positive=positive,
        negative=negative,
        zero=zero,
        non_positive=non_positive,
        non_negative=non_negative,
        non_zero=non_zero,
        absolute=absolute,
        nan=nan,
        nonan=nonan,
        mask=mask,
        mrange=mrange,
        mvalue=mvalue,
        automask=automask,
        percentile=percentile,
        perclist=perclist,
        median=median,
        perc_quiet=perc_quiet,
        ver=ver,
        help_=help_,
    )
    return v_3d_brick_stat_execute(params, runner)


__all__ = [
    "V3dBrickStatOutputs",
    "V_3D_BRICK_STAT_METADATA",
    "v_3d_brick_stat",
    "v_3d_brick_stat_execute",
    "v_3d_brick_stat_params",
]
