# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CLIP_LEVEL_METADATA = Metadata(
    id="fd4a8baf337596ea9a1bc436e3a61d90b89ee692.boutiques",
    name="3dClipLevel",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dClipLevelParameters = typing.TypedDict('V3dClipLevelParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dClipLevel"]],
    "dataset": InputPathType,
    "mfrac": typing.NotRequired[float | None],
    "doall": bool,
    "grad": typing.NotRequired[str | None],
})
V3dClipLevelParametersTagged = typing.TypedDict('V3dClipLevelParametersTagged', {
    "@type": typing.Literal["afni/3dClipLevel"],
    "dataset": InputPathType,
    "mfrac": typing.NotRequired[float | None],
    "doall": bool,
    "grad": typing.NotRequired[str | None],
})


class V3dClipLevelOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dClipLevelParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_clip_level_params(
    dataset: InputPathType,
    mfrac: float | None = None,
    doall: bool = False,
    grad: str | None = None,
) -> V3dClipLevelParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset (e.g. dataset.nii.gz).
        mfrac: Use the number ff instead of 0.50 in the algorithm.
        doall: Apply the algorithm to each sub-brick separately.
        grad: Compute a 'gradual' clip level as a function of voxel position\
            and output to a dataset with the given prefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dClipLevel",
        "dataset": dataset,
        "doall": doall,
    }
    if mfrac is not None:
        params["mfrac"] = mfrac
    if grad is not None:
        params["grad"] = grad
    return params


def v_3d_clip_level_cargs(
    params: V3dClipLevelParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dClipLevel")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("mfrac", None) is not None:
        cargs.extend([
            "-mfrac",
            str(params.get("mfrac", None))
        ])
    if params.get("doall", False):
        cargs.append("-doall")
    if params.get("grad", None) is not None:
        cargs.extend([
            "-grad",
            params.get("grad", None)
        ])
    return cargs


def v_3d_clip_level_outputs(
    params: V3dClipLevelParameters,
    execution: Execution,
) -> V3dClipLevelOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dClipLevelOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_clip_level_execute(
    params: V3dClipLevelParameters,
    runner: Runner | None = None,
) -> V3dClipLevelOutputs:
    """
    3dClipLevel
    
    Estimates the value at which to clip the anatomical dataset so that
    background regions are set to zero.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClipLevelOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CLIP_LEVEL_METADATA)
    params = execution.params(params)
    cargs = v_3d_clip_level_cargs(params, execution)
    ret = v_3d_clip_level_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_clip_level(
    dataset: InputPathType,
    mfrac: float | None = None,
    doall: bool = False,
    grad: str | None = None,
    runner: Runner | None = None,
) -> V3dClipLevelOutputs:
    """
    3dClipLevel
    
    Estimates the value at which to clip the anatomical dataset so that
    background regions are set to zero.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset (e.g. dataset.nii.gz).
        mfrac: Use the number ff instead of 0.50 in the algorithm.
        doall: Apply the algorithm to each sub-brick separately.
        grad: Compute a 'gradual' clip level as a function of voxel position\
            and output to a dataset with the given prefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClipLevelOutputs`).
    """
    params = v_3d_clip_level_params(
        dataset=dataset,
        mfrac=mfrac,
        doall=doall,
        grad=grad,
    )
    return v_3d_clip_level_execute(params, runner)


__all__ = [
    "V3dClipLevelOutputs",
    "V_3D_CLIP_LEVEL_METADATA",
    "v_3d_clip_level",
    "v_3d_clip_level_execute",
    "v_3d_clip_level_params",
]
