# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CLUST_SIM_METADATA = Metadata(
    id="0c35843247cd8857e9d84ff47e38d9298db2301a.boutiques",
    name="3dClustSim",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dClustSimParameters = typing.TypedDict('V3dClustSimParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dClustSim"]],
    "nxyz": typing.NotRequired[str | None],
    "dxyz": typing.NotRequired[str | None],
    "ball": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "oksmallmask": bool,
    "inset": typing.NotRequired[list[InputPathType] | None],
    "fwhm": typing.NotRequired[float | None],
    "acf": typing.NotRequired[str | None],
    "nopad": bool,
    "pthr": typing.NotRequired[str | None],
    "athr": typing.NotRequired[str | None],
    "lots": bool,
    "mega": bool,
    "iter": typing.NotRequired[float | None],
    "nodec": bool,
    "seed": typing.NotRequired[float | None],
    "niml": bool,
    "both": bool,
    "prefix": typing.NotRequired[str | None],
    "cmd": typing.NotRequired[str | None],
    "quiet": bool,
    "ssave": typing.NotRequired[str | None],
})
V3dClustSimParametersTagged = typing.TypedDict('V3dClustSimParametersTagged', {
    "@type": typing.Literal["afni/3dClustSim"],
    "nxyz": typing.NotRequired[str | None],
    "dxyz": typing.NotRequired[str | None],
    "ball": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "oksmallmask": bool,
    "inset": typing.NotRequired[list[InputPathType] | None],
    "fwhm": typing.NotRequired[float | None],
    "acf": typing.NotRequired[str | None],
    "nopad": bool,
    "pthr": typing.NotRequired[str | None],
    "athr": typing.NotRequired[str | None],
    "lots": bool,
    "mega": bool,
    "iter": typing.NotRequired[float | None],
    "nodec": bool,
    "seed": typing.NotRequired[float | None],
    "niml": bool,
    "both": bool,
    "prefix": typing.NotRequired[str | None],
    "cmd": typing.NotRequired[str | None],
    "quiet": bool,
    "ssave": typing.NotRequired[str | None],
})


class V3dClustSimOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dClustSimParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_nn1_1sided: OutputPathType | None
    """Output file for NN1 with 1-sided thresholding"""
    output_nn1_2sided: OutputPathType | None
    """Output file for NN1 with 2-sided thresholding"""
    output_nn1_bisided: OutputPathType | None
    """Output file for NN1 with bi-sided thresholding"""
    output_nn2_1sided: OutputPathType | None
    """Output file for NN2 with 1-sided thresholding"""
    output_nn2_2sided: OutputPathType | None
    """Output file for NN2 with 2-sided thresholding"""
    output_nn2_bisided: OutputPathType | None
    """Output file for NN2 with bi-sided thresholding"""
    output_nn3_1sided: OutputPathType | None
    """Output file for NN3 with 1-sided thresholding"""
    output_nn3_2sided: OutputPathType | None
    """Output file for NN3 with 2-sided thresholding"""
    output_nn3_bisided: OutputPathType | None
    """Output file for NN3 with bi-sided thresholding"""
    mask_compressed: OutputPathType | None
    """Compressed ASCII encoding of the mask volume"""


def v_3d_clust_sim_params(
    nxyz: str | None = None,
    dxyz: str | None = None,
    ball: bool = False,
    mask: InputPathType | None = None,
    oksmallmask: bool = False,
    inset: list[InputPathType] | None = None,
    fwhm: float | None = None,
    acf: str | None = None,
    nopad: bool = False,
    pthr: str | None = None,
    athr: str | None = None,
    lots: bool = False,
    mega: bool = False,
    iter_: float | None = None,
    nodec: bool = False,
    seed: float | None = None,
    niml: bool = False,
    both: bool = False,
    prefix: str | None = None,
    cmd_: str | None = None,
    quiet: bool = False,
    ssave: str | None = None,
) -> V3dClustSimParametersTagged:
    """
    Build parameters.
    
    Args:
        nxyz: Size of 3D grid to use for simulation.
        dxyz: Voxel sizes along each dimension.
        ball: Mask off points outside a ball at the center of the grid.
        mask: Use the 0 sub-brick of this dataset as a mask.
        oksmallmask: Allow small masks with less than 128 nonzero voxels.
        inset: Use these dataset(s) as the simulations to threshold and\
            clusterize.
        fwhm: Gaussian filter width in mm (use -fwhmxyz for different values\
            per axis).
        acf: Parameters a, b, c for the autocorrelation function.
        nopad: Turn off padding slices added for edge effects.
        pthr: List of uncorrected per voxel p-values.
        athr: List of corrected whole volume alpha-values.
        lots: Use a longer list of values for pthr and athr.
        mega: Add even more values to the pthr and athr grids.
        iter_: Number of Monte Carlo simulations.
        nodec: Print the cluster size threshold as an integer.
        seed: Random number seed.
        niml: Output the table in XML/NIML format.
        both: Output the table in both XML/NIML format and in .1D format.
        prefix: Specify prefix for the output files.
        cmd_: Write command for putting results into a file's header.
        quiet: Don't print out progress reports.
        ssave: Save un-thresholded generated random volumes.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dClustSim",
        "ball": ball,
        "oksmallmask": oksmallmask,
        "nopad": nopad,
        "lots": lots,
        "mega": mega,
        "nodec": nodec,
        "niml": niml,
        "both": both,
        "quiet": quiet,
    }
    if nxyz is not None:
        params["nxyz"] = nxyz
    if dxyz is not None:
        params["dxyz"] = dxyz
    if mask is not None:
        params["mask"] = mask
    if inset is not None:
        params["inset"] = inset
    if fwhm is not None:
        params["fwhm"] = fwhm
    if acf is not None:
        params["acf"] = acf
    if pthr is not None:
        params["pthr"] = pthr
    if athr is not None:
        params["athr"] = athr
    if iter_ is not None:
        params["iter"] = iter_
    if seed is not None:
        params["seed"] = seed
    if prefix is not None:
        params["prefix"] = prefix
    if cmd_ is not None:
        params["cmd"] = cmd_
    if ssave is not None:
        params["ssave"] = ssave
    return params


def v_3d_clust_sim_cargs(
    params: V3dClustSimParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dClustSim")
    if params.get("nxyz", None) is not None:
        cargs.extend([
            "-nxyz",
            params.get("nxyz", None)
        ])
    if params.get("dxyz", None) is not None:
        cargs.extend([
            "-dxyz",
            params.get("dxyz", None)
        ])
    if params.get("ball", False):
        cargs.append("-BALL")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("oksmallmask", False):
        cargs.append("-OKsmallmask")
    if params.get("inset", None) is not None:
        cargs.extend([
            "-inset",
            *[execution.input_file(f) for f in params.get("inset", None)]
        ])
    if params.get("fwhm", None) is not None:
        cargs.extend([
            "-fwhm",
            str(params.get("fwhm", None))
        ])
    if params.get("acf", None) is not None:
        cargs.extend([
            "-acf",
            params.get("acf", None)
        ])
    if params.get("nopad", False):
        cargs.append("-nopad")
    if params.get("pthr", None) is not None:
        cargs.extend([
            "-pthr",
            params.get("pthr", None)
        ])
    if params.get("athr", None) is not None:
        cargs.extend([
            "-athr",
            params.get("athr", None)
        ])
    if params.get("lots", False):
        cargs.append("-LOTS")
    if params.get("mega", False):
        cargs.append("-MEGA")
    if params.get("iter", None) is not None:
        cargs.extend([
            "-iter",
            str(params.get("iter", None))
        ])
    if params.get("nodec", False):
        cargs.append("-nodec")
    if params.get("seed", None) is not None:
        cargs.extend([
            "-seed",
            str(params.get("seed", None))
        ])
    if params.get("niml", False):
        cargs.append("-niml")
    if params.get("both", False):
        cargs.append("-both")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("cmd", None) is not None:
        cargs.extend([
            "-cmd",
            params.get("cmd", None)
        ])
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("ssave", None) is not None:
        cargs.extend([
            "-ssave",
            params.get("ssave", None)
        ])
    return cargs


def v_3d_clust_sim_outputs(
    params: V3dClustSimParameters,
    execution: Execution,
) -> V3dClustSimOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dClustSimOutputs(
        root=execution.output_file("."),
        output_nn1_1sided=execution.output_file(params.get("prefix", None) + ".NN1_1sided.1D") if (params.get("prefix") is not None) else None,
        output_nn1_2sided=execution.output_file(params.get("prefix", None) + ".NN1_2sided.1D") if (params.get("prefix") is not None) else None,
        output_nn1_bisided=execution.output_file(params.get("prefix", None) + ".NN1_bisided.1D") if (params.get("prefix") is not None) else None,
        output_nn2_1sided=execution.output_file(params.get("prefix", None) + ".NN2_1sided.1D") if (params.get("prefix") is not None) else None,
        output_nn2_2sided=execution.output_file(params.get("prefix", None) + ".NN2_2sided.1D") if (params.get("prefix") is not None) else None,
        output_nn2_bisided=execution.output_file(params.get("prefix", None) + ".NN2_bisided.1D") if (params.get("prefix") is not None) else None,
        output_nn3_1sided=execution.output_file(params.get("prefix", None) + ".NN3_1sided.1D") if (params.get("prefix") is not None) else None,
        output_nn3_2sided=execution.output_file(params.get("prefix", None) + ".NN3_2sided.1D") if (params.get("prefix") is not None) else None,
        output_nn3_bisided=execution.output_file(params.get("prefix", None) + ".NN3_bisided.1D") if (params.get("prefix") is not None) else None,
        mask_compressed=execution.output_file(params.get("prefix", None) + ".mask") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_clust_sim_execute(
    params: V3dClustSimParameters,
    runner: Runner | None = None,
) -> V3dClustSimOutputs:
    """
    3dClustSim
    
    Program to estimate the probability of false positive (noise-only) clusters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClustSimOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CLUST_SIM_METADATA)
    params = execution.params(params)
    cargs = v_3d_clust_sim_cargs(params, execution)
    ret = v_3d_clust_sim_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_clust_sim(
    nxyz: str | None = None,
    dxyz: str | None = None,
    ball: bool = False,
    mask: InputPathType | None = None,
    oksmallmask: bool = False,
    inset: list[InputPathType] | None = None,
    fwhm: float | None = None,
    acf: str | None = None,
    nopad: bool = False,
    pthr: str | None = None,
    athr: str | None = None,
    lots: bool = False,
    mega: bool = False,
    iter_: float | None = None,
    nodec: bool = False,
    seed: float | None = None,
    niml: bool = False,
    both: bool = False,
    prefix: str | None = None,
    cmd_: str | None = None,
    quiet: bool = False,
    ssave: str | None = None,
    runner: Runner | None = None,
) -> V3dClustSimOutputs:
    """
    3dClustSim
    
    Program to estimate the probability of false positive (noise-only) clusters.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        nxyz: Size of 3D grid to use for simulation.
        dxyz: Voxel sizes along each dimension.
        ball: Mask off points outside a ball at the center of the grid.
        mask: Use the 0 sub-brick of this dataset as a mask.
        oksmallmask: Allow small masks with less than 128 nonzero voxels.
        inset: Use these dataset(s) as the simulations to threshold and\
            clusterize.
        fwhm: Gaussian filter width in mm (use -fwhmxyz for different values\
            per axis).
        acf: Parameters a, b, c for the autocorrelation function.
        nopad: Turn off padding slices added for edge effects.
        pthr: List of uncorrected per voxel p-values.
        athr: List of corrected whole volume alpha-values.
        lots: Use a longer list of values for pthr and athr.
        mega: Add even more values to the pthr and athr grids.
        iter_: Number of Monte Carlo simulations.
        nodec: Print the cluster size threshold as an integer.
        seed: Random number seed.
        niml: Output the table in XML/NIML format.
        both: Output the table in both XML/NIML format and in .1D format.
        prefix: Specify prefix for the output files.
        cmd_: Write command for putting results into a file's header.
        quiet: Don't print out progress reports.
        ssave: Save un-thresholded generated random volumes.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClustSimOutputs`).
    """
    params = v_3d_clust_sim_params(
        nxyz=nxyz,
        dxyz=dxyz,
        ball=ball,
        mask=mask,
        oksmallmask=oksmallmask,
        inset=inset,
        fwhm=fwhm,
        acf=acf,
        nopad=nopad,
        pthr=pthr,
        athr=athr,
        lots=lots,
        mega=mega,
        iter_=iter_,
        nodec=nodec,
        seed=seed,
        niml=niml,
        both=both,
        prefix=prefix,
        cmd_=cmd_,
        quiet=quiet,
        ssave=ssave,
    )
    return v_3d_clust_sim_execute(params, runner)


__all__ = [
    "V3dClustSimOutputs",
    "V_3D_CLUST_SIM_METADATA",
    "v_3d_clust_sim",
    "v_3d_clust_sim_execute",
    "v_3d_clust_sim_params",
]
