# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CONFORMIST_METADATA = Metadata(
    id="5364044bdb15b4b167c48ea32e2e56b54471409d.boutiques",
    name="3dConformist",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dConformistParameters = typing.TypedDict('V3dConformistParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dConformist"]],
    "input_files": list[InputPathType],
})
V3dConformistParametersTagged = typing.TypedDict('V3dConformistParametersTagged', {
    "@type": typing.Literal["afni/3dConformist"],
    "input_files": list[InputPathType],
})


class V3dConformistOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dConformistParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType
    """Zero padded output dataset files"""


def v_3d_conformist_params(
    input_files: list[InputPathType],
) -> V3dConformistParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input datasets to be zero padded to the same size.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dConformist",
        "input_files": input_files,
    }
    return params


def v_3d_conformist_cargs(
    params: V3dConformistParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dConformist")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def v_3d_conformist_outputs(
    params: V3dConformistParameters,
    execution: Execution,
) -> V3dConformistOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dConformistOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file("."),
    )
    return ret


def v_3d_conformist_execute(
    params: V3dConformistParameters,
    runner: Runner | None = None,
) -> V3dConformistOutputs:
    """
    3dConformist
    
    Program to conform a collection of datasets to the same size by zero
    padding.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dConformistOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CONFORMIST_METADATA)
    params = execution.params(params)
    cargs = v_3d_conformist_cargs(params, execution)
    ret = v_3d_conformist_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_conformist(
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> V3dConformistOutputs:
    """
    3dConformist
    
    Program to conform a collection of datasets to the same size by zero
    padding.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input datasets to be zero padded to the same size.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dConformistOutputs`).
    """
    params = v_3d_conformist_params(
        input_files=input_files,
    )
    return v_3d_conformist_execute(params, runner)


__all__ = [
    "V3dConformistOutputs",
    "V_3D_CONFORMIST_METADATA",
    "v_3d_conformist",
    "v_3d_conformist_execute",
    "v_3d_conformist_params",
]
