# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CONVOLVE_METADATA = Metadata(
    id="8f3103e3d9bb6441f1e9c0b890b87c89f981bcc0.boutiques",
    name="3dConvolve",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dConvolveParameters = typing.TypedDict('V3dConvolveParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dConvolve"]],
    "infile": InputPathType,
    "outfile": str,
    "options": typing.NotRequired[str | None],
})
V3dConvolveParametersTagged = typing.TypedDict('V3dConvolveParametersTagged', {
    "@type": typing.Literal["afni/3dConvolve"],
    "infile": InputPathType,
    "outfile": str,
    "options": typing.NotRequired[str | None],
})


class V3dConvolveOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dConvolveParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Main output file of 3dConvolve"""


def v_3d_convolve_params(
    infile: InputPathType,
    outfile: str,
    options: str | None = None,
) -> V3dConvolveParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input file for 3dConvolve.
        outfile: Output file for 3dConvolve.
        options: Additional options for 3dConvolve.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dConvolve",
        "infile": infile,
        "outfile": outfile,
    }
    if options is not None:
        params["options"] = options
    return params


def v_3d_convolve_cargs(
    params: V3dConvolveParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dConvolve")
    cargs.append(execution.input_file(params.get("infile", None)))
    cargs.append(params.get("outfile", None))
    if params.get("options", None) is not None:
        cargs.extend([
            "-options",
            params.get("options", None)
        ])
    return cargs


def v_3d_convolve_outputs(
    params: V3dConvolveParameters,
    execution: Execution,
) -> V3dConvolveOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dConvolveOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("outfile", None)),
    )
    return ret


def v_3d_convolve_execute(
    params: V3dConvolveParameters,
    runner: Runner | None = None,
) -> V3dConvolveOutputs:
    """
    3dConvolve
    
    3dConvolve is no longer supported in AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dConvolveOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CONVOLVE_METADATA)
    params = execution.params(params)
    cargs = v_3d_convolve_cargs(params, execution)
    ret = v_3d_convolve_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_convolve(
    infile: InputPathType,
    outfile: str,
    options: str | None = None,
    runner: Runner | None = None,
) -> V3dConvolveOutputs:
    """
    3dConvolve
    
    3dConvolve is no longer supported in AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file for 3dConvolve.
        outfile: Output file for 3dConvolve.
        options: Additional options for 3dConvolve.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dConvolveOutputs`).
    """
    params = v_3d_convolve_params(
        infile=infile,
        outfile=outfile,
        options=options,
    )
    return v_3d_convolve_execute(params, runner)


__all__ = [
    "V3dConvolveOutputs",
    "V_3D_CONVOLVE_METADATA",
    "v_3d_convolve",
    "v_3d_convolve_execute",
    "v_3d_convolve_params",
]
