# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CRUISETO_AFNI_METADATA = Metadata(
    id="a0d718d69b1cc124137138a300055a2430043a08.boutiques",
    name="3dCRUISEtoAFNI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dCruisetoAfniTraceParameters = typing.TypedDict('V3dCruisetoAfniTraceParameters', {
    "@type": typing.NotRequired[typing.Literal["trace"]],
    "trace": bool,
    "TRACE": bool,
})
V3dCruisetoAfniTraceParametersTagged = typing.TypedDict('V3dCruisetoAfniTraceParametersTagged', {
    "@type": typing.Literal["trace"],
    "trace": bool,
    "TRACE": bool,
})


V3dCruisetoAfniParameters = typing.TypedDict('V3dCruisetoAfniParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dCRUISEtoAFNI"]],
    "input": InputPathType,
    "novolreg": bool,
    "noxform": bool,
    "setenv": typing.NotRequired[str | None],
    "trace": typing.NotRequired[V3dCruisetoAfniTraceParameters | None],
    "nomall": bool,
    "yesmall": bool,
    "help": bool,
    "h": bool,
})
V3dCruisetoAfniParametersTagged = typing.TypedDict('V3dCruisetoAfniParametersTagged', {
    "@type": typing.Literal["afni/3dCRUISEtoAFNI"],
    "input": InputPathType,
    "novolreg": bool,
    "noxform": bool,
    "setenv": typing.NotRequired[str | None],
    "trace": typing.NotRequired[V3dCruisetoAfniTraceParameters | None],
    "nomall": bool,
    "yesmall": bool,
    "help": bool,
    "h": bool,
})


def v_3d_cruiseto_afni_trace_params(
    trace_: bool = False,
    trace_2: bool = False,
) -> V3dCruisetoAfniTraceParametersTagged:
    """
    Build parameters.
    
    Args:
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        trace_2: Turns on extreme tracing.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "trace",
        "trace": trace_,
        "TRACE": trace_2,
    }
    return params


def v_3d_cruiseto_afni_trace_cargs(
    params: V3dCruisetoAfniTraceParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    if params.get("trace", False):
        cargs.append("-trace")
    if params.get("TRACE", False):
        cargs.append("-TRACE")
    return cargs


class V3dCruisetoAfniOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dCruisetoAfniParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_cruiseto_afni_params(
    input_: InputPathType,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: V3dCruisetoAfniTraceParameters | None = None,
    nomall: bool = False,
    yesmall: bool = False,
    help_: bool = False,
    h: bool = False,
) -> V3dCruisetoAfniParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Input CRUISE header file in OpenDX format.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary. Example: suma -setenv "'SUMA_BackgroundColor = 1 0 1'".
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
        help_: The entire help output.
        h: Displays mini help; in many cases, it's the same as -help.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dCRUISEtoAFNI",
        "input": input_,
        "novolreg": novolreg,
        "noxform": noxform,
        "nomall": nomall,
        "yesmall": yesmall,
        "help": help_,
        "h": h,
    }
    if setenv is not None:
        params["setenv"] = setenv
    if trace_ is not None:
        params["trace"] = trace_
    return params


def v_3d_cruiseto_afni_cargs(
    params: V3dCruisetoAfniParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dCRUISEtoAFNI")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input", None))
    ])
    if params.get("novolreg", False):
        cargs.append("-novolreg")
    if params.get("noxform", False):
        cargs.append("-noxform")
    if params.get("setenv", None) is not None:
        cargs.extend([
            "-setenv",
            params.get("setenv", None)
        ])
    if params.get("trace", None) is not None:
        cargs.extend(v_3d_cruiseto_afni_trace_cargs(params.get("trace", None), execution))
    if params.get("nomall", False):
        cargs.append("-nomall")
    if params.get("yesmall", False):
        cargs.append("-yesmall")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("h", False):
        cargs.append("-h")
    return cargs


def v_3d_cruiseto_afni_outputs(
    params: V3dCruisetoAfniParameters,
    execution: Execution,
) -> V3dCruisetoAfniOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dCruisetoAfniOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_cruiseto_afni_execute(
    params: V3dCruisetoAfniParameters,
    runner: Runner | None = None,
) -> V3dCruisetoAfniOutputs:
    """
    3dCRUISEtoAFNI
    
    Converts a CRUISE dataset defined by a header in OpenDX format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dCruisetoAfniOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CRUISETO_AFNI_METADATA)
    params = execution.params(params)
    cargs = v_3d_cruiseto_afni_cargs(params, execution)
    ret = v_3d_cruiseto_afni_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_cruiseto_afni(
    input_: InputPathType,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: V3dCruisetoAfniTraceParameters | None = None,
    nomall: bool = False,
    yesmall: bool = False,
    help_: bool = False,
    h: bool = False,
    runner: Runner | None = None,
) -> V3dCruisetoAfniOutputs:
    """
    3dCRUISEtoAFNI
    
    Converts a CRUISE dataset defined by a header in OpenDX format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Input CRUISE header file in OpenDX format.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary. Example: suma -setenv "'SUMA_BackgroundColor = 1 0 1'".
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
        help_: The entire help output.
        h: Displays mini help; in many cases, it's the same as -help.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dCruisetoAfniOutputs`).
    """
    params = v_3d_cruiseto_afni_params(
        input_=input_,
        novolreg=novolreg,
        noxform=noxform,
        setenv=setenv,
        trace_=trace_,
        nomall=nomall,
        yesmall=yesmall,
        help_=help_,
        h=h,
    )
    return v_3d_cruiseto_afni_execute(params, runner)


__all__ = [
    "V3dCruisetoAfniOutputs",
    "V_3D_CRUISETO_AFNI_METADATA",
    "v_3d_cruiseto_afni",
    "v_3d_cruiseto_afni_execute",
    "v_3d_cruiseto_afni_params",
    "v_3d_cruiseto_afni_trace_params",
]
