# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DECONVOLVE_METADATA = Metadata(
    id="08b4eeadd57ceed9e4f25bde7f18f8c07ac59916.boutiques",
    name="3dDeconvolve",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDeconvolveParameters = typing.TypedDict('V3dDeconvolveParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDeconvolve"]],
    "input_dataset": InputPathType,
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "num_stimts": typing.NotRequired[int | None],
    "stim_file": typing.NotRequired[str | None],
    "stim_label": typing.NotRequired[str | None],
    "stim_base": bool,
    "stim_times": typing.NotRequired[str | None],
    "iresp": typing.NotRequired[str | None],
    "fitts": typing.NotRequired[str | None],
    "fout": bool,
    "tout": bool,
    "bucket": typing.NotRequired[str | None],
    "cbucket": typing.NotRequired[str | None],
    "x1D": typing.NotRequired[str | None],
    "jobs": typing.NotRequired[int | None],
})
V3dDeconvolveParametersTagged = typing.TypedDict('V3dDeconvolveParametersTagged', {
    "@type": typing.Literal["afni/3dDeconvolve"],
    "input_dataset": InputPathType,
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "num_stimts": typing.NotRequired[int | None],
    "stim_file": typing.NotRequired[str | None],
    "stim_label": typing.NotRequired[str | None],
    "stim_base": bool,
    "stim_times": typing.NotRequired[str | None],
    "iresp": typing.NotRequired[str | None],
    "fitts": typing.NotRequired[str | None],
    "fout": bool,
    "tout": bool,
    "bucket": typing.NotRequired[str | None],
    "cbucket": typing.NotRequired[str | None],
    "x1D": typing.NotRequired[str | None],
    "jobs": typing.NotRequired[int | None],
})


class V3dDeconvolveOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDeconvolveParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    bucket_output: OutputPathType | None
    """Main output bucket dataset in AFNI format."""
    cbucket_output: OutputPathType | None
    """Regression coefficients stored in a dataset."""
    iresp_output: OutputPathType | None
    """Estimated Impulse Response dataset."""
    fitts_output: OutputPathType | None
    """Fitted Time Series dataset in AFNI format."""
    x1d_file: OutputPathType | None
    """X-matrix output file in .1D format."""


def v_3d_deconvolve_params(
    input_dataset: InputPathType,
    mask_dataset: InputPathType | None = None,
    num_stimts: int | None = None,
    stim_file: str | None = None,
    stim_label: str | None = None,
    stim_base: bool = False,
    stim_times: str | None = None,
    iresp: str | None = None,
    fitts: str | None = None,
    fout: bool = False,
    tout: bool = False,
    bucket: str | None = None,
    cbucket: str | None = None,
    x1_d: str | None = None,
    jobs: int | None = None,
) -> V3dDeconvolveParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Filename of 3D+time input dataset.
        mask_dataset: Filename of 3D mask dataset.
        num_stimts: Number of input stimulus time series.
        stim_file: Filename of kth time series input stimulus.
        stim_label: Label for kth input stimulus.
        stim_base: Kth input stimulus is part of the baseline model.
        stim_times: Deconvolution response model for kth stimulus.
        iresp: Prefix for 3D+time output dataset which will contain the kth\
            estimated impulse response.
        fitts: Prefix for 3D+time output dataset which will contain the (full\
            model) time series fit to the input data.
        fout: Flag to output the F-statistics for each stimulus.
        tout: Flag to output the t-statistics.
        bucket: Create one AFNI 'bucket' dataset containing various parameters\
            of interest.
        cbucket: Save the regression coefficients (no statistics) into a\
            dataset.
        x1_d: Save X matrix to a .xmat.1D (ASCII) file.
        jobs: Run the program with multiple jobs (sub-processes).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDeconvolve",
        "input_dataset": input_dataset,
        "stim_base": stim_base,
        "fout": fout,
        "tout": tout,
    }
    if mask_dataset is not None:
        params["mask_dataset"] = mask_dataset
    if num_stimts is not None:
        params["num_stimts"] = num_stimts
    if stim_file is not None:
        params["stim_file"] = stim_file
    if stim_label is not None:
        params["stim_label"] = stim_label
    if stim_times is not None:
        params["stim_times"] = stim_times
    if iresp is not None:
        params["iresp"] = iresp
    if fitts is not None:
        params["fitts"] = fitts
    if bucket is not None:
        params["bucket"] = bucket
    if cbucket is not None:
        params["cbucket"] = cbucket
    if x1_d is not None:
        params["x1D"] = x1_d
    if jobs is not None:
        params["jobs"] = jobs
    return params


def v_3d_deconvolve_cargs(
    params: V3dDeconvolveParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDeconvolve")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset", None))
    ])
    if params.get("mask_dataset", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_dataset", None))
        ])
    if params.get("num_stimts", None) is not None:
        cargs.extend([
            "-num_stimts",
            str(params.get("num_stimts", None))
        ])
    if params.get("stim_file", None) is not None:
        cargs.extend([
            "-stim_file",
            params.get("stim_file", None)
        ])
    if params.get("stim_label", None) is not None:
        cargs.extend([
            "-stim_label",
            params.get("stim_label", None)
        ])
    if params.get("stim_base", False):
        cargs.append("-stim_base")
    if params.get("stim_times", None) is not None:
        cargs.extend([
            "-stim_times",
            params.get("stim_times", None)
        ])
    if params.get("iresp", None) is not None:
        cargs.extend([
            "-iresp",
            params.get("iresp", None)
        ])
    if params.get("fitts", None) is not None:
        cargs.extend([
            "-fitts",
            params.get("fitts", None)
        ])
    if params.get("fout", False):
        cargs.append("-fout")
    if params.get("tout", False):
        cargs.append("-tout")
    if params.get("bucket", None) is not None:
        cargs.extend([
            "-bucket",
            params.get("bucket", None)
        ])
    if params.get("cbucket", None) is not None:
        cargs.extend([
            "-cbucket",
            params.get("cbucket", None)
        ])
    if params.get("x1D", None) is not None:
        cargs.extend([
            "-x1D",
            params.get("x1D", None)
        ])
    if params.get("jobs", None) is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs", None))
        ])
    return cargs


def v_3d_deconvolve_outputs(
    params: V3dDeconvolveParameters,
    execution: Execution,
) -> V3dDeconvolveOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDeconvolveOutputs(
        root=execution.output_file("."),
        bucket_output=execution.output_file(params.get("bucket", None) + ".HEAD") if (params.get("bucket") is not None) else None,
        cbucket_output=execution.output_file(params.get("cbucket", None) + ".HEAD") if (params.get("cbucket") is not None) else None,
        iresp_output=execution.output_file(params.get("iresp", None) + ".HEAD") if (params.get("iresp") is not None) else None,
        fitts_output=execution.output_file(params.get("fitts", None) + ".HEAD") if (params.get("fitts") is not None) else None,
        x1d_file=execution.output_file(params.get("x1D", None) + ".1D") if (params.get("x1D") is not None) else None,
    )
    return ret


def v_3d_deconvolve_execute(
    params: V3dDeconvolveParameters,
    runner: Runner | None = None,
) -> V3dDeconvolveOutputs:
    """
    3dDeconvolve
    
    Program to calculate the deconvolution of a measurement 3D+time dataset with
    a specified input stimulus time series.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDeconvolveOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DECONVOLVE_METADATA)
    params = execution.params(params)
    cargs = v_3d_deconvolve_cargs(params, execution)
    ret = v_3d_deconvolve_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_deconvolve(
    input_dataset: InputPathType,
    mask_dataset: InputPathType | None = None,
    num_stimts: int | None = None,
    stim_file: str | None = None,
    stim_label: str | None = None,
    stim_base: bool = False,
    stim_times: str | None = None,
    iresp: str | None = None,
    fitts: str | None = None,
    fout: bool = False,
    tout: bool = False,
    bucket: str | None = None,
    cbucket: str | None = None,
    x1_d: str | None = None,
    jobs: int | None = None,
    runner: Runner | None = None,
) -> V3dDeconvolveOutputs:
    """
    3dDeconvolve
    
    Program to calculate the deconvolution of a measurement 3D+time dataset with
    a specified input stimulus time series.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Filename of 3D+time input dataset.
        mask_dataset: Filename of 3D mask dataset.
        num_stimts: Number of input stimulus time series.
        stim_file: Filename of kth time series input stimulus.
        stim_label: Label for kth input stimulus.
        stim_base: Kth input stimulus is part of the baseline model.
        stim_times: Deconvolution response model for kth stimulus.
        iresp: Prefix for 3D+time output dataset which will contain the kth\
            estimated impulse response.
        fitts: Prefix for 3D+time output dataset which will contain the (full\
            model) time series fit to the input data.
        fout: Flag to output the F-statistics for each stimulus.
        tout: Flag to output the t-statistics.
        bucket: Create one AFNI 'bucket' dataset containing various parameters\
            of interest.
        cbucket: Save the regression coefficients (no statistics) into a\
            dataset.
        x1_d: Save X matrix to a .xmat.1D (ASCII) file.
        jobs: Run the program with multiple jobs (sub-processes).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDeconvolveOutputs`).
    """
    params = v_3d_deconvolve_params(
        input_dataset=input_dataset,
        mask_dataset=mask_dataset,
        num_stimts=num_stimts,
        stim_file=stim_file,
        stim_label=stim_label,
        stim_base=stim_base,
        stim_times=stim_times,
        iresp=iresp,
        fitts=fitts,
        fout=fout,
        tout=tout,
        bucket=bucket,
        cbucket=cbucket,
        x1_d=x1_d,
        jobs=jobs,
    )
    return v_3d_deconvolve_execute(params, runner)


__all__ = [
    "V3dDeconvolveOutputs",
    "V_3D_DECONVOLVE_METADATA",
    "v_3d_deconvolve",
    "v_3d_deconvolve_execute",
    "v_3d_deconvolve_params",
]
