# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DEGREE_CENTRALITY_METADATA = Metadata(
    id="92d1c07bfff26718b69be19ce1645a7154290cb7.boutiques",
    name="3dDegreeCentrality",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDegreeCentralityParameters = typing.TypedDict('V3dDegreeCentralityParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDegreeCentrality"]],
    "autoclip": bool,
    "automask": bool,
    "in_file": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "oned_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})
V3dDegreeCentralityParametersTagged = typing.TypedDict('V3dDegreeCentralityParametersTagged', {
    "@type": typing.Literal["afni/3dDegreeCentrality"],
    "autoclip": bool,
    "automask": bool,
    "in_file": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "oned_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})


class V3dDegreeCentralityOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDegreeCentralityParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    oned_file_outfile: OutputPathType | None
    """The text output of the similarity matrix computed after thresholding with
    one-dimensional and ijk voxel indices, correlations, image extents, and
    affine matrix."""


def v_3d_degree_centrality_params(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    oned_file: str | None = None,
    polort: int | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
) -> V3dDegreeCentralityParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3ddegreecentrality.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        mask: Mask file to mask input data.
        oned_file: Output filepath to text dump of correlation matrix.
        polort: No description provided.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDegreeCentrality",
        "autoclip": autoclip,
        "automask": automask,
        "in_file": in_file,
    }
    if mask is not None:
        params["mask"] = mask
    if oned_file is not None:
        params["oned_file"] = oned_file
    if polort is not None:
        params["polort"] = polort
    if sparsity is not None:
        params["sparsity"] = sparsity
    if thresh is not None:
        params["thresh"] = thresh
    return params


def v_3d_degree_centrality_cargs(
    params: V3dDegreeCentralityParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDegreeCentrality")
    if params.get("autoclip", False):
        cargs.append("-autoclip")
    if params.get("automask", False):
        cargs.append("-automask")
    cargs.append(execution.input_file(params.get("in_file", None)))
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("oned_file", None) is not None:
        cargs.extend([
            "-out1D",
            params.get("oned_file", None)
        ])
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    if params.get("sparsity", None) is not None:
        cargs.extend([
            "-sparsity",
            str(params.get("sparsity", None))
        ])
    if params.get("thresh", None) is not None:
        cargs.extend([
            "-thresh",
            str(params.get("thresh", None))
        ])
    return cargs


def v_3d_degree_centrality_outputs(
    params: V3dDegreeCentralityParameters,
    execution: Execution,
) -> V3dDegreeCentralityOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDegreeCentralityOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file", None)).name),
        oned_file_outfile=execution.output_file(params.get("oned_file", None)) if (params.get("oned_file") is not None) else None,
    )
    return ret


def v_3d_degree_centrality_execute(
    params: V3dDegreeCentralityParameters,
    runner: Runner | None = None,
) -> V3dDegreeCentralityOutputs:
    """
    3dDegreeCentrality
    
    Computes voxelwise weighted and binary degree centrality and stores the
    result in a new 3D bucket dataset as floats to preserve their values. Degree
    centrality reflects the strength and extent of the correlation of a voxel
    with every other voxel in the brain. .
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDegreeCentralityOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DEGREE_CENTRALITY_METADATA)
    params = execution.params(params)
    cargs = v_3d_degree_centrality_cargs(params, execution)
    ret = v_3d_degree_centrality_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_degree_centrality(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    oned_file: str | None = None,
    polort: int | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
    runner: Runner | None = None,
) -> V3dDegreeCentralityOutputs:
    """
    3dDegreeCentrality
    
    Computes voxelwise weighted and binary degree centrality and stores the
    result in a new 3D bucket dataset as floats to preserve their values. Degree
    centrality reflects the strength and extent of the correlation of a voxel
    with every other voxel in the brain. .
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3ddegreecentrality.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        mask: Mask file to mask input data.
        oned_file: Output filepath to text dump of correlation matrix.
        polort: No description provided.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDegreeCentralityOutputs`).
    """
    params = v_3d_degree_centrality_params(
        autoclip=autoclip,
        automask=automask,
        in_file=in_file,
        mask=mask,
        oned_file=oned_file,
        polort=polort,
        sparsity=sparsity,
        thresh=thresh,
    )
    return v_3d_degree_centrality_execute(params, runner)


__all__ = [
    "V3dDegreeCentralityOutputs",
    "V_3D_DEGREE_CENTRALITY_METADATA",
    "v_3d_degree_centrality",
    "v_3d_degree_centrality_execute",
    "v_3d_degree_centrality_params",
]
