# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DESPIKE_METADATA = Metadata(
    id="0d9ca0fdaa93ca1595d1563a20d7d4f183471790.boutiques",
    name="3dDespike",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDespikeParameters = typing.TypedDict('V3dDespikeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDespike"]],
    "prefix": typing.NotRequired[str | None],
    "in_file": InputPathType,
})
V3dDespikeParametersTagged = typing.TypedDict('V3dDespikeParametersTagged', {
    "@type": typing.Literal["afni/3dDespike"],
    "prefix": typing.NotRequired[str | None],
    "in_file": InputPathType,
})


class V3dDespikeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDespikeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output file."""


def v_3d_despike_params(
    in_file: InputPathType,
    prefix: str | None = None,
) -> V3dDespikeParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3ddespike.
        prefix: Prefix for output file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDespike",
        "in_file": in_file,
    }
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_despike_cargs(
    params: V3dDespikeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDespike")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    cargs.append(execution.input_file(params.get("in_file", None)))
    return cargs


def v_3d_despike_outputs(
    params: V3dDespikeParameters,
    execution: Execution,
) -> V3dDespikeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDespikeOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_despike_execute(
    params: V3dDespikeParameters,
    runner: Runner | None = None,
) -> V3dDespikeOutputs:
    """
    3dDespike
    
    Removes 'spikes' from the 3D+time input dataset and writes a new dataset
    with the spike values replaced by something more pleasing to the eye.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDespikeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DESPIKE_METADATA)
    params = execution.params(params)
    cargs = v_3d_despike_cargs(params, execution)
    ret = v_3d_despike_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_despike(
    in_file: InputPathType,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dDespikeOutputs:
    """
    3dDespike
    
    Removes 'spikes' from the 3D+time input dataset and writes a new dataset
    with the spike values replaced by something more pleasing to the eye.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3ddespike.
        prefix: Prefix for output file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDespikeOutputs`).
    """
    params = v_3d_despike_params(
        prefix=prefix,
        in_file=in_file,
    )
    return v_3d_despike_execute(params, runner)


__all__ = [
    "V3dDespikeOutputs",
    "V_3D_DESPIKE_METADATA",
    "v_3d_despike",
    "v_3d_despike_execute",
    "v_3d_despike_params",
]
