# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DETREND_METADATA = Metadata(
    id="8103447086a47281a149ad00588e72a68068176d.boutiques",
    name="3dDetrend",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDetrendParameters = typing.TypedDict('V3dDetrendParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDetrend"]],
    "in_file": InputPathType,
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
})
V3dDetrendParametersTagged = typing.TypedDict('V3dDetrendParametersTagged', {
    "@type": typing.Literal["afni/3dDetrend"],
    "in_file": InputPathType,
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
})


class V3dDetrendOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDetrendParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    out_file_: OutputPathType
    """Output file."""


def v_3d_detrend_params(
    in_file: InputPathType,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
) -> V3dDetrendParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3ddetrend.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDetrend",
        "in_file": in_file,
    }
    if outputtype is not None:
        params["outputtype"] = outputtype
    return params


def v_3d_detrend_cargs(
    params: V3dDetrendParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDetrend")
    cargs.append(execution.input_file(params.get("in_file", None)))
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    return cargs


def v_3d_detrend_outputs(
    params: V3dDetrendParameters,
    execution: Execution,
) -> V3dDetrendOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDetrendOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file", None)).name + "_detrend"),
        out_file_=execution.output_file("out_file"),
    )
    return ret


def v_3d_detrend_execute(
    params: V3dDetrendParameters,
    runner: Runner | None = None,
) -> V3dDetrendOutputs:
    """
    3dDetrend
    
    This program removes components from voxel time series using linear least
    squares.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDetrendOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DETREND_METADATA)
    params = execution.params(params)
    cargs = v_3d_detrend_cargs(params, execution)
    ret = v_3d_detrend_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_detrend(
    in_file: InputPathType,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    runner: Runner | None = None,
) -> V3dDetrendOutputs:
    """
    3dDetrend
    
    This program removes components from voxel time series using linear least
    squares.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3ddetrend.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDetrendOutputs`).
    """
    params = v_3d_detrend_params(
        in_file=in_file,
        outputtype=outputtype,
    )
    return v_3d_detrend_execute(params, runner)


__all__ = [
    "V3dDetrendOutputs",
    "V_3D_DETREND_METADATA",
    "v_3d_detrend",
    "v_3d_detrend_execute",
    "v_3d_detrend_params",
]
