# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DFT_METADATA = Metadata(
    id="2962876f8d44b9744d34d11bb1c8253a9c686b30.boutiques",
    name="3dDFT",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDftParameters = typing.TypedDict('V3dDftParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDFT"]],
    "infile": InputPathType,
    "prefix": str,
    "abs_output": bool,
    "nfft": typing.NotRequired[float | None],
    "detrend": bool,
    "taper": typing.NotRequired[float | None],
    "inverse": bool,
})
V3dDftParametersTagged = typing.TypedDict('V3dDftParametersTagged', {
    "@type": typing.Literal["afni/3dDFT"],
    "infile": InputPathType,
    "prefix": str,
    "abs_output": bool,
    "nfft": typing.NotRequired[float | None],
    "detrend": bool,
    "taper": typing.NotRequired[float | None],
    "inverse": bool,
})


class V3dDftOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDftParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output dataset file"""
    outheader: OutputPathType
    """Output dataset header file"""


def v_3d_dft_params(
    infile: InputPathType,
    prefix: str,
    abs_output: bool = False,
    nfft: float | None = None,
    detrend: bool = False,
    taper: float | None = None,
    inverse: bool = False,
) -> V3dDftParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input dataset (complex- or float-valued).
        prefix: Prefix for the output file.
        abs_output: Output float dataset = abs(DFT).
        nfft: DFT length (must be >= number of time points).
        detrend: Least-squares remove linear drift before DFT.
        taper: Fraction (0 <= f <= 1) of data to taper at ends (Hamming taper).
        inverse: Perform the inverse DFT.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDFT",
        "infile": infile,
        "prefix": prefix,
        "abs_output": abs_output,
        "detrend": detrend,
        "inverse": inverse,
    }
    if nfft is not None:
        params["nfft"] = nfft
    if taper is not None:
        params["taper"] = taper
    return params


def v_3d_dft_cargs(
    params: V3dDftParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDFT")
    cargs.append(execution.input_file(params.get("infile", None)))
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("abs_output", False):
        cargs.append("-abs")
    if params.get("nfft", None) is not None:
        cargs.extend([
            "-nfft",
            str(params.get("nfft", None))
        ])
    if params.get("detrend", False):
        cargs.append("-detrend")
    if params.get("taper", None) is not None:
        cargs.extend([
            "-taper",
            str(params.get("taper", None))
        ])
    if params.get("inverse", False):
        cargs.append("-inverse")
    return cargs


def v_3d_dft_outputs(
    params: V3dDftParameters,
    execution: Execution,
) -> V3dDftOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDftOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("prefix", None) + "+orig.BRIK"),
        outheader=execution.output_file(params.get("prefix", None) + "+orig.HEAD"),
    )
    return ret


def v_3d_dft_execute(
    params: V3dDftParameters,
    runner: Runner | None = None,
) -> V3dDftOutputs:
    """
    3dDFT
    
    Performs Discrete Fourier Transform (DFT) along the time axis of a complex-
    or float-valued dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDftOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DFT_METADATA)
    params = execution.params(params)
    cargs = v_3d_dft_cargs(params, execution)
    ret = v_3d_dft_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_dft(
    infile: InputPathType,
    prefix: str,
    abs_output: bool = False,
    nfft: float | None = None,
    detrend: bool = False,
    taper: float | None = None,
    inverse: bool = False,
    runner: Runner | None = None,
) -> V3dDftOutputs:
    """
    3dDFT
    
    Performs Discrete Fourier Transform (DFT) along the time axis of a complex-
    or float-valued dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input dataset (complex- or float-valued).
        prefix: Prefix for the output file.
        abs_output: Output float dataset = abs(DFT).
        nfft: DFT length (must be >= number of time points).
        detrend: Least-squares remove linear drift before DFT.
        taper: Fraction (0 <= f <= 1) of data to taper at ends (Hamming taper).
        inverse: Perform the inverse DFT.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDftOutputs`).
    """
    params = v_3d_dft_params(
        infile=infile,
        prefix=prefix,
        abs_output=abs_output,
        nfft=nfft,
        detrend=detrend,
        taper=taper,
        inverse=inverse,
    )
    return v_3d_dft_execute(params, runner)


__all__ = [
    "V3dDftOutputs",
    "V_3D_DFT_METADATA",
    "v_3d_dft",
    "v_3d_dft_execute",
    "v_3d_dft_params",
]
