# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DIFF_METADATA = Metadata(
    id="8694f200d58e60edf8f8355fa427160988463ac9.boutiques",
    name="3dDiff",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDiffParameters = typing.TypedDict('V3dDiffParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDiff"]],
    "dataset_a": InputPathType,
    "dataset_b": InputPathType,
    "tolerance": typing.NotRequired[float | None],
    "mask": typing.NotRequired[InputPathType | None],
    "quiet_mode": bool,
    "tabular_mode": bool,
    "brutalist_mode": bool,
    "long_report_mode": bool,
})
V3dDiffParametersTagged = typing.TypedDict('V3dDiffParametersTagged', {
    "@type": typing.Literal["afni/3dDiff"],
    "dataset_a": InputPathType,
    "dataset_b": InputPathType,
    "tolerance": typing.NotRequired[float | None],
    "mask": typing.NotRequired[InputPathType | None],
    "quiet_mode": bool,
    "tabular_mode": bool,
    "brutalist_mode": bool,
    "long_report_mode": bool,
})


class V3dDiffOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDiffParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_log: OutputPathType
    """Log file containing the element-wise differences."""


def v_3d_diff_params(
    dataset_a: InputPathType,
    dataset_b: InputPathType,
    tolerance: float | None = None,
    mask: InputPathType | None = None,
    quiet_mode: bool = False,
    tabular_mode: bool = False,
    brutalist_mode: bool = False,
    long_report_mode: bool = False,
) -> V3dDiffParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset_a: First input dataset for comparison.
        dataset_b: Second input dataset for comparison.
        tolerance: Floating-point tolerance/epsilon for the comparison.
        mask: Mask to use when comparing the datasets.
        quiet_mode: Quiet mode: 0 for no differences, 1 for differences, -1 for\
            error.
        tabular_mode: Display a table of differences, mainly for 4D data.
        brutalist_mode: Display one-liner with summary of differences.
        long_report_mode: Print a detailed report with more information.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDiff",
        "dataset_a": dataset_a,
        "dataset_b": dataset_b,
        "quiet_mode": quiet_mode,
        "tabular_mode": tabular_mode,
        "brutalist_mode": brutalist_mode,
        "long_report_mode": long_report_mode,
    }
    if tolerance is not None:
        params["tolerance"] = tolerance
    if mask is not None:
        params["mask"] = mask
    return params


def v_3d_diff_cargs(
    params: V3dDiffParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDiff")
    cargs.extend([
        "-a",
        execution.input_file(params.get("dataset_a", None))
    ])
    cargs.extend([
        "-b",
        execution.input_file(params.get("dataset_b", None))
    ])
    if params.get("tolerance", None) is not None:
        cargs.extend([
            "-tol",
            str(params.get("tolerance", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("quiet_mode", False):
        cargs.append("-q")
    if params.get("tabular_mode", False):
        cargs.append("-tabular")
    if params.get("brutalist_mode", False):
        cargs.append("-brutalist")
    if params.get("long_report_mode", False):
        cargs.append("-long_report")
    return cargs


def v_3d_diff_outputs(
    params: V3dDiffParameters,
    execution: Execution,
) -> V3dDiffOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDiffOutputs(
        root=execution.output_file("."),
        output_log=execution.output_file(pathlib.Path(params.get("dataset_a", None)).name + "_vs_" + pathlib.Path(params.get("dataset_b", None)).name + ".log"),
    )
    return ret


def v_3d_diff_execute(
    params: V3dDiffParameters,
    runner: Runner | None = None,
) -> V3dDiffOutputs:
    """
    3dDiff
    
    A program to examine element-wise differences between two images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDiffOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DIFF_METADATA)
    params = execution.params(params)
    cargs = v_3d_diff_cargs(params, execution)
    ret = v_3d_diff_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_diff(
    dataset_a: InputPathType,
    dataset_b: InputPathType,
    tolerance: float | None = None,
    mask: InputPathType | None = None,
    quiet_mode: bool = False,
    tabular_mode: bool = False,
    brutalist_mode: bool = False,
    long_report_mode: bool = False,
    runner: Runner | None = None,
) -> V3dDiffOutputs:
    """
    3dDiff
    
    A program to examine element-wise differences between two images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset_a: First input dataset for comparison.
        dataset_b: Second input dataset for comparison.
        tolerance: Floating-point tolerance/epsilon for the comparison.
        mask: Mask to use when comparing the datasets.
        quiet_mode: Quiet mode: 0 for no differences, 1 for differences, -1 for\
            error.
        tabular_mode: Display a table of differences, mainly for 4D data.
        brutalist_mode: Display one-liner with summary of differences.
        long_report_mode: Print a detailed report with more information.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDiffOutputs`).
    """
    params = v_3d_diff_params(
        dataset_a=dataset_a,
        dataset_b=dataset_b,
        tolerance=tolerance,
        mask=mask,
        quiet_mode=quiet_mode,
        tabular_mode=tabular_mode,
        brutalist_mode=brutalist_mode,
        long_report_mode=long_report_mode,
    )
    return v_3d_diff_execute(params, runner)


__all__ = [
    "V3dDiffOutputs",
    "V_3D_DIFF_METADATA",
    "v_3d_diff",
    "v_3d_diff_execute",
    "v_3d_diff_params",
]
