# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DTTO_DWI_METADATA = Metadata(
    id="b9cff0e8b3a61102a8410407fc0ea2e75ea382d6.boutiques",
    name="3dDTtoDWI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDttoDwiParameters = typing.TypedDict('V3dDttoDwiParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDTtoDWI"]],
    "gradient_file": InputPathType,
    "i0_dataset": InputPathType,
    "dt_dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "automask": bool,
    "datum_type": typing.NotRequired[str | None],
    "scale_out_1000": bool,
    "help": bool,
})
V3dDttoDwiParametersTagged = typing.TypedDict('V3dDttoDwiParametersTagged', {
    "@type": typing.Literal["afni/3dDTtoDWI"],
    "gradient_file": InputPathType,
    "i0_dataset": InputPathType,
    "dt_dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "automask": bool,
    "datum_type": typing.NotRequired[str | None],
    "scale_out_1000": bool,
    "help": bool,
})


class V3dDttoDwiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDttoDwiParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dwi: OutputPathType | None
    """Computed DWI images including sub-brick for each gradient vector."""


def v_3d_dtto_dwi_params(
    gradient_file: InputPathType,
    i0_dataset: InputPathType,
    dt_dataset: InputPathType,
    prefix: str | None = None,
    automask: bool = False,
    datum_type: str | None = None,
    scale_out_1000: bool = False,
    help_: bool = False,
) -> V3dDttoDwiParametersTagged:
    """
    Build parameters.
    
    Args:
        gradient_file: 1D file containing the gradient vectors (ASCII floats)\
            for non-zero gradients.
        i0_dataset: Volume without any gradient applied.
        dt_dataset: 6-sub-brick dataset containing the diffusion tensor data\
            (Dxx, Dxy, Dyy, Dxz, Dyz, Dzz).
        prefix: Prefix for the output dataset name.
        automask: Compute gradient images only for high-intensity (brain)\
            voxels.
        datum_type: Type of the output dataset (float, short, or byte).
        scale_out_1000: Match with 3dDWItoDT's '-scale_out_1000' functionality.
        help_: Show help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDTtoDWI",
        "gradient_file": gradient_file,
        "i0_dataset": i0_dataset,
        "dt_dataset": dt_dataset,
        "automask": automask,
        "scale_out_1000": scale_out_1000,
        "help": help_,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if datum_type is not None:
        params["datum_type"] = datum_type
    return params


def v_3d_dtto_dwi_cargs(
    params: V3dDttoDwiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDTtoDWI")
    cargs.append(execution.input_file(params.get("gradient_file", None)))
    cargs.append(execution.input_file(params.get("i0_dataset", None)))
    cargs.append(execution.input_file(params.get("dt_dataset", None)))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("datum_type", None) is not None:
        cargs.extend([
            "-datum",
            params.get("datum_type", None)
        ])
    if params.get("scale_out_1000", False):
        cargs.append("-scale_out_1000")
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def v_3d_dtto_dwi_outputs(
    params: V3dDttoDwiParameters,
    execution: Execution,
) -> V3dDttoDwiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDttoDwiOutputs(
        root=execution.output_file("."),
        output_dwi=execution.output_file(params.get("prefix", None) + ".HEAD") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_dtto_dwi_execute(
    params: V3dDttoDwiParameters,
    runner: Runner | None = None,
) -> V3dDttoDwiOutputs:
    """
    3dDTtoDWI
    
    Tool to compute multiple gradient images from tensors and gradient vector
    coordinates applied to the I0-dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDttoDwiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DTTO_DWI_METADATA)
    params = execution.params(params)
    cargs = v_3d_dtto_dwi_cargs(params, execution)
    ret = v_3d_dtto_dwi_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_dtto_dwi(
    gradient_file: InputPathType,
    i0_dataset: InputPathType,
    dt_dataset: InputPathType,
    prefix: str | None = None,
    automask: bool = False,
    datum_type: str | None = None,
    scale_out_1000: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dDttoDwiOutputs:
    """
    3dDTtoDWI
    
    Tool to compute multiple gradient images from tensors and gradient vector
    coordinates applied to the I0-dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        gradient_file: 1D file containing the gradient vectors (ASCII floats)\
            for non-zero gradients.
        i0_dataset: Volume without any gradient applied.
        dt_dataset: 6-sub-brick dataset containing the diffusion tensor data\
            (Dxx, Dxy, Dyy, Dxz, Dyz, Dzz).
        prefix: Prefix for the output dataset name.
        automask: Compute gradient images only for high-intensity (brain)\
            voxels.
        datum_type: Type of the output dataset (float, short, or byte).
        scale_out_1000: Match with 3dDWItoDT's '-scale_out_1000' functionality.
        help_: Show help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDttoDwiOutputs`).
    """
    params = v_3d_dtto_dwi_params(
        gradient_file=gradient_file,
        i0_dataset=i0_dataset,
        dt_dataset=dt_dataset,
        prefix=prefix,
        automask=automask,
        datum_type=datum_type,
        scale_out_1000=scale_out_1000,
        help_=help_,
    )
    return v_3d_dtto_dwi_execute(params, runner)


__all__ = [
    "V3dDttoDwiOutputs",
    "V_3D_DTTO_DWI_METADATA",
    "v_3d_dtto_dwi",
    "v_3d_dtto_dwi_execute",
    "v_3d_dtto_dwi_params",
]
