# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DWUNCERT_METADATA = Metadata(
    id="cbde019605b90635102379e325a6defdacd645f6.boutiques",
    name="3dDWUncert",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDwuncertParameters = typing.TypedDict('V3dDwuncertParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dDWUncert"]],
    "input_file": InputPathType,
    "input_prefix": str,
    "output_prefix": str,
    "grad_file": typing.NotRequired[InputPathType | None],
    "bmatrix_file": typing.NotRequired[InputPathType | None],
    "num_iters": typing.NotRequired[float | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "calc_thr_fa": typing.NotRequired[float | None],
    "csf_fa": typing.NotRequired[float | None],
})
V3dDwuncertParametersTagged = typing.TypedDict('V3dDwuncertParametersTagged', {
    "@type": typing.Literal["afni/3dDWUncert"],
    "input_file": InputPathType,
    "input_prefix": str,
    "output_prefix": str,
    "grad_file": typing.NotRequired[InputPathType | None],
    "bmatrix_file": typing.NotRequired[InputPathType | None],
    "num_iters": typing.NotRequired[float | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "calc_thr_fa": typing.NotRequired[float | None],
    "csf_fa": typing.NotRequired[float | None],
})


class V3dDwuncertOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dDwuncertParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """AFNI-format file with 6 subbricks, containing uncertainty information."""


def v_3d_dwuncert_params(
    input_file: InputPathType,
    input_prefix: str,
    output_prefix: str,
    grad_file: InputPathType | None = None,
    bmatrix_file: InputPathType | None = None,
    num_iters: float | None = None,
    mask_file: InputPathType | None = None,
    calc_thr_fa: float | None = None,
    csf_fa: float | None = None,
) -> V3dDwuncertParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input file with b0 and DWI subbricks.
        input_prefix: Basename of DTI volumes.
        output_prefix: Output file name prefix.
        grad_file: File with 3 columns for x-, y-, and z-comps of DW-gradients.
        bmatrix_file: File with gradient info in b-matrix format.
        num_iters: Number of jackknife resample iterations.
        mask_file: Mask file within which to calculate uncertainty.
        calc_thr_fa: Threshold for the minimum FA value above which to\
            calculate uncertainty.
        csf_fa: Number marking FA value of 'bad' voxels.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dDWUncert",
        "input_file": input_file,
        "input_prefix": input_prefix,
        "output_prefix": output_prefix,
    }
    if grad_file is not None:
        params["grad_file"] = grad_file
    if bmatrix_file is not None:
        params["bmatrix_file"] = bmatrix_file
    if num_iters is not None:
        params["num_iters"] = num_iters
    if mask_file is not None:
        params["mask_file"] = mask_file
    if calc_thr_fa is not None:
        params["calc_thr_fa"] = calc_thr_fa
    if csf_fa is not None:
        params["csf_fa"] = csf_fa
    return params


def v_3d_dwuncert_cargs(
    params: V3dDwuncertParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDWUncert")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-input",
        params.get("input_prefix", None)
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix", None)
    ])
    if params.get("grad_file", None) is not None:
        cargs.extend([
            "-grads",
            execution.input_file(params.get("grad_file", None))
        ])
    if params.get("bmatrix_file", None) is not None:
        cargs.extend([
            "-bmatrix_FULL",
            execution.input_file(params.get("bmatrix_file", None))
        ])
    if params.get("num_iters", None) is not None:
        cargs.extend([
            "-iters",
            str(params.get("num_iters", None))
        ])
    if params.get("mask_file", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_file", None))
        ])
    if params.get("calc_thr_fa", None) is not None:
        cargs.extend([
            "-calc_thr_FA",
            str(params.get("calc_thr_fa", None))
        ])
    if params.get("csf_fa", None) is not None:
        cargs.extend([
            "-csf_fa",
            str(params.get("csf_fa", None))
        ])
    return cargs


def v_3d_dwuncert_outputs(
    params: V3dDwuncertParameters,
    execution: Execution,
) -> V3dDwuncertOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDwuncertOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix", None) + "+.HEAD/" + params.get("output_prefix", None) + "+.BRIK"),
    )
    return ret


def v_3d_dwuncert_execute(
    params: V3dDwuncertParameters,
    runner: Runner | None = None,
) -> V3dDwuncertOutputs:
    """
    3dDWUncert
    
    Use jackknifing to estimate uncertainty of DTI parameters, important for
    probabilistic tractography.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDwuncertOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DWUNCERT_METADATA)
    params = execution.params(params)
    cargs = v_3d_dwuncert_cargs(params, execution)
    ret = v_3d_dwuncert_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_dwuncert(
    input_file: InputPathType,
    input_prefix: str,
    output_prefix: str,
    grad_file: InputPathType | None = None,
    bmatrix_file: InputPathType | None = None,
    num_iters: float | None = None,
    mask_file: InputPathType | None = None,
    calc_thr_fa: float | None = None,
    csf_fa: float | None = None,
    runner: Runner | None = None,
) -> V3dDwuncertOutputs:
    """
    3dDWUncert
    
    Use jackknifing to estimate uncertainty of DTI parameters, important for
    probabilistic tractography.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input file with b0 and DWI subbricks.
        input_prefix: Basename of DTI volumes.
        output_prefix: Output file name prefix.
        grad_file: File with 3 columns for x-, y-, and z-comps of DW-gradients.
        bmatrix_file: File with gradient info in b-matrix format.
        num_iters: Number of jackknife resample iterations.
        mask_file: Mask file within which to calculate uncertainty.
        calc_thr_fa: Threshold for the minimum FA value above which to\
            calculate uncertainty.
        csf_fa: Number marking FA value of 'bad' voxels.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDwuncertOutputs`).
    """
    params = v_3d_dwuncert_params(
        input_file=input_file,
        input_prefix=input_prefix,
        output_prefix=output_prefix,
        grad_file=grad_file,
        bmatrix_file=bmatrix_file,
        num_iters=num_iters,
        mask_file=mask_file,
        calc_thr_fa=calc_thr_fa,
        csf_fa=csf_fa,
    )
    return v_3d_dwuncert_execute(params, runner)


__all__ = [
    "V3dDwuncertOutputs",
    "V_3D_DWUNCERT_METADATA",
    "v_3d_dwuncert",
    "v_3d_dwuncert_execute",
    "v_3d_dwuncert_params",
]
