# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ECM_METADATA = Metadata(
    id="dc84c4ba00debbcb6bece9fbb3dc81531d184e64.boutiques",
    name="3dECM",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dEcmParameters = typing.TypedDict('V3dEcmParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dECM"]],
    "in_file": InputPathType,
    "autoclip": bool,
    "automask": bool,
    "eps": typing.NotRequired[float | None],
    "fecm": bool,
    "full": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_iter": typing.NotRequired[int | None],
    "memory": typing.NotRequired[float | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "out_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "scale": typing.NotRequired[float | None],
    "shift": typing.NotRequired[float | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})
V3dEcmParametersTagged = typing.TypedDict('V3dEcmParametersTagged', {
    "@type": typing.Literal["afni/3dECM"],
    "in_file": InputPathType,
    "autoclip": bool,
    "automask": bool,
    "eps": typing.NotRequired[float | None],
    "fecm": bool,
    "full": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_iter": typing.NotRequired[int | None],
    "memory": typing.NotRequired[float | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "out_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "scale": typing.NotRequired[float | None],
    "shift": typing.NotRequired[float | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})


class V3dEcmOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dEcmParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    out_file_: OutputPathType
    """Output file."""


def v_3d_ecm_params(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    eps: float | None = None,
    fecm: bool = False,
    full: bool = False,
    mask: InputPathType | None = None,
    max_iter: int | None = None,
    memory: float | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    out_file: str | None = None,
    polort: int | None = None,
    scale: float | None = None,
    shift: float | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
) -> V3dEcmParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3decm.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        eps: Sets the stopping criterion for the power iteration;\
            :math:`l2\\|v_\\text{old} - v_\\text{new}\\| < eps\\|v_\\text{old}\\|`;\
            default = 0.001.
        fecm: Fast centrality method; substantial speed increase but cannot\
            accommodate thresholding; automatically selected if -thresh or\
            -sparsity are not set.
        full: Full power method; enables thresholding; automatically selected\
            if -thresh or -sparsity are set.
        mask: Mask file to mask input data.
        max_iter: Sets the maximum number of iterations to use in the power\
            iteration; default = 1000.
        memory: Limit memory consumption on system by setting the amount of gb\
            to limit the algorithm to; default = 2gb.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        out_file: Output image file name.
        polort: No description provided.
        scale: Scale correlation coefficients in similarity matrix to after\
            shifting, x >= 0.0; default = 1.0 for -full, 0.5 for -fecm.
        shift: Shift correlation coefficients in similarity matrix to enforce\
            non-negativity, s >= 0.0; default = 0.0 for -full, 1.0 for -fecm.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dECM",
        "in_file": in_file,
        "autoclip": autoclip,
        "automask": automask,
        "fecm": fecm,
        "full": full,
    }
    if eps is not None:
        params["eps"] = eps
    if mask is not None:
        params["mask"] = mask
    if max_iter is not None:
        params["max_iter"] = max_iter
    if memory is not None:
        params["memory"] = memory
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    if out_file is not None:
        params["out_file"] = out_file
    if polort is not None:
        params["polort"] = polort
    if scale is not None:
        params["scale"] = scale
    if shift is not None:
        params["shift"] = shift
    if sparsity is not None:
        params["sparsity"] = sparsity
    if thresh is not None:
        params["thresh"] = thresh
    return params


def v_3d_ecm_cargs(
    params: V3dEcmParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dECM")
    cargs.append(execution.input_file(params.get("in_file", None)))
    if params.get("autoclip", False):
        cargs.append("-autoclip")
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("eps", None) is not None:
        cargs.extend([
            "-eps",
            str(params.get("eps", None))
        ])
    if params.get("fecm", False):
        cargs.append("-fecm")
    if params.get("full", False):
        cargs.append("-full")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("max_iter", None) is not None:
        cargs.extend([
            "-max_iter",
            str(params.get("max_iter", None))
        ])
    if params.get("memory", None) is not None:
        cargs.extend([
            "-memory",
            str(params.get("memory", None))
        ])
    if params.get("num_threads", None) is not None:
        cargs.append(str(params.get("num_threads", None)))
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    if params.get("out_file", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("out_file", None)
        ])
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    if params.get("scale", None) is not None:
        cargs.extend([
            "-scale",
            str(params.get("scale", None))
        ])
    if params.get("shift", None) is not None:
        cargs.extend([
            "-shift",
            str(params.get("shift", None))
        ])
    if params.get("sparsity", None) is not None:
        cargs.extend([
            "-sparsity",
            str(params.get("sparsity", None))
        ])
    if params.get("thresh", None) is not None:
        cargs.extend([
            "-thresh",
            str(params.get("thresh", None))
        ])
    return cargs


def v_3d_ecm_outputs(
    params: V3dEcmParameters,
    execution: Execution,
) -> V3dEcmOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dEcmOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file", None)).name + "_afni"),
        out_file_=execution.output_file("out_file"),
    )
    return ret


def v_3d_ecm_execute(
    params: V3dEcmParameters,
    runner: Runner | None = None,
) -> V3dEcmOutputs:
    """
    3dECM
    
    Performs degree centrality on a dataset using a given maskfile via the 3dECM
    command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEcmOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ECM_METADATA)
    params = execution.params(params)
    cargs = v_3d_ecm_cargs(params, execution)
    ret = v_3d_ecm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_ecm(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    eps: float | None = None,
    fecm: bool = False,
    full: bool = False,
    mask: InputPathType | None = None,
    max_iter: int | None = None,
    memory: float | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    out_file: str | None = None,
    polort: int | None = None,
    scale: float | None = None,
    shift: float | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
    runner: Runner | None = None,
) -> V3dEcmOutputs:
    """
    3dECM
    
    Performs degree centrality on a dataset using a given maskfile via the 3dECM
    command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3decm.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        eps: Sets the stopping criterion for the power iteration;\
            :math:`l2\\|v_\\text{old} - v_\\text{new}\\| < eps\\|v_\\text{old}\\|`;\
            default = 0.001.
        fecm: Fast centrality method; substantial speed increase but cannot\
            accommodate thresholding; automatically selected if -thresh or\
            -sparsity are not set.
        full: Full power method; enables thresholding; automatically selected\
            if -thresh or -sparsity are set.
        mask: Mask file to mask input data.
        max_iter: Sets the maximum number of iterations to use in the power\
            iteration; default = 1000.
        memory: Limit memory consumption on system by setting the amount of gb\
            to limit the algorithm to; default = 2gb.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        out_file: Output image file name.
        polort: No description provided.
        scale: Scale correlation coefficients in similarity matrix to after\
            shifting, x >= 0.0; default = 1.0 for -full, 0.5 for -fecm.
        shift: Shift correlation coefficients in similarity matrix to enforce\
            non-negativity, s >= 0.0; default = 0.0 for -full, 1.0 for -fecm.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEcmOutputs`).
    """
    params = v_3d_ecm_params(
        in_file=in_file,
        autoclip=autoclip,
        automask=automask,
        eps=eps,
        fecm=fecm,
        full=full,
        mask=mask,
        max_iter=max_iter,
        memory=memory,
        num_threads=num_threads,
        outputtype=outputtype,
        out_file=out_file,
        polort=polort,
        scale=scale,
        shift=shift,
        sparsity=sparsity,
        thresh=thresh,
    )
    return v_3d_ecm_execute(params, runner)


__all__ = [
    "V3dEcmOutputs",
    "V_3D_ECM_METADATA",
    "v_3d_ecm",
    "v_3d_ecm_execute",
    "v_3d_ecm_params",
]
