# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_EDU_01_SCALE_METADATA = Metadata(
    id="bf9e7a5bd7bc4419390243111049a4474109df28.boutiques",
    name="3dEdu_01_scale",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dEdu01ScaleParameters = typing.TypedDict('V3dEdu01ScaleParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dEdu_01_scale"]],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "mult_factors": typing.NotRequired[list[float] | None],
    "option_flag": bool,
})
V3dEdu01ScaleParametersTagged = typing.TypedDict('V3dEdu01ScaleParametersTagged', {
    "@type": typing.Literal["afni/3dEdu_01_scale"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "mult_factors": typing.NotRequired[list[float] | None],
    "option_flag": bool,
})


class V3dEdu01ScaleOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dEdu01ScaleParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_edu_01_scale_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    mult_factors: list[float] | None = None,
    option_flag: bool = False,
) -> V3dEdu01ScaleParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Input dataset.
        mask: Mask dataset on same grid/data structure as the input dataset.
        mult_factors: Numerical factors for multiplying each voxel; each voxel\
            is multiplied by both A and B.
        option_flag: Option flag to do something.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dEdu_01_scale",
        "input": input_,
        "option_flag": option_flag,
    }
    if mask is not None:
        params["mask"] = mask
    if mult_factors is not None:
        params["mult_factors"] = mult_factors
    return params


def v_3d_edu_01_scale_cargs(
    params: V3dEdu01ScaleParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dEdu_01_scale")
    cargs.append(execution.input_file(params.get("input", None)))
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("mult_factors", None) is not None:
        cargs.extend([
            "-mult_facs",
            *map(str, params.get("mult_factors", None))
        ])
    if params.get("option_flag", False):
        cargs.append("-some_opt")
    return cargs


def v_3d_edu_01_scale_outputs(
    params: V3dEdu01ScaleParameters,
    execution: Execution,
) -> V3dEdu01ScaleOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dEdu01ScaleOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_edu_01_scale_execute(
    params: V3dEdu01ScaleParameters,
    runner: Runner | None = None,
) -> V3dEdu01ScaleOutputs:
    """
    3dEdu_01_scale
    
    Educational program to create a new AFNI program. Scales and masks dataset
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEdu01ScaleOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_EDU_01_SCALE_METADATA)
    params = execution.params(params)
    cargs = v_3d_edu_01_scale_cargs(params, execution)
    ret = v_3d_edu_01_scale_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_edu_01_scale(
    input_: InputPathType,
    mask: InputPathType | None = None,
    mult_factors: list[float] | None = None,
    option_flag: bool = False,
    runner: Runner | None = None,
) -> V3dEdu01ScaleOutputs:
    """
    3dEdu_01_scale
    
    Educational program to create a new AFNI program. Scales and masks dataset
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Input dataset.
        mask: Mask dataset on same grid/data structure as the input dataset.
        mult_factors: Numerical factors for multiplying each voxel; each voxel\
            is multiplied by both A and B.
        option_flag: Option flag to do something.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEdu01ScaleOutputs`).
    """
    params = v_3d_edu_01_scale_params(
        input_=input_,
        mask=mask,
        mult_factors=mult_factors,
        option_flag=option_flag,
    )
    return v_3d_edu_01_scale_execute(params, runner)


__all__ = [
    "V3dEdu01ScaleOutputs",
    "V_3D_EDU_01_SCALE_METADATA",
    "v_3d_edu_01_scale",
    "v_3d_edu_01_scale_execute",
    "v_3d_edu_01_scale_params",
]
