# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ERRTS_CORMAT_METADATA = Metadata(
    id="d14e91ea697278239ebae181e3192bf27d7d44bf.boutiques",
    name="3dErrtsCormat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dErrtsCormatParameters = typing.TypedDict('V3dErrtsCormatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dErrtsCormat"]],
    "dset": InputPathType,
    "concat": typing.NotRequired[str | None],
    "input": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "maxlag": typing.NotRequired[float | None],
    "polort": typing.NotRequired[float | None],
})
V3dErrtsCormatParametersTagged = typing.TypedDict('V3dErrtsCormatParametersTagged', {
    "@type": typing.Literal["afni/3dErrtsCormat"],
    "dset": InputPathType,
    "concat": typing.NotRequired[str | None],
    "input": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "maxlag": typing.NotRequired[float | None],
    "polort": typing.NotRequired[float | None],
})


class V3dErrtsCormatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dErrtsCormatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output: OutputPathType
    """1D file of the Toeplitz entries."""


def v_3d_errts_cormat_params(
    dset: InputPathType,
    concat: str | None = None,
    input_: InputPathType | None = None,
    mask: InputPathType | None = None,
    maxlag: float | None = None,
    polort: float | None = None,
) -> V3dErrtsCormatParametersTagged:
    """
    Build parameters.
    
    Args:
        dset: Dataset to read, usually the '-errts' output from 3dDeconvolve.
        concat: As used in 3dDeconvolve.
        input_: Alternate way of specifying the dataset to read.
        mask: Mask dataset to apply.
        maxlag: Set maximum lag.
        polort: Set polort level. Default is 0.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dErrtsCormat",
        "dset": dset,
    }
    if concat is not None:
        params["concat"] = concat
    if input_ is not None:
        params["input"] = input_
    if mask is not None:
        params["mask"] = mask
    if maxlag is not None:
        params["maxlag"] = maxlag
    if polort is not None:
        params["polort"] = polort
    return params


def v_3d_errts_cormat_cargs(
    params: V3dErrtsCormatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dErrtsCormat")
    cargs.append(execution.input_file(params.get("dset", None)))
    if params.get("concat", None) is not None:
        cargs.extend([
            "-concat",
            params.get("concat", None)
        ])
    if params.get("input", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("maxlag", None) is not None:
        cargs.extend([
            "-maxlag",
            str(params.get("maxlag", None))
        ])
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    return cargs


def v_3d_errts_cormat_outputs(
    params: V3dErrtsCormatParameters,
    execution: Execution,
) -> V3dErrtsCormatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dErrtsCormatOutputs(
        root=execution.output_file("."),
        output=execution.output_file("stdout"),
    )
    return ret


def v_3d_errts_cormat_execute(
    params: V3dErrtsCormatParameters,
    runner: Runner | None = None,
) -> V3dErrtsCormatOutputs:
    """
    3dErrtsCormat
    
    Computes the correlation matrix corresponding to the residual (or error)
    time series in 'dset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dErrtsCormatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ERRTS_CORMAT_METADATA)
    params = execution.params(params)
    cargs = v_3d_errts_cormat_cargs(params, execution)
    ret = v_3d_errts_cormat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_errts_cormat(
    dset: InputPathType,
    concat: str | None = None,
    input_: InputPathType | None = None,
    mask: InputPathType | None = None,
    maxlag: float | None = None,
    polort: float | None = None,
    runner: Runner | None = None,
) -> V3dErrtsCormatOutputs:
    """
    3dErrtsCormat
    
    Computes the correlation matrix corresponding to the residual (or error)
    time series in 'dset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: Dataset to read, usually the '-errts' output from 3dDeconvolve.
        concat: As used in 3dDeconvolve.
        input_: Alternate way of specifying the dataset to read.
        mask: Mask dataset to apply.
        maxlag: Set maximum lag.
        polort: Set polort level. Default is 0.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dErrtsCormatOutputs`).
    """
    params = v_3d_errts_cormat_params(
        dset=dset,
        concat=concat,
        input_=input_,
        mask=mask,
        maxlag=maxlag,
        polort=polort,
    )
    return v_3d_errts_cormat_execute(params, runner)


__all__ = [
    "V3dErrtsCormatOutputs",
    "V_3D_ERRTS_CORMAT_METADATA",
    "v_3d_errts_cormat",
    "v_3d_errts_cormat_execute",
    "v_3d_errts_cormat_params",
]
