# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_EXCHANGE_METADATA = Metadata(
    id="718b78c0aa7d2f4eb3cb6a05bf3fe4b27fbec0cd.boutiques",
    name="3dExchange",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dExchangeParameters = typing.TypedDict('V3dExchangeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dExchange"]],
    "prefix": str,
    "infile": InputPathType,
    "mapfile": InputPathType,
    "version": bool,
    "help": bool,
})
V3dExchangeParametersTagged = typing.TypedDict('V3dExchangeParametersTagged', {
    "@type": typing.Literal["afni/3dExchange"],
    "prefix": str,
    "infile": InputPathType,
    "mapfile": InputPathType,
    "version": bool,
    "help": bool,
})


class V3dExchangeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dExchangeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_head: OutputPathType
    """Output HEAD file"""
    output_brik: OutputPathType
    """Output BRIK file"""


def v_3d_exchange_params(
    prefix: str,
    infile: InputPathType,
    mapfile: InputPathType,
    version: bool = False,
    help_: bool = False,
) -> V3dExchangeParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix.
        infile: Input dataset. Acceptable data types are byte, short, and\
            floats.
        mapfile: Mapping columns. Input values in the first column, output\
            values in the second column.
        version: Print author and version info.
        help_: Print this help screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dExchange",
        "prefix": prefix,
        "infile": infile,
        "mapfile": mapfile,
        "version": version,
        "help": help_,
    }
    return params


def v_3d_exchange_cargs(
    params: V3dExchangeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dExchange")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("infile", None))
    ])
    cargs.extend([
        "-map",
        execution.input_file(params.get("mapfile", None))
    ])
    if params.get("version", False):
        cargs.append("-ver")
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def v_3d_exchange_outputs(
    params: V3dExchangeParameters,
    execution: Execution,
) -> V3dExchangeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dExchangeOutputs(
        root=execution.output_file("."),
        output_head=execution.output_file(params.get("prefix", None) + "+orig.HEAD"),
        output_brik=execution.output_file(params.get("prefix", None) + "+orig.BRIK"),
    )
    return ret


def v_3d_exchange_execute(
    params: V3dExchangeParameters,
    runner: Runner | None = None,
) -> V3dExchangeOutputs:
    """
    3dExchange
    
    Replaces voxel values using a mapping file with specified columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dExchangeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_EXCHANGE_METADATA)
    params = execution.params(params)
    cargs = v_3d_exchange_cargs(params, execution)
    ret = v_3d_exchange_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_exchange(
    prefix: str,
    infile: InputPathType,
    mapfile: InputPathType,
    version: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dExchangeOutputs:
    """
    3dExchange
    
    Replaces voxel values using a mapping file with specified columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix.
        infile: Input dataset. Acceptable data types are byte, short, and\
            floats.
        mapfile: Mapping columns. Input values in the first column, output\
            values in the second column.
        version: Print author and version info.
        help_: Print this help screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dExchangeOutputs`).
    """
    params = v_3d_exchange_params(
        prefix=prefix,
        infile=infile,
        mapfile=mapfile,
        version=version,
        help_=help_,
    )
    return v_3d_exchange_execute(params, runner)


__all__ = [
    "V3dExchangeOutputs",
    "V_3D_EXCHANGE_METADATA",
    "v_3d_exchange",
    "v_3d_exchange_execute",
    "v_3d_exchange_params",
]
