# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_FRIEDMAN_METADATA = Metadata(
    id="a8439d785b86745838dfe4d337513a003ae76358.boutiques",
    name="3dFriedman",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dFriedmanParameters = typing.TypedDict('V3dFriedmanParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dFriedman"]],
    "levels": int,
    "datasets": list[InputPathType],
    "workmem": typing.NotRequired[int | None],
    "voxel_num": typing.NotRequired[int | None],
    "output_prefix": str,
})
V3dFriedmanParametersTagged = typing.TypedDict('V3dFriedmanParametersTagged', {
    "@type": typing.Literal["afni/3dFriedman"],
    "levels": int,
    "datasets": list[InputPathType],
    "workmem": typing.NotRequired[int | None],
    "voxel_num": typing.NotRequired[int | None],
    "output_prefix": str,
})


class V3dFriedmanOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dFriedmanParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_friedman_params(
    levels: int,
    datasets: list[InputPathType],
    output_prefix: str,
    workmem: int | None = None,
    voxel_num: int | None = None,
) -> V3dFriedmanParametersTagged:
    """
    Build parameters.
    
    Args:
        levels: Number of treatments.
        datasets: Data sets for each treatment.
        output_prefix: Prefix for the output files.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel_num: Screen output for a specific voxel number.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dFriedman",
        "levels": levels,
        "datasets": datasets,
        "output_prefix": output_prefix,
    }
    if workmem is not None:
        params["workmem"] = workmem
    if voxel_num is not None:
        params["voxel_num"] = voxel_num
    return params


def v_3d_friedman_cargs(
    params: V3dFriedmanParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dFriedman")
    cargs.append(str(params.get("levels", None)))
    cargs.extend([
        "-dset",
        *[execution.input_file(f) for f in params.get("datasets", None)]
    ])
    if params.get("workmem", None) is not None:
        cargs.extend([
            "-workmem",
            str(params.get("workmem", None))
        ])
    if params.get("voxel_num", None) is not None:
        cargs.extend([
            "-voxel",
            str(params.get("voxel_num", None))
        ])
    cargs.extend([
        "-out",
        params.get("output_prefix", None)
    ])
    return cargs


def v_3d_friedman_outputs(
    params: V3dFriedmanParameters,
    execution: Execution,
) -> V3dFriedmanOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dFriedmanOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_friedman_execute(
    params: V3dFriedmanParameters,
    runner: Runner | None = None,
) -> V3dFriedmanOutputs:
    """
    3dFriedman
    
    Performs nonparametric Friedman test for randomized complete block design
    experiments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFriedmanOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_FRIEDMAN_METADATA)
    params = execution.params(params)
    cargs = v_3d_friedman_cargs(params, execution)
    ret = v_3d_friedman_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_friedman(
    levels: int,
    datasets: list[InputPathType],
    output_prefix: str,
    workmem: int | None = None,
    voxel_num: int | None = None,
    runner: Runner | None = None,
) -> V3dFriedmanOutputs:
    """
    3dFriedman
    
    Performs nonparametric Friedman test for randomized complete block design
    experiments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        levels: Number of treatments.
        datasets: Data sets for each treatment.
        output_prefix: Prefix for the output files.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel_num: Screen output for a specific voxel number.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFriedmanOutputs`).
    """
    params = v_3d_friedman_params(
        levels=levels,
        datasets=datasets,
        workmem=workmem,
        voxel_num=voxel_num,
        output_prefix=output_prefix,
    )
    return v_3d_friedman_execute(params, runner)


__all__ = [
    "V3dFriedmanOutputs",
    "V_3D_FRIEDMAN_METADATA",
    "v_3d_friedman",
    "v_3d_friedman_execute",
    "v_3d_friedman_params",
]
