# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_FWHMX_METADATA = Metadata(
    id="408b0ca2210d336d7abec8bdaf127930c857b898.boutiques",
    name="3dFWHMx",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dFwhmxParameters = typing.TypedDict('V3dFwhmxParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dFWHMx"]],
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "demed": bool,
    "unif": bool,
    "detrend": typing.NotRequired[float | None],
    "detprefix": typing.NotRequired[str | None],
    "geom": bool,
    "arith": bool,
    "combine": bool,
    "out": typing.NotRequired[str | None],
    "compat": bool,
    "acf": typing.NotRequired[str | None],
    "infile": InputPathType,
})
V3dFwhmxParametersTagged = typing.TypedDict('V3dFwhmxParametersTagged', {
    "@type": typing.Literal["afni/3dFWHMx"],
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "demed": bool,
    "unif": bool,
    "detrend": typing.NotRequired[float | None],
    "detprefix": typing.NotRequired[str | None],
    "geom": bool,
    "arith": bool,
    "combine": bool,
    "out": typing.NotRequired[str | None],
    "compat": bool,
    "acf": typing.NotRequired[str | None],
    "infile": InputPathType,
})


class V3dFwhmxOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dFwhmxParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output file containing FWHM/ACF estimates"""
    detrended_dataset: OutputPathType | None
    """Detrended dataset file"""


def v_3d_fwhmx_params(
    infile: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    demed: bool = False,
    unif: bool = False,
    detrend: float | None = None,
    detprefix: str | None = None,
    geom: bool = False,
    arith: bool = False,
    combine: bool = False,
    out: str | None = None,
    compat: bool = False,
    acf: str | None = None,
) -> V3dFwhmxParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input dataset.
        mask: Use only voxels that are nonzero in dataset 'mmm'.
        automask: Compute a mask from THIS dataset.
        demed: if the input dataset has more than one sub-brick then subtract\
            the median of each voxel's time series before processing FWHM.
        unif: Normalize each voxel's time series to have the same MAD before\
            processing FWHM, implies -demed.
        detrend: Detrend to order 'q'. If q is not given, the program picks\
            q=NT/30; -detrend disables -demed, and includes -unif.
        detprefix: Save the detrended file into a dataset with prefix 'd'.
        geom: Compute the final estimate as the geometric mean.
        arith: Compute the final estimate as the arithmetic mean.
        combine: Combine the final measurements along each axis into one result.
        out: Write output to file 'ttt' (3 columns of numbers). If not given,\
            the sub-brick outputs are not written. Use '-out -' to write to stdout,\
            if desired.
        compat: Be compatible with the older 3dFWHM.
        acf: Compute the spatial autocorrelation of the data as a function of\
            radius, then fit that to a model and output the model parameters.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dFWHMx",
        "automask": automask,
        "demed": demed,
        "unif": unif,
        "geom": geom,
        "arith": arith,
        "combine": combine,
        "compat": compat,
        "infile": infile,
    }
    if mask is not None:
        params["mask"] = mask
    if detrend is not None:
        params["detrend"] = detrend
    if detprefix is not None:
        params["detprefix"] = detprefix
    if out is not None:
        params["out"] = out
    if acf is not None:
        params["acf"] = acf
    return params


def v_3d_fwhmx_cargs(
    params: V3dFwhmxParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dFWHMx")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("demed", False):
        cargs.append("-demed")
    if params.get("unif", False):
        cargs.append("-unif")
    if params.get("detrend", None) is not None:
        cargs.extend([
            "-detrend",
            str(params.get("detrend", None))
        ])
    if params.get("detprefix", None) is not None:
        cargs.extend([
            "-detprefix",
            params.get("detprefix", None)
        ])
    if params.get("geom", False):
        cargs.append("-geom")
    if params.get("arith", False):
        cargs.append("-arith")
    if params.get("combine", False):
        cargs.append("-combine")
    if params.get("out", None) is not None:
        cargs.extend([
            "-out",
            params.get("out", None)
        ])
    if params.get("compat", False):
        cargs.append("-compat")
    if params.get("acf", None) is not None:
        cargs.extend([
            "-acf",
            params.get("acf", None)
        ])
    cargs.append(execution.input_file(params.get("infile", None)))
    return cargs


def v_3d_fwhmx_outputs(
    params: V3dFwhmxParameters,
    execution: Execution,
) -> V3dFwhmxOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dFwhmxOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("out", None) + ".1D") if (params.get("out") is not None) else None,
        detrended_dataset=execution.output_file(params.get("detprefix", None) + ".nii.gz") if (params.get("detprefix") is not None) else None,
    )
    return ret


def v_3d_fwhmx_execute(
    params: V3dFwhmxParameters,
    runner: Runner | None = None,
) -> V3dFwhmxOutputs:
    """
    3dFWHMx
    
    Compute Full Width at Half Maximum (FWHM) for FMRI datasets using
    AutoCorrelation Function (ACF).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFwhmxOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_FWHMX_METADATA)
    params = execution.params(params)
    cargs = v_3d_fwhmx_cargs(params, execution)
    ret = v_3d_fwhmx_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_fwhmx(
    infile: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    demed: bool = False,
    unif: bool = False,
    detrend: float | None = None,
    detprefix: str | None = None,
    geom: bool = False,
    arith: bool = False,
    combine: bool = False,
    out: str | None = None,
    compat: bool = False,
    acf: str | None = None,
    runner: Runner | None = None,
) -> V3dFwhmxOutputs:
    """
    3dFWHMx
    
    Compute Full Width at Half Maximum (FWHM) for FMRI datasets using
    AutoCorrelation Function (ACF).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input dataset.
        mask: Use only voxels that are nonzero in dataset 'mmm'.
        automask: Compute a mask from THIS dataset.
        demed: if the input dataset has more than one sub-brick then subtract\
            the median of each voxel's time series before processing FWHM.
        unif: Normalize each voxel's time series to have the same MAD before\
            processing FWHM, implies -demed.
        detrend: Detrend to order 'q'. If q is not given, the program picks\
            q=NT/30; -detrend disables -demed, and includes -unif.
        detprefix: Save the detrended file into a dataset with prefix 'd'.
        geom: Compute the final estimate as the geometric mean.
        arith: Compute the final estimate as the arithmetic mean.
        combine: Combine the final measurements along each axis into one result.
        out: Write output to file 'ttt' (3 columns of numbers). If not given,\
            the sub-brick outputs are not written. Use '-out -' to write to stdout,\
            if desired.
        compat: Be compatible with the older 3dFWHM.
        acf: Compute the spatial autocorrelation of the data as a function of\
            radius, then fit that to a model and output the model parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFwhmxOutputs`).
    """
    params = v_3d_fwhmx_params(
        mask=mask,
        automask=automask,
        demed=demed,
        unif=unif,
        detrend=detrend,
        detprefix=detprefix,
        geom=geom,
        arith=arith,
        combine=combine,
        out=out,
        compat=compat,
        acf=acf,
        infile=infile,
    )
    return v_3d_fwhmx_execute(params, runner)


__all__ = [
    "V3dFwhmxOutputs",
    "V_3D_FWHMX_METADATA",
    "v_3d_fwhmx",
    "v_3d_fwhmx_execute",
    "v_3d_fwhmx_params",
]
