# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_GEN_FEATURE_DIST_METADATA = Metadata(
    id="d42e06b53846e1ec66b2897929ce39b2457df34b.boutiques",
    name="3dGenFeatureDist",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dGenFeatureDistParameters = typing.TypedDict('V3dGenFeatureDistParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dGenFeatureDist"]],
    "features_string": str,
    "class_string": str,
    "prefix": typing.NotRequired[str | None],
    "overwrite": bool,
    "debug_level": typing.NotRequired[float | None],
    "other": bool,
    "no_other": bool,
    "samp": typing.NotRequired[list[str] | None],
    "sig": typing.NotRequired[list[str] | None],
    "hspec": typing.NotRequired[list[str] | None],
    "labeltable": typing.NotRequired[InputPathType | None],
    "show_histograms": typing.NotRequired[str | None],
})
V3dGenFeatureDistParametersTagged = typing.TypedDict('V3dGenFeatureDistParametersTagged', {
    "@type": typing.Literal["afni/3dGenFeatureDist"],
    "features_string": str,
    "class_string": str,
    "prefix": typing.NotRequired[str | None],
    "overwrite": bool,
    "debug_level": typing.NotRequired[float | None],
    "other": bool,
    "no_other": bool,
    "samp": typing.NotRequired[list[str] | None],
    "sig": typing.NotRequired[list[str] | None],
    "hspec": typing.NotRequired[list[str] | None],
    "labeltable": typing.NotRequired[InputPathType | None],
    "show_histograms": typing.NotRequired[str | None],
})


class V3dGenFeatureDistOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dGenFeatureDistParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_hive: OutputPathType | None
    """Histogram volume output"""


def v_3d_gen_feature_dist_params(
    features_string: str,
    class_string: str,
    prefix: str | None = None,
    overwrite: bool = False,
    debug_level: float | None = None,
    other: bool = False,
    no_other: bool = False,
    samp: list[str] | None = None,
    sig: list[str] | None = None,
    hspec: list[str] | None = None,
    labeltable: InputPathType | None = None,
    show_histograms: str | None = None,
) -> V3dGenFeatureDistParametersTagged:
    """
    Build parameters.
    
    Args:
        features_string: FEATURES_STRING is a semicolon delimited string of\
            features.
        class_string: CLASS_STRING is a semicolon delimited string of class\
            labels.
        prefix: PREF is the prefix for all output volumes that are not\
            debugging related.
        overwrite: Automatically overwrite existing output.
        debug_level: Debugging level.
        other: Add histograms for an 'OTHER' class that has a uniform pdf.
        no_other: Opposite of -OTHER.
        samp: Specify which voxels belong to each class of interest.
        sig: Specify volumes that define the features.
        hspec: Set histogram parameters for a specific feature.
        labeltable: Specify the label table.
        show_histograms: Show specified histograms and quit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dGenFeatureDist",
        "features_string": features_string,
        "class_string": class_string,
        "overwrite": overwrite,
        "other": other,
        "no_other": no_other,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if debug_level is not None:
        params["debug_level"] = debug_level
    if samp is not None:
        params["samp"] = samp
    if sig is not None:
        params["sig"] = sig
    if hspec is not None:
        params["hspec"] = hspec
    if labeltable is not None:
        params["labeltable"] = labeltable
    if show_histograms is not None:
        params["show_histograms"] = show_histograms
    return params


def v_3d_gen_feature_dist_cargs(
    params: V3dGenFeatureDistParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dGenFeatureDist")
    cargs.extend([
        "-features",
        params.get("features_string", None)
    ])
    cargs.extend([
        "-classes",
        params.get("class_string", None)
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    if params.get("debug_level", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level", None))
        ])
    if params.get("other", False):
        cargs.append("-OTHER")
    if params.get("no_other", False):
        cargs.append("-no_OTHER")
    if params.get("samp", None) is not None:
        cargs.extend([
            "-samp",
            *params.get("samp", None)
        ])
    if params.get("sig", None) is not None:
        cargs.extend([
            "-sig",
            *params.get("sig", None)
        ])
    if params.get("hspec", None) is not None:
        cargs.extend([
            "-hspec",
            *params.get("hspec", None)
        ])
    if params.get("labeltable", None) is not None:
        cargs.extend([
            "-labeltable",
            execution.input_file(params.get("labeltable", None))
        ])
    if params.get("show_histograms", None) is not None:
        cargs.extend([
            "-ShowTheseHists",
            params.get("show_histograms", None)
        ])
    return cargs


def v_3d_gen_feature_dist_outputs(
    params: V3dGenFeatureDistParameters,
    execution: Execution,
) -> V3dGenFeatureDistOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dGenFeatureDistOutputs(
        root=execution.output_file("."),
        output_hive=execution.output_file(params.get("prefix", None) + "_hive.nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_gen_feature_dist_execute(
    params: V3dGenFeatureDistParameters,
    runner: Runner | None = None,
) -> V3dGenFeatureDistOutputs:
    """
    3dGenFeatureDist
    
    3dGenFeatureDist produces histogram volume (hives) from input data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGenFeatureDistOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_GEN_FEATURE_DIST_METADATA)
    params = execution.params(params)
    cargs = v_3d_gen_feature_dist_cargs(params, execution)
    ret = v_3d_gen_feature_dist_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_gen_feature_dist(
    features_string: str,
    class_string: str,
    prefix: str | None = None,
    overwrite: bool = False,
    debug_level: float | None = None,
    other: bool = False,
    no_other: bool = False,
    samp: list[str] | None = None,
    sig: list[str] | None = None,
    hspec: list[str] | None = None,
    labeltable: InputPathType | None = None,
    show_histograms: str | None = None,
    runner: Runner | None = None,
) -> V3dGenFeatureDistOutputs:
    """
    3dGenFeatureDist
    
    3dGenFeatureDist produces histogram volume (hives) from input data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        features_string: FEATURES_STRING is a semicolon delimited string of\
            features.
        class_string: CLASS_STRING is a semicolon delimited string of class\
            labels.
        prefix: PREF is the prefix for all output volumes that are not\
            debugging related.
        overwrite: Automatically overwrite existing output.
        debug_level: Debugging level.
        other: Add histograms for an 'OTHER' class that has a uniform pdf.
        no_other: Opposite of -OTHER.
        samp: Specify which voxels belong to each class of interest.
        sig: Specify volumes that define the features.
        hspec: Set histogram parameters for a specific feature.
        labeltable: Specify the label table.
        show_histograms: Show specified histograms and quit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGenFeatureDistOutputs`).
    """
    params = v_3d_gen_feature_dist_params(
        features_string=features_string,
        class_string=class_string,
        prefix=prefix,
        overwrite=overwrite,
        debug_level=debug_level,
        other=other,
        no_other=no_other,
        samp=samp,
        sig=sig,
        hspec=hspec,
        labeltable=labeltable,
        show_histograms=show_histograms,
    )
    return v_3d_gen_feature_dist_execute(params, runner)


__all__ = [
    "V3dGenFeatureDistOutputs",
    "V_3D_GEN_FEATURE_DIST_METADATA",
    "v_3d_gen_feature_dist",
    "v_3d_gen_feature_dist_execute",
    "v_3d_gen_feature_dist_params",
]
