# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_GEN_PRIORS_METADATA = Metadata(
    id="2ef1d36ab8521e473da2eeb01af4267f96ee82d4.boutiques",
    name="3dGenPriors",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dGenPriorsParameters = typing.TypedDict('V3dGenPriorsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dGenPriors"]],
    "sigs": InputPathType,
    "tdist": InputPathType,
    "cprefix": str,
    "pprefix": str,
    "labeltable": InputPathType,
    "do": str,
    "prefix": typing.NotRequired[str | None],
    "cmask": typing.NotRequired[str | None],
    "mask": typing.NotRequired[str | None],
    "mrange": typing.NotRequired[list[float] | None],
    "debug": typing.NotRequired[float | None],
    "vox_debug": typing.NotRequired[str | None],
    "vox_debug_file": typing.NotRequired[str | None],
    "uid": typing.NotRequired[str | None],
    "use_tmp": bool,
    "no_tmp": bool,
    "pset": typing.NotRequired[str | None],
    "cset": typing.NotRequired[str | None],
    "regroup_classes": typing.NotRequired[str | None],
    "classes": typing.NotRequired[str | None],
    "features": typing.NotRequired[str | None],
    "strict_feature_match": bool,
    "featgroups": typing.NotRequired[str | None],
    "show_this_dist": typing.NotRequired[str | None],
    "fast": bool,
    "slow": bool,
})
V3dGenPriorsParametersTagged = typing.TypedDict('V3dGenPriorsParametersTagged', {
    "@type": typing.Literal["afni/3dGenPriors"],
    "sigs": InputPathType,
    "tdist": InputPathType,
    "cprefix": str,
    "pprefix": str,
    "labeltable": InputPathType,
    "do": str,
    "prefix": typing.NotRequired[str | None],
    "cmask": typing.NotRequired[str | None],
    "mask": typing.NotRequired[str | None],
    "mrange": typing.NotRequired[list[float] | None],
    "debug": typing.NotRequired[float | None],
    "vox_debug": typing.NotRequired[str | None],
    "vox_debug_file": typing.NotRequired[str | None],
    "uid": typing.NotRequired[str | None],
    "use_tmp": bool,
    "no_tmp": bool,
    "pset": typing.NotRequired[str | None],
    "cset": typing.NotRequired[str | None],
    "regroup_classes": typing.NotRequired[str | None],
    "classes": typing.NotRequired[str | None],
    "features": typing.NotRequired[str | None],
    "strict_feature_match": bool,
    "featgroups": typing.NotRequired[str | None],
    "show_this_dist": typing.NotRequired[str | None],
    "fast": bool,
    "slow": bool,
})


class V3dGenPriorsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dGenPriorsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_cprefix: OutputPathType
    """Main classification output"""
    out_pprefix: OutputPathType
    """Main probability output"""


def v_3d_gen_priors_params(
    sigs: InputPathType,
    tdist: InputPathType,
    cprefix: str,
    pprefix: str,
    labeltable: InputPathType,
    do: str,
    prefix: str | None = None,
    cmask: str | None = None,
    mask: str | None = None,
    mrange: list[float] | None = None,
    debug: float | None = None,
    vox_debug: str | None = None,
    vox_debug_file: str | None = None,
    uid: str | None = None,
    use_tmp: bool = False,
    no_tmp: bool = False,
    pset: str | None = None,
    cset: str | None = None,
    regroup_classes: str | None = None,
    classes: str | None = None,
    features: str | None = None,
    strict_feature_match: bool = False,
    featgroups: str | None = None,
    show_this_dist: str | None = None,
    fast: bool = False,
    slow: bool = False,
) -> V3dGenPriorsParametersTagged:
    """
    Build parameters.
    
    Args:
        sigs: Signatures dataset. A dataset with F features per voxel.
        tdist: Training results. This file is generated by 3dSignatures.
        cprefix: Prefix for class dataset.
        pprefix: Prefix for probability dataset.
        labeltable: Labeltable to attach to output dataset.
        do: Specify the output that this program should create.
        prefix: Specify root prefix for output volumes.
        cmask: Provide cmask expression. Voxels where expression is 0 are\
            excluded from computations.
        mask: Provide mask dataset.
        mrange: Consider MASK only for values between M0 and M1, inclusive.
        debug: Set debug level.
        vox_debug: 1D index or 3D indices (I J K) of voxel to debug.
        vox_debug_file: File in which debug information is output.
        uid: User identifier string. Used to generate names for temporary\
            files.
        use_tmp: Use temporary storage to speed up the program.
        no_tmp: Do not use temporary storage.
        pset: Reuse probability output from an earlier run.
        cset: Reuse classification output from an earlier run.
        regroup_classes: Regroup classes into parent classes. Requires naming\
            the original classes as C1.*, C2.*, etc.
        classes: Classify into these classes only.
        features: Use these features only. Otherwise, all features in the\
            signature file will be used.
        strict_feature_match: Use strict feature name matching.
        featgroups: Feature groups.
        show_this_dist: Show information obtained from the training data about\
            the distribution of DIST. Set DIST to ALL to see all distributions.
        fast: Use OpenMPized routines for faster performance.
        slow: Do not use OpenMPized routines.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dGenPriors",
        "sigs": sigs,
        "tdist": tdist,
        "cprefix": cprefix,
        "pprefix": pprefix,
        "labeltable": labeltable,
        "do": do,
        "use_tmp": use_tmp,
        "no_tmp": no_tmp,
        "strict_feature_match": strict_feature_match,
        "fast": fast,
        "slow": slow,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if cmask is not None:
        params["cmask"] = cmask
    if mask is not None:
        params["mask"] = mask
    if mrange is not None:
        params["mrange"] = mrange
    if debug is not None:
        params["debug"] = debug
    if vox_debug is not None:
        params["vox_debug"] = vox_debug
    if vox_debug_file is not None:
        params["vox_debug_file"] = vox_debug_file
    if uid is not None:
        params["uid"] = uid
    if pset is not None:
        params["pset"] = pset
    if cset is not None:
        params["cset"] = cset
    if regroup_classes is not None:
        params["regroup_classes"] = regroup_classes
    if classes is not None:
        params["classes"] = classes
    if features is not None:
        params["features"] = features
    if featgroups is not None:
        params["featgroups"] = featgroups
    if show_this_dist is not None:
        params["show_this_dist"] = show_this_dist
    return params


def v_3d_gen_priors_cargs(
    params: V3dGenPriorsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dGenPriors")
    cargs.extend([
        "-sig",
        execution.input_file(params.get("sigs", None))
    ])
    cargs.extend([
        "-tdist",
        execution.input_file(params.get("tdist", None))
    ])
    cargs.extend([
        "-cprefix",
        params.get("cprefix", None)
    ])
    cargs.extend([
        "-pprefix",
        params.get("pprefix", None)
    ])
    cargs.extend([
        "-labeltable",
        execution.input_file(params.get("labeltable", None))
    ])
    cargs.extend([
        "-do",
        params.get("do", None)
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("cmask", None) is not None:
        cargs.extend([
            "-cmask",
            params.get("cmask", None)
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            params.get("mask", None)
        ])
    if params.get("mrange", None) is not None:
        cargs.extend([
            "-mrange",
            *map(str, params.get("mrange", None))
        ])
    if params.get("debug", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug", None))
        ])
    if params.get("vox_debug", None) is not None:
        cargs.extend([
            "-vox_debug",
            params.get("vox_debug", None)
        ])
    if params.get("vox_debug_file", None) is not None:
        cargs.extend([
            "-vox_debug_file",
            params.get("vox_debug_file", None)
        ])
    if params.get("uid", None) is not None:
        cargs.extend([
            "-uid",
            params.get("uid", None)
        ])
    if params.get("use_tmp", False):
        cargs.append("-use_tmp")
    if params.get("no_tmp", False):
        cargs.append("-no_tmp")
    if params.get("pset", None) is not None:
        cargs.extend([
            "-pset",
            params.get("pset", None)
        ])
    if params.get("cset", None) is not None:
        cargs.extend([
            "-cset",
            params.get("cset", None)
        ])
    if params.get("regroup_classes", None) is not None:
        cargs.extend([
            "-regroup_classes",
            params.get("regroup_classes", None)
        ])
    if params.get("classes", None) is not None:
        cargs.extend([
            "-classes",
            params.get("classes", None)
        ])
    if params.get("features", None) is not None:
        cargs.extend([
            "-features",
            params.get("features", None)
        ])
    if params.get("strict_feature_match", False):
        cargs.append("-strict_feature_match")
    if params.get("featgroups", None) is not None:
        cargs.extend([
            "-featgroups",
            params.get("featgroups", None)
        ])
    if params.get("show_this_dist", None) is not None:
        cargs.extend([
            "-ShowThisDist",
            params.get("show_this_dist", None)
        ])
    if params.get("fast", False):
        cargs.append("-fast")
    if params.get("slow", False):
        cargs.append("-slow")
    return cargs


def v_3d_gen_priors_outputs(
    params: V3dGenPriorsParameters,
    execution: Execution,
) -> V3dGenPriorsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dGenPriorsOutputs(
        root=execution.output_file("."),
        out_cprefix=execution.output_file(params.get("cprefix", None) + ".nii.gz"),
        out_pprefix=execution.output_file(params.get("pprefix", None) + ".nii.gz"),
    )
    return ret


def v_3d_gen_priors_execute(
    params: V3dGenPriorsParameters,
    runner: Runner | None = None,
) -> V3dGenPriorsOutputs:
    """
    3dGenPriors
    
    Produces classification priors based on voxel signatures.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGenPriorsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_GEN_PRIORS_METADATA)
    params = execution.params(params)
    cargs = v_3d_gen_priors_cargs(params, execution)
    ret = v_3d_gen_priors_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_gen_priors(
    sigs: InputPathType,
    tdist: InputPathType,
    cprefix: str,
    pprefix: str,
    labeltable: InputPathType,
    do: str,
    prefix: str | None = None,
    cmask: str | None = None,
    mask: str | None = None,
    mrange: list[float] | None = None,
    debug: float | None = None,
    vox_debug: str | None = None,
    vox_debug_file: str | None = None,
    uid: str | None = None,
    use_tmp: bool = False,
    no_tmp: bool = False,
    pset: str | None = None,
    cset: str | None = None,
    regroup_classes: str | None = None,
    classes: str | None = None,
    features: str | None = None,
    strict_feature_match: bool = False,
    featgroups: str | None = None,
    show_this_dist: str | None = None,
    fast: bool = False,
    slow: bool = False,
    runner: Runner | None = None,
) -> V3dGenPriorsOutputs:
    """
    3dGenPriors
    
    Produces classification priors based on voxel signatures.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        sigs: Signatures dataset. A dataset with F features per voxel.
        tdist: Training results. This file is generated by 3dSignatures.
        cprefix: Prefix for class dataset.
        pprefix: Prefix for probability dataset.
        labeltable: Labeltable to attach to output dataset.
        do: Specify the output that this program should create.
        prefix: Specify root prefix for output volumes.
        cmask: Provide cmask expression. Voxels where expression is 0 are\
            excluded from computations.
        mask: Provide mask dataset.
        mrange: Consider MASK only for values between M0 and M1, inclusive.
        debug: Set debug level.
        vox_debug: 1D index or 3D indices (I J K) of voxel to debug.
        vox_debug_file: File in which debug information is output.
        uid: User identifier string. Used to generate names for temporary\
            files.
        use_tmp: Use temporary storage to speed up the program.
        no_tmp: Do not use temporary storage.
        pset: Reuse probability output from an earlier run.
        cset: Reuse classification output from an earlier run.
        regroup_classes: Regroup classes into parent classes. Requires naming\
            the original classes as C1.*, C2.*, etc.
        classes: Classify into these classes only.
        features: Use these features only. Otherwise, all features in the\
            signature file will be used.
        strict_feature_match: Use strict feature name matching.
        featgroups: Feature groups.
        show_this_dist: Show information obtained from the training data about\
            the distribution of DIST. Set DIST to ALL to see all distributions.
        fast: Use OpenMPized routines for faster performance.
        slow: Do not use OpenMPized routines.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGenPriorsOutputs`).
    """
    params = v_3d_gen_priors_params(
        sigs=sigs,
        tdist=tdist,
        cprefix=cprefix,
        pprefix=pprefix,
        labeltable=labeltable,
        do=do,
        prefix=prefix,
        cmask=cmask,
        mask=mask,
        mrange=mrange,
        debug=debug,
        vox_debug=vox_debug,
        vox_debug_file=vox_debug_file,
        uid=uid,
        use_tmp=use_tmp,
        no_tmp=no_tmp,
        pset=pset,
        cset=cset,
        regroup_classes=regroup_classes,
        classes=classes,
        features=features,
        strict_feature_match=strict_feature_match,
        featgroups=featgroups,
        show_this_dist=show_this_dist,
        fast=fast,
        slow=slow,
    )
    return v_3d_gen_priors_execute(params, runner)


__all__ = [
    "V3dGenPriorsOutputs",
    "V_3D_GEN_PRIORS_METADATA",
    "v_3d_gen_priors",
    "v_3d_gen_priors_execute",
    "v_3d_gen_priors_params",
]
