# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_GRAYPLOT_METADATA = Metadata(
    id="f6e3887ef52f450f8f7c42c285ca11d1dca72962.boutiques",
    name="3dGrayplot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dGrayplotParameters = typing.TypedDict('V3dGrayplotParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dGrayplot"]],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
    "dimensions": typing.NotRequired[list[float] | None],
    "resample_old": bool,
    "polort": typing.NotRequired[float | None],
    "fwhm": typing.NotRequired[float | None],
    "pvorder": bool,
    "LJorder": bool,
    "peelorder": bool,
    "ijkorder": bool,
    "range": typing.NotRequired[float | None],
    "percent": bool,
    "raw_with_bounds": typing.NotRequired[list[float] | None],
})
V3dGrayplotParametersTagged = typing.TypedDict('V3dGrayplotParametersTagged', {
    "@type": typing.Literal["afni/3dGrayplot"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
    "dimensions": typing.NotRequired[list[float] | None],
    "resample_old": bool,
    "polort": typing.NotRequired[float | None],
    "fwhm": typing.NotRequired[float | None],
    "pvorder": bool,
    "LJorder": bool,
    "peelorder": bool,
    "ijkorder": bool,
    "range": typing.NotRequired[float | None],
    "percent": bool,
    "raw_with_bounds": typing.NotRequired[list[float] | None],
})


class V3dGrayplotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dGrayplotParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    grayplot_img: OutputPathType | None
    """Grayplot image file"""


def v_3d_grayplot_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    prefix: str | None = None,
    dimensions: list[float] | None = None,
    resample_old: bool = False,
    polort: float | None = None,
    fwhm: float | None = None,
    pvorder: bool = False,
    ljorder: bool = False,
    peelorder: bool = False,
    ijkorder: bool = False,
    range_: float | None = None,
    percent: bool = False,
    raw_with_bounds: list[float] | None = None,
) -> V3dGrayplotParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Input dataset.
        mask: Name of mask dataset. Voxels that are 0 in the mask will not be\
            processed.
        prefix: Name for the output file. Default is Grayplot.png.
        dimensions: Output size of image in pixels: [width height]. Defaults\
            are width=1024 and height=512.
        resample_old: Original resampling method for processed dataset.
        polort: Order of polynomials for detrending. Default is 2. Use '-1' if\
            data is already detrended and de-meaned.
        fwhm: FWHM of blurring radius to use in the dataset before making the\
            image. Default is 0 mm.
        pvorder: Order the voxels by how well they match the two leading\
            principal components of their partition.
        ljorder: Order the voxels by their Ljung-Box statistics, a measure of\
            temporal correlation.
        peelorder: Order the voxels by how many 'peel' steps are needed to get\
            from the partition boundary to the voxel.
        ijkorder: Default intra-partition ordering by dataset 3D index ('ijk').
        range_: Set the range of the data to be plotted. Value of 0 is\
            middle-gray, +X is white, -X is black.
        percent: Scale values to percent differences from the mean of each\
            voxel timeseries. Suitable for raw time series datasets.
        raw_with_bounds: Map values <= A to black, values >= B to white, and\
            intermediate values to grays.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dGrayplot",
        "input": input_,
        "resample_old": resample_old,
        "pvorder": pvorder,
        "LJorder": ljorder,
        "peelorder": peelorder,
        "ijkorder": ijkorder,
        "percent": percent,
    }
    if mask is not None:
        params["mask"] = mask
    if prefix is not None:
        params["prefix"] = prefix
    if dimensions is not None:
        params["dimensions"] = dimensions
    if polort is not None:
        params["polort"] = polort
    if fwhm is not None:
        params["fwhm"] = fwhm
    if range_ is not None:
        params["range"] = range_
    if raw_with_bounds is not None:
        params["raw_with_bounds"] = raw_with_bounds
    return params


def v_3d_grayplot_cargs(
    params: V3dGrayplotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dGrayplot")
    cargs.append(execution.input_file(params.get("input", None)))
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("dimensions", None) is not None:
        cargs.extend([
            "-dimen",
            *map(str, params.get("dimensions", None))
        ])
    if params.get("resample_old", False):
        cargs.append("-oldresam")
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    if params.get("fwhm", None) is not None:
        cargs.extend([
            "-fwhm",
            str(params.get("fwhm", None))
        ])
    if params.get("pvorder", False):
        cargs.append("-pvorder")
    if params.get("LJorder", False):
        cargs.append("-LJorder")
    if params.get("peelorder", False):
        cargs.append("-peelorder")
    if params.get("ijkorder", False):
        cargs.append("-ijkorder")
    if params.get("range", None) is not None:
        cargs.extend([
            "-range",
            str(params.get("range", None))
        ])
    if params.get("percent", False):
        cargs.append("-percent")
    if params.get("raw_with_bounds", None) is not None:
        cargs.extend([
            "-raw_with_bounds",
            *map(str, params.get("raw_with_bounds", None))
        ])
    return cargs


def v_3d_grayplot_outputs(
    params: V3dGrayplotParameters,
    execution: Execution,
) -> V3dGrayplotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dGrayplotOutputs(
        root=execution.output_file("."),
        grayplot_img=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_grayplot_execute(
    params: V3dGrayplotParameters,
    runner: Runner | None = None,
) -> V3dGrayplotOutputs:
    """
    3dGrayplot
    
    Make a grayplot from a 3D+time dataset, like a carpet plot. Result is saved
    to a PNG image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGrayplotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_GRAYPLOT_METADATA)
    params = execution.params(params)
    cargs = v_3d_grayplot_cargs(params, execution)
    ret = v_3d_grayplot_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_grayplot(
    input_: InputPathType,
    mask: InputPathType | None = None,
    prefix: str | None = None,
    dimensions: list[float] | None = None,
    resample_old: bool = False,
    polort: float | None = None,
    fwhm: float | None = None,
    pvorder: bool = False,
    ljorder: bool = False,
    peelorder: bool = False,
    ijkorder: bool = False,
    range_: float | None = None,
    percent: bool = False,
    raw_with_bounds: list[float] | None = None,
    runner: Runner | None = None,
) -> V3dGrayplotOutputs:
    """
    3dGrayplot
    
    Make a grayplot from a 3D+time dataset, like a carpet plot. Result is saved
    to a PNG image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Input dataset.
        mask: Name of mask dataset. Voxels that are 0 in the mask will not be\
            processed.
        prefix: Name for the output file. Default is Grayplot.png.
        dimensions: Output size of image in pixels: [width height]. Defaults\
            are width=1024 and height=512.
        resample_old: Original resampling method for processed dataset.
        polort: Order of polynomials for detrending. Default is 2. Use '-1' if\
            data is already detrended and de-meaned.
        fwhm: FWHM of blurring radius to use in the dataset before making the\
            image. Default is 0 mm.
        pvorder: Order the voxels by how well they match the two leading\
            principal components of their partition.
        ljorder: Order the voxels by their Ljung-Box statistics, a measure of\
            temporal correlation.
        peelorder: Order the voxels by how many 'peel' steps are needed to get\
            from the partition boundary to the voxel.
        ijkorder: Default intra-partition ordering by dataset 3D index ('ijk').
        range_: Set the range of the data to be plotted. Value of 0 is\
            middle-gray, +X is white, -X is black.
        percent: Scale values to percent differences from the mean of each\
            voxel timeseries. Suitable for raw time series datasets.
        raw_with_bounds: Map values <= A to black, values >= B to white, and\
            intermediate values to grays.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dGrayplotOutputs`).
    """
    params = v_3d_grayplot_params(
        input_=input_,
        mask=mask,
        prefix=prefix,
        dimensions=dimensions,
        resample_old=resample_old,
        polort=polort,
        fwhm=fwhm,
        pvorder=pvorder,
        ljorder=ljorder,
        peelorder=peelorder,
        ijkorder=ijkorder,
        range_=range_,
        percent=percent,
        raw_with_bounds=raw_with_bounds,
    )
    return v_3d_grayplot_execute(params, runner)


__all__ = [
    "V3dGrayplotOutputs",
    "V_3D_GRAYPLOT_METADATA",
    "v_3d_grayplot",
    "v_3d_grayplot_execute",
    "v_3d_grayplot_params",
]
