# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ICC_METADATA = Metadata(
    id="7b457f0376258e279b541a448350293a753fe7d3.boutiques",
    name="3dICC",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dIccParameters = typing.TypedDict('V3dIccParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dICC"]],
    "model": str,
    "prefix": str,
    "mask": typing.NotRequired[InputPathType | None],
    "data_table": str,
    "bounds": typing.NotRequired[list[float] | None],
    "jobs": typing.NotRequired[float | None],
    "qVars": typing.NotRequired[str | None],
    "qVarCenters": typing.NotRequired[str | None],
    "subj": typing.NotRequired[str | None],
    "input_file_column": typing.NotRequired[str | None],
    "tStat": typing.NotRequired[str | None],
    "dbgArgs": bool,
    "cio": bool,
    "rio": bool,
})
V3dIccParametersTagged = typing.TypedDict('V3dIccParametersTagged', {
    "@type": typing.Literal["afni/3dICC"],
    "model": str,
    "prefix": str,
    "mask": typing.NotRequired[InputPathType | None],
    "data_table": str,
    "bounds": typing.NotRequired[list[float] | None],
    "jobs": typing.NotRequired[float | None],
    "qVars": typing.NotRequired[str | None],
    "qVarCenters": typing.NotRequired[str | None],
    "subj": typing.NotRequired[str | None],
    "input_file_column": typing.NotRequired[str | None],
    "tStat": typing.NotRequired[str | None],
    "dbgArgs": bool,
    "cio": bool,
    "rio": bool,
})


class V3dIccOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dIccParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Name of the output file"""


def v_3d_icc_params(
    model: str,
    prefix: str,
    data_table: str,
    mask: InputPathType | None = None,
    bounds: list[float] | None = None,
    jobs: float | None = None,
    q_vars: str | None = None,
    q_var_centers: str | None = None,
    subj: str | None = None,
    input_file_column: str | None = None,
    t_stat: str | None = None,
    dbg_args: bool = False,
    cio: bool = False,
    rio: bool = False,
) -> V3dIccParametersTagged:
    """
    Build parameters.
    
    Args:
        model: Model structure for all the variables. The expression FORMULA\
            with more than one variable has to be surrounded within quotes.\
            Variable names should be consistent with the ones used in the header of\
            -dataTable.
        prefix: Name of output file. For AFNI format, provide prefix only, with\
            no view+suffix needed. Filename for NIfTI format should have .nii\
            attached, while file name for surface data is expected to end with\
            .niml.dset.
        data_table: List the data structure with a header as the first line.\
            The first column is reserved with label 'Subj', and the last is\
            reserved for 'InputFile'.
        mask: Path to mask file. Only process voxels inside this mask.
        bounds: Bounds for outlier removal. Provide two numbers: the lower\
            bound (lb) and the upper bound (ub). Input data will be confined within\
            [lb, ub]. Any values beyond the bounds will be treated as missing.
        jobs: Number of jobs for parallel computing. Choose 1 for a\
            single-processor computer.
        q_vars: Identify quantitative variables with this option. List should\
            be separated with comma and surrounded within quotes.
        q_var_centers: Specify centering values for quantitative variables\
            identified under -qVars. Multiple centers are separated by commas and\
            should be surrounded within quotes.
        subj: Specify the column name that is designated as the measuring\
            entity variable (usually subject).
        input_file_column: Specify the last column name that is designated for\
            input files of effect estimate.
        t_stat: Specify the column name that is designated as the t-statistic.
        dbg_args: Enable R to save the parameters in a file called\
            .3dICC.dbg.AFNI.args in the current directory for debugging.
        cio: Use AFNI's C io functions. Default is -cio.
        rio: Use R's io functions.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dICC",
        "model": model,
        "prefix": prefix,
        "data_table": data_table,
        "dbgArgs": dbg_args,
        "cio": cio,
        "rio": rio,
    }
    if mask is not None:
        params["mask"] = mask
    if bounds is not None:
        params["bounds"] = bounds
    if jobs is not None:
        params["jobs"] = jobs
    if q_vars is not None:
        params["qVars"] = q_vars
    if q_var_centers is not None:
        params["qVarCenters"] = q_var_centers
    if subj is not None:
        params["subj"] = subj
    if input_file_column is not None:
        params["input_file_column"] = input_file_column
    if t_stat is not None:
        params["tStat"] = t_stat
    return params


def v_3d_icc_cargs(
    params: V3dIccParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dICC")
    cargs.append(params.get("model", None))
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    cargs.extend([
        "-dataTable",
        params.get("data_table", None)
    ])
    if params.get("bounds", None) is not None:
        cargs.extend([
            "-bounds",
            *map(str, params.get("bounds", None))
        ])
    if params.get("jobs", None) is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs", None))
        ])
    if params.get("qVars", None) is not None:
        cargs.extend([
            "-qVars",
            params.get("qVars", None)
        ])
    if params.get("qVarCenters", None) is not None:
        cargs.extend([
            "-qVarCenters",
            params.get("qVarCenters", None)
        ])
    if params.get("subj", None) is not None:
        cargs.extend([
            "-Subj",
            params.get("subj", None)
        ])
    if params.get("input_file_column", None) is not None:
        cargs.extend([
            "-IF",
            params.get("input_file_column", None)
        ])
    if params.get("tStat", None) is not None:
        cargs.extend([
            "-tStat",
            params.get("tStat", None)
        ])
    if params.get("dbgArgs", False):
        cargs.append("-dbgArgs")
    if params.get("cio", False):
        cargs.append("-cio")
    if params.get("rio", False):
        cargs.append("-Rio")
    return cargs


def v_3d_icc_outputs(
    params: V3dIccParameters,
    execution: Execution,
) -> V3dIccOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dIccOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None)),
    )
    return ret


def v_3d_icc_execute(
    params: V3dIccParameters,
    runner: Runner | None = None,
) -> V3dIccOutputs:
    """
    3dICC
    
    AFNI Program for IntraClass Correlatin (ICC) Analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dIccOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ICC_METADATA)
    params = execution.params(params)
    cargs = v_3d_icc_cargs(params, execution)
    ret = v_3d_icc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_icc(
    model: str,
    prefix: str,
    data_table: str,
    mask: InputPathType | None = None,
    bounds: list[float] | None = None,
    jobs: float | None = None,
    q_vars: str | None = None,
    q_var_centers: str | None = None,
    subj: str | None = None,
    input_file_column: str | None = None,
    t_stat: str | None = None,
    dbg_args: bool = False,
    cio: bool = False,
    rio: bool = False,
    runner: Runner | None = None,
) -> V3dIccOutputs:
    """
    3dICC
    
    AFNI Program for IntraClass Correlatin (ICC) Analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        model: Model structure for all the variables. The expression FORMULA\
            with more than one variable has to be surrounded within quotes.\
            Variable names should be consistent with the ones used in the header of\
            -dataTable.
        prefix: Name of output file. For AFNI format, provide prefix only, with\
            no view+suffix needed. Filename for NIfTI format should have .nii\
            attached, while file name for surface data is expected to end with\
            .niml.dset.
        data_table: List the data structure with a header as the first line.\
            The first column is reserved with label 'Subj', and the last is\
            reserved for 'InputFile'.
        mask: Path to mask file. Only process voxels inside this mask.
        bounds: Bounds for outlier removal. Provide two numbers: the lower\
            bound (lb) and the upper bound (ub). Input data will be confined within\
            [lb, ub]. Any values beyond the bounds will be treated as missing.
        jobs: Number of jobs for parallel computing. Choose 1 for a\
            single-processor computer.
        q_vars: Identify quantitative variables with this option. List should\
            be separated with comma and surrounded within quotes.
        q_var_centers: Specify centering values for quantitative variables\
            identified under -qVars. Multiple centers are separated by commas and\
            should be surrounded within quotes.
        subj: Specify the column name that is designated as the measuring\
            entity variable (usually subject).
        input_file_column: Specify the last column name that is designated for\
            input files of effect estimate.
        t_stat: Specify the column name that is designated as the t-statistic.
        dbg_args: Enable R to save the parameters in a file called\
            .3dICC.dbg.AFNI.args in the current directory for debugging.
        cio: Use AFNI's C io functions. Default is -cio.
        rio: Use R's io functions.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dIccOutputs`).
    """
    params = v_3d_icc_params(
        model=model,
        prefix=prefix,
        mask=mask,
        data_table=data_table,
        bounds=bounds,
        jobs=jobs,
        q_vars=q_vars,
        q_var_centers=q_var_centers,
        subj=subj,
        input_file_column=input_file_column,
        t_stat=t_stat,
        dbg_args=dbg_args,
        cio=cio,
        rio=rio,
    )
    return v_3d_icc_execute(params, runner)


__all__ = [
    "V3dIccOutputs",
    "V_3D_ICC_METADATA",
    "v_3d_icc",
    "v_3d_icc_execute",
    "v_3d_icc_params",
]
