# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_KRUSKAL_WALLIS_METADATA = Metadata(
    id="c4d588d98c846668cc79de9a1c61e26919317883.boutiques",
    name="3dKruskalWallis",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dKruskalWallisParameters = typing.TypedDict('V3dKruskalWallisParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dKruskalWallis"]],
    "levels": int,
    "datasets": list[str],
    "workmem": typing.NotRequired[int | None],
    "voxel": typing.NotRequired[int | None],
    "output": str,
})
V3dKruskalWallisParametersTagged = typing.TypedDict('V3dKruskalWallisParametersTagged', {
    "@type": typing.Literal["afni/3dKruskalWallis"],
    "levels": int,
    "datasets": list[str],
    "workmem": typing.NotRequired[int | None],
    "voxel": typing.NotRequired[int | None],
    "output": str,
})


class V3dKruskalWallisOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dKruskalWallisParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile_prefix: OutputPathType
    """Output file containing Kruskal-Wallis statistics"""


def v_3d_kruskal_wallis_params(
    levels: int,
    datasets: list[str],
    output: str,
    workmem: int | None = None,
    voxel: int | None = None,
) -> V3dKruskalWallisParametersTagged:
    """
    Build parameters.
    
    Args:
        levels: Number of treatments.
        datasets: Data set for treatment #1 through to treatment #s. Specify\
            sub-brick if more than one present.
        output: Kruskal-Wallis statistics are written to file prefixname.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dKruskalWallis",
        "levels": levels,
        "datasets": datasets,
        "output": output,
    }
    if workmem is not None:
        params["workmem"] = workmem
    if voxel is not None:
        params["voxel"] = voxel
    return params


def v_3d_kruskal_wallis_cargs(
    params: V3dKruskalWallisParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dKruskalWallis")
    cargs.extend([
        "-levels",
        str(params.get("levels", None))
    ])
    cargs.extend([
        "-dset",
        *params.get("datasets", None)
    ])
    if params.get("workmem", None) is not None:
        cargs.extend([
            "-workmem",
            str(params.get("workmem", None))
        ])
    if params.get("voxel", None) is not None:
        cargs.extend([
            "-voxel",
            str(params.get("voxel", None))
        ])
    cargs.extend([
        "-out",
        params.get("output", None)
    ])
    return cargs


def v_3d_kruskal_wallis_outputs(
    params: V3dKruskalWallisParameters,
    execution: Execution,
) -> V3dKruskalWallisOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dKruskalWallisOutputs(
        root=execution.output_file("."),
        outfile_prefix=execution.output_file(params.get("output", None) + "+tlrc"),
    )
    return ret


def v_3d_kruskal_wallis_execute(
    params: V3dKruskalWallisParameters,
    runner: Runner | None = None,
) -> V3dKruskalWallisOutputs:
    """
    3dKruskalWallis
    
    This program performs nonparametric Kruskal-Wallis test for comparison of
    multiple treatments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dKruskalWallisOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_KRUSKAL_WALLIS_METADATA)
    params = execution.params(params)
    cargs = v_3d_kruskal_wallis_cargs(params, execution)
    ret = v_3d_kruskal_wallis_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_kruskal_wallis(
    levels: int,
    datasets: list[str],
    output: str,
    workmem: int | None = None,
    voxel: int | None = None,
    runner: Runner | None = None,
) -> V3dKruskalWallisOutputs:
    """
    3dKruskalWallis
    
    This program performs nonparametric Kruskal-Wallis test for comparison of
    multiple treatments.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        levels: Number of treatments.
        datasets: Data set for treatment #1 through to treatment #s. Specify\
            sub-brick if more than one present.
        output: Kruskal-Wallis statistics are written to file prefixname.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dKruskalWallisOutputs`).
    """
    params = v_3d_kruskal_wallis_params(
        levels=levels,
        datasets=datasets,
        workmem=workmem,
        voxel=voxel,
        output=output,
    )
    return v_3d_kruskal_wallis_execute(params, runner)


__all__ = [
    "V3dKruskalWallisOutputs",
    "V_3D_KRUSKAL_WALLIS_METADATA",
    "v_3d_kruskal_wallis",
    "v_3d_kruskal_wallis_execute",
    "v_3d_kruskal_wallis_params",
]
