# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LOCAL_ACF_METADATA = Metadata(
    id="13a5cf4d62e86aaa1c39140c70391cd1c06bc003.boutiques",
    name="3dLocalACF",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLocalAcfParameters = typing.TypedDict('V3dLocalAcfParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dLocalACF"]],
    "prefix": str,
    "input_file": InputPathType,
    "neighborhood": typing.NotRequired[str | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "auto_mask": bool,
})
V3dLocalAcfParametersTagged = typing.TypedDict('V3dLocalAcfParametersTagged', {
    "@type": typing.Literal["afni/3dLocalACF"],
    "prefix": str,
    "input_file": InputPathType,
    "neighborhood": typing.NotRequired[str | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "auto_mask": bool,
})


class V3dLocalAcfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dLocalAcfParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output dataset with ACF estimates"""


def v_3d_local_acf_params(
    prefix: str,
    input_file: InputPathType,
    neighborhood: str | None = None,
    mask_file: InputPathType | None = None,
    auto_mask: bool = False,
) -> V3dLocalAcfParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for output dataset.
        input_file: Input time series dataset.
        neighborhood: Neighborhood specification (e.g., SPHERE(25)).
        mask_file: Dataset to mask the analysis.
        auto_mask: Automatically generate brain mask from input dataset.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dLocalACF",
        "prefix": prefix,
        "input_file": input_file,
        "auto_mask": auto_mask,
    }
    if neighborhood is not None:
        params["neighborhood"] = neighborhood
    if mask_file is not None:
        params["mask_file"] = mask_file
    return params


def v_3d_local_acf_cargs(
    params: V3dLocalAcfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLocalACF")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.append(execution.input_file(params.get("input_file", None)))
    if params.get("neighborhood", None) is not None:
        cargs.extend([
            "-nbhd",
            params.get("neighborhood", None)
        ])
    if params.get("mask_file", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_file", None))
        ])
    if params.get("auto_mask", False):
        cargs.append("-automask")
    return cargs


def v_3d_local_acf_outputs(
    params: V3dLocalAcfParameters,
    execution: Execution,
) -> V3dLocalAcfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLocalAcfOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".nii.gz"),
    )
    return ret


def v_3d_local_acf_execute(
    params: V3dLocalAcfParameters,
    runner: Runner | None = None,
) -> V3dLocalAcfOutputs:
    """
    3dLocalACF
    
    Estimate the spatial AutoCorrelation Function (ACF) locally in a
    neighborhood around each voxel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLocalAcfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LOCAL_ACF_METADATA)
    params = execution.params(params)
    cargs = v_3d_local_acf_cargs(params, execution)
    ret = v_3d_local_acf_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_local_acf(
    prefix: str,
    input_file: InputPathType,
    neighborhood: str | None = None,
    mask_file: InputPathType | None = None,
    auto_mask: bool = False,
    runner: Runner | None = None,
) -> V3dLocalAcfOutputs:
    """
    3dLocalACF
    
    Estimate the spatial AutoCorrelation Function (ACF) locally in a
    neighborhood around each voxel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for output dataset.
        input_file: Input time series dataset.
        neighborhood: Neighborhood specification (e.g., SPHERE(25)).
        mask_file: Dataset to mask the analysis.
        auto_mask: Automatically generate brain mask from input dataset.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLocalAcfOutputs`).
    """
    params = v_3d_local_acf_params(
        prefix=prefix,
        input_file=input_file,
        neighborhood=neighborhood,
        mask_file=mask_file,
        auto_mask=auto_mask,
    )
    return v_3d_local_acf_execute(params, runner)


__all__ = [
    "V3dLocalAcfOutputs",
    "V_3D_LOCAL_ACF_METADATA",
    "v_3d_local_acf",
    "v_3d_local_acf_execute",
    "v_3d_local_acf_params",
]
