# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LOCAL_PV_METADATA = Metadata(
    id="8390b49d7516417de04bf15a124a704a00105410.boutiques",
    name="3dLocalPV",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLocalPvParameters = typing.TypedDict('V3dLocalPvParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dLocalPV"]],
    "input_dataset": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "prefix": typing.NotRequired[str | None],
    "prefix2": typing.NotRequired[str | None],
    "evprefix": typing.NotRequired[str | None],
    "neighborhood": typing.NotRequired[str | None],
    "despike": bool,
    "polort": typing.NotRequired[float | None],
    "vnorm": bool,
    "vproj": typing.NotRequired[str | None],
})
V3dLocalPvParametersTagged = typing.TypedDict('V3dLocalPvParametersTagged', {
    "@type": typing.Literal["afni/3dLocalPV"],
    "input_dataset": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "prefix": typing.NotRequired[str | None],
    "prefix2": typing.NotRequired[str | None],
    "evprefix": typing.NotRequired[str | None],
    "neighborhood": typing.NotRequired[str | None],
    "despike": bool,
    "polort": typing.NotRequired[float | None],
    "vnorm": bool,
    "vproj": typing.NotRequired[str | None],
})


class V3dLocalPvOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dLocalPvParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    svd_vector_result: OutputPathType | None
    """SVD vector result dataset"""
    second_principal_vector: OutputPathType | None
    """Second principal vector dataset"""
    singular_value: OutputPathType | None
    """Singular value at each voxel dataset"""


def v_3d_local_pv_params(
    input_dataset: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    prefix: str | None = None,
    prefix2: str | None = None,
    evprefix: str | None = None,
    neighborhood: str | None = None,
    despike: bool = False,
    polort: float | None = None,
    vnorm: bool = False,
    vproj: str | None = None,
) -> V3dLocalPvParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input time series dataset.
        mask: Restrict operations to this mask.
        automask: Create a mask from the time series dataset.
        prefix: Save SVD vector result into this new dataset [default =\
            'LocalPV'].
        prefix2: Save second principal vector into this new dataset [default =\
            don't save it].
        evprefix: Save singular value at each voxel into this dataset [default\
            = don't save].
        neighborhood: Neighborhood definition (e.g., 'SPHERE(5)', 'TOHD(7)',\
            etc.).
        despike: Remove time series spikes from input dataset.
        polort: Detrending.
        vnorm: Normalize data vectors [strongly recommended].
        vproj: Project central data time series onto local SVD vector; if\
            followed by '2', then the central data time series will be projected on\
            the 2-dimensional subspace spanned by the first 2 principal SVD\
            vectors. [default: just output principal singular vector].
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dLocalPV",
        "input_dataset": input_dataset,
        "automask": automask,
        "despike": despike,
        "vnorm": vnorm,
    }
    if mask is not None:
        params["mask"] = mask
    if prefix is not None:
        params["prefix"] = prefix
    if prefix2 is not None:
        params["prefix2"] = prefix2
    if evprefix is not None:
        params["evprefix"] = evprefix
    if neighborhood is not None:
        params["neighborhood"] = neighborhood
    if polort is not None:
        params["polort"] = polort
    if vproj is not None:
        params["vproj"] = vproj
    return params


def v_3d_local_pv_cargs(
    params: V3dLocalPvParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLocalPV")
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("prefix2", None) is not None:
        cargs.extend([
            "-prefix2",
            params.get("prefix2", None)
        ])
    if params.get("evprefix", None) is not None:
        cargs.extend([
            "-evprefix",
            params.get("evprefix", None)
        ])
    if params.get("neighborhood", None) is not None:
        cargs.extend([
            "-nbhd",
            params.get("neighborhood", None)
        ])
    if params.get("despike", False):
        cargs.append("-despike")
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    if params.get("vnorm", False):
        cargs.append("-vnorm")
    if params.get("vproj", None) is not None:
        cargs.extend([
            "-vproj",
            params.get("vproj", None)
        ])
    return cargs


def v_3d_local_pv_outputs(
    params: V3dLocalPvParameters,
    execution: Execution,
) -> V3dLocalPvOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLocalPvOutputs(
        root=execution.output_file("."),
        svd_vector_result=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
        second_principal_vector=execution.output_file(params.get("prefix2", None) + ".nii.gz") if (params.get("prefix2") is not None) else None,
        singular_value=execution.output_file(params.get("evprefix", None) + ".nii.gz") if (params.get("evprefix") is not None) else None,
    )
    return ret


def v_3d_local_pv_execute(
    params: V3dLocalPvParameters,
    runner: Runner | None = None,
) -> V3dLocalPvOutputs:
    """
    3dLocalPV
    
    Computes the Singular Value Decomposition (SVD) of the time series from a
    neighborhood of each voxel in a 3D+time dataset, which serves as a smoothing
    method for the dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLocalPvOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LOCAL_PV_METADATA)
    params = execution.params(params)
    cargs = v_3d_local_pv_cargs(params, execution)
    ret = v_3d_local_pv_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_local_pv(
    input_dataset: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    prefix: str | None = None,
    prefix2: str | None = None,
    evprefix: str | None = None,
    neighborhood: str | None = None,
    despike: bool = False,
    polort: float | None = None,
    vnorm: bool = False,
    vproj: str | None = None,
    runner: Runner | None = None,
) -> V3dLocalPvOutputs:
    """
    3dLocalPV
    
    Computes the Singular Value Decomposition (SVD) of the time series from a
    neighborhood of each voxel in a 3D+time dataset, which serves as a smoothing
    method for the dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input time series dataset.
        mask: Restrict operations to this mask.
        automask: Create a mask from the time series dataset.
        prefix: Save SVD vector result into this new dataset [default =\
            'LocalPV'].
        prefix2: Save second principal vector into this new dataset [default =\
            don't save it].
        evprefix: Save singular value at each voxel into this dataset [default\
            = don't save].
        neighborhood: Neighborhood definition (e.g., 'SPHERE(5)', 'TOHD(7)',\
            etc.).
        despike: Remove time series spikes from input dataset.
        polort: Detrending.
        vnorm: Normalize data vectors [strongly recommended].
        vproj: Project central data time series onto local SVD vector; if\
            followed by '2', then the central data time series will be projected on\
            the 2-dimensional subspace spanned by the first 2 principal SVD\
            vectors. [default: just output principal singular vector].
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLocalPvOutputs`).
    """
    params = v_3d_local_pv_params(
        input_dataset=input_dataset,
        mask=mask,
        automask=automask,
        prefix=prefix,
        prefix2=prefix2,
        evprefix=evprefix,
        neighborhood=neighborhood,
        despike=despike,
        polort=polort,
        vnorm=vnorm,
        vproj=vproj,
    )
    return v_3d_local_pv_execute(params, runner)


__all__ = [
    "V3dLocalPvOutputs",
    "V_3D_LOCAL_PV_METADATA",
    "v_3d_local_pv",
    "v_3d_local_pv_execute",
    "v_3d_local_pv_params",
]
