# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LOMB_SCARGLE_METADATA = Metadata(
    id="3eb111bc9d1c9d69174403521850d208bfb9c167.boutiques",
    name="3dLombScargle",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLombScargleParameters = typing.TypedDict('V3dLombScargleParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dLombScargle"]],
    "prefix": str,
    "inset": InputPathType,
    "censor_1d": typing.NotRequired[InputPathType | None],
    "censor_string": typing.NotRequired[str | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "out_pow_spec": bool,
    "nyquist_multiplier": typing.NotRequired[int | None],
    "nifti": bool,
})
V3dLombScargleParametersTagged = typing.TypedDict('V3dLombScargleParametersTagged', {
    "@type": typing.Literal["afni/3dLombScargle"],
    "prefix": str,
    "inset": InputPathType,
    "censor_1d": typing.NotRequired[InputPathType | None],
    "censor_string": typing.NotRequired[str | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "out_pow_spec": bool,
    "nyquist_multiplier": typing.NotRequired[int | None],
    "nifti": bool,
})


class V3dLombScargleOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dLombScargleParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    time_points: OutputPathType
    """1D file of the sampled time points (in units of seconds) of the analyzed
    data set"""
    frequency_points: OutputPathType
    """1D file of the frequency sample points (in units of 1/seconds) of the
    output periodogram/spectrum data set"""
    amplitude_spectrum: OutputPathType
    """Volumetric data set containing a LS-derived amplitude spectrum"""
    power_spectrum: OutputPathType
    """Volumetric data set containing a LS-derived power spectrum"""


def v_3d_lomb_scargle_params(
    prefix: str,
    inset: InputPathType,
    censor_1d: InputPathType | None = None,
    censor_string: str | None = None,
    mask_file: InputPathType | None = None,
    out_pow_spec: bool = False,
    nyquist_multiplier: int | None = None,
    nifti: bool = False,
) -> V3dLombScargleParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix name for data volume, time point 1D file, and\
            frequency 1D file.
        inset: Time series of volumes, a 4D volumetric data set.
        censor_1d: Single row or column of 1s (keep) and 0s (censored)\
            describing which volumes of FILE are kept in the sampling and which are\
            censored out, respectively. The length of the list of numbers must be\
            of the same length as the number of volumes in FILE. If not entered,\
            then the program will look for subbricks of all-zeros and assume those\
            are censored out.
        censor_string: AFNI-style selector string of volumes to *keep* in the\
            analysis. Such as: '[0..4,7,10..$]'.
        mask_file: Optional, mask of volume to analyze; additionally, any voxel\
            with uniformly zero values across time will produce a zero-spectrum.
        out_pow_spec: Switch to output the amplitude spectrum of the freqs\
            instead of the periodogram. In the formulation used here, for a time\
            series of length N, the power spectral value S is related to the\
            amplitude value X as: S = (X)**2. (Without this opt, default output is\
            amplitude spectrum.).
        nyquist_multiplier: L-S periodograms can include frequencies above what\
            would typically be considered Nyquist. By default, the maximum\
            frequency will be what f_N *would* have been if no censoring of points\
            had occurred. Acceptable values are >0. (This sets the 'hifac'\
            parameter).
        nifti: Switch to output *.nii.gz volume file (default format is\
            BRIK/HEAD).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dLombScargle",
        "prefix": prefix,
        "inset": inset,
        "out_pow_spec": out_pow_spec,
        "nifti": nifti,
    }
    if censor_1d is not None:
        params["censor_1d"] = censor_1d
    if censor_string is not None:
        params["censor_string"] = censor_string
    if mask_file is not None:
        params["mask_file"] = mask_file
    if nyquist_multiplier is not None:
        params["nyquist_multiplier"] = nyquist_multiplier
    return params


def v_3d_lomb_scargle_cargs(
    params: V3dLombScargleParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLombScargle")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-inset",
        execution.input_file(params.get("inset", None))
    ])
    if params.get("censor_1d", None) is not None:
        cargs.extend([
            "-censor_1D",
            execution.input_file(params.get("censor_1d", None))
        ])
    if params.get("censor_string", None) is not None:
        cargs.extend([
            "-censor_str",
            params.get("censor_string", None)
        ])
    if params.get("mask_file", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_file", None))
        ])
    if params.get("out_pow_spec", False):
        cargs.append("-out_pow_spec")
    if params.get("nyquist_multiplier", None) is not None:
        cargs.extend([
            "-nyq_mult",
            str(params.get("nyquist_multiplier", None))
        ])
    if params.get("nifti", False):
        cargs.append("-nifti")
    return cargs


def v_3d_lomb_scargle_outputs(
    params: V3dLombScargleParameters,
    execution: Execution,
) -> V3dLombScargleOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLombScargleOutputs(
        root=execution.output_file("."),
        time_points=execution.output_file(params.get("prefix", None) + "_time.1D"),
        frequency_points=execution.output_file(params.get("prefix", None) + "_freq.1D"),
        amplitude_spectrum=execution.output_file(params.get("prefix", None) + "_amp+orig"),
        power_spectrum=execution.output_file(params.get("prefix", None) + "_pow+orig"),
    )
    return ret


def v_3d_lomb_scargle_execute(
    params: V3dLombScargleParameters,
    runner: Runner | None = None,
) -> V3dLombScargleOutputs:
    """
    3dLombScargle
    
    Make a periodogram or amplitude-spectrum of a time series that has a
    non-constant sampling rate.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLombScargleOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LOMB_SCARGLE_METADATA)
    params = execution.params(params)
    cargs = v_3d_lomb_scargle_cargs(params, execution)
    ret = v_3d_lomb_scargle_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_lomb_scargle(
    prefix: str,
    inset: InputPathType,
    censor_1d: InputPathType | None = None,
    censor_string: str | None = None,
    mask_file: InputPathType | None = None,
    out_pow_spec: bool = False,
    nyquist_multiplier: int | None = None,
    nifti: bool = False,
    runner: Runner | None = None,
) -> V3dLombScargleOutputs:
    """
    3dLombScargle
    
    Make a periodogram or amplitude-spectrum of a time series that has a
    non-constant sampling rate.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix name for data volume, time point 1D file, and\
            frequency 1D file.
        inset: Time series of volumes, a 4D volumetric data set.
        censor_1d: Single row or column of 1s (keep) and 0s (censored)\
            describing which volumes of FILE are kept in the sampling and which are\
            censored out, respectively. The length of the list of numbers must be\
            of the same length as the number of volumes in FILE. If not entered,\
            then the program will look for subbricks of all-zeros and assume those\
            are censored out.
        censor_string: AFNI-style selector string of volumes to *keep* in the\
            analysis. Such as: '[0..4,7,10..$]'.
        mask_file: Optional, mask of volume to analyze; additionally, any voxel\
            with uniformly zero values across time will produce a zero-spectrum.
        out_pow_spec: Switch to output the amplitude spectrum of the freqs\
            instead of the periodogram. In the formulation used here, for a time\
            series of length N, the power spectral value S is related to the\
            amplitude value X as: S = (X)**2. (Without this opt, default output is\
            amplitude spectrum.).
        nyquist_multiplier: L-S periodograms can include frequencies above what\
            would typically be considered Nyquist. By default, the maximum\
            frequency will be what f_N *would* have been if no censoring of points\
            had occurred. Acceptable values are >0. (This sets the 'hifac'\
            parameter).
        nifti: Switch to output *.nii.gz volume file (default format is\
            BRIK/HEAD).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLombScargleOutputs`).
    """
    params = v_3d_lomb_scargle_params(
        prefix=prefix,
        inset=inset,
        censor_1d=censor_1d,
        censor_string=censor_string,
        mask_file=mask_file,
        out_pow_spec=out_pow_spec,
        nyquist_multiplier=nyquist_multiplier,
        nifti=nifti,
    )
    return v_3d_lomb_scargle_execute(params, runner)


__all__ = [
    "V3dLombScargleOutputs",
    "V_3D_LOMB_SCARGLE_METADATA",
    "v_3d_lomb_scargle",
    "v_3d_lomb_scargle_execute",
    "v_3d_lomb_scargle_params",
]
