# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LRFLIP_METADATA = Metadata(
    id="958d124c668f02051ee45f4c019b87646e6b14ab.boutiques",
    name="3dLRflip",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLrflipParameters = typing.TypedDict('V3dLrflipParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dLRflip"]],
    "flip_lr": bool,
    "flip_ap": bool,
    "flip_is": bool,
    "flip_x": bool,
    "flip_y": bool,
    "flip_z": bool,
    "output_prefix": typing.NotRequired[str | None],
    "datasets": list[InputPathType],
})
V3dLrflipParametersTagged = typing.TypedDict('V3dLrflipParametersTagged', {
    "@type": typing.Literal["afni/3dLRflip"],
    "flip_lr": bool,
    "flip_ap": bool,
    "flip_is": bool,
    "flip_x": bool,
    "flip_y": bool,
    "flip_z": bool,
    "output_prefix": typing.NotRequired[str | None],
    "datasets": list[InputPathType],
})


class V3dLrflipOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dLrflipParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_lrflip_params(
    datasets: list[InputPathType],
    flip_lr: bool = False,
    flip_ap: bool = False,
    flip_is: bool = False,
    flip_x: bool = False,
    flip_y: bool = False,
    flip_z: bool = False,
    output_prefix: str | None = None,
) -> V3dLrflipParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: Datasets to flip.
        flip_lr: Flip about Left-Right axis.
        flip_ap: Flip about Anterior-Posterior axis.
        flip_is: Flip about Inferior-Superior axis.
        flip_x: Flip about the 1st direction.
        flip_y: Flip about the 2nd direction.
        flip_z: Flip about the 3rd direction.
        output_prefix: Prefix to use for output. If multiple datasets are\
            input, the program will choose a prefix for each output.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dLRflip",
        "flip_lr": flip_lr,
        "flip_ap": flip_ap,
        "flip_is": flip_is,
        "flip_x": flip_x,
        "flip_y": flip_y,
        "flip_z": flip_z,
        "datasets": datasets,
    }
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def v_3d_lrflip_cargs(
    params: V3dLrflipParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLRflip")
    if params.get("flip_lr", False):
        cargs.append("-LR")
    if params.get("flip_ap", False):
        cargs.append("-AP")
    if params.get("flip_is", False):
        cargs.append("-IS")
    if params.get("flip_x", False):
        cargs.append("-X")
    if params.get("flip_y", False):
        cargs.append("-Y")
    if params.get("flip_z", False):
        cargs.append("-Z")
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    return cargs


def v_3d_lrflip_outputs(
    params: V3dLrflipParameters,
    execution: Execution,
) -> V3dLrflipOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLrflipOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_lrflip_execute(
    params: V3dLrflipParameters,
    runner: Runner | None = None,
) -> V3dLrflipOutputs:
    """
    3dLRflip
    
    Flips the rows of a dataset along one of the three axes to correct dataset
    direction labeling errors.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLrflipOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LRFLIP_METADATA)
    params = execution.params(params)
    cargs = v_3d_lrflip_cargs(params, execution)
    ret = v_3d_lrflip_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_lrflip(
    datasets: list[InputPathType],
    flip_lr: bool = False,
    flip_ap: bool = False,
    flip_is: bool = False,
    flip_x: bool = False,
    flip_y: bool = False,
    flip_z: bool = False,
    output_prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dLrflipOutputs:
    """
    3dLRflip
    
    Flips the rows of a dataset along one of the three axes to correct dataset
    direction labeling errors.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Datasets to flip.
        flip_lr: Flip about Left-Right axis.
        flip_ap: Flip about Anterior-Posterior axis.
        flip_is: Flip about Inferior-Superior axis.
        flip_x: Flip about the 1st direction.
        flip_y: Flip about the 2nd direction.
        flip_z: Flip about the 3rd direction.
        output_prefix: Prefix to use for output. If multiple datasets are\
            input, the program will choose a prefix for each output.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLrflipOutputs`).
    """
    params = v_3d_lrflip_params(
        flip_lr=flip_lr,
        flip_ap=flip_ap,
        flip_is=flip_is,
        flip_x=flip_x,
        flip_y=flip_y,
        flip_z=flip_z,
        output_prefix=output_prefix,
        datasets=datasets,
    )
    return v_3d_lrflip_execute(params, runner)


__all__ = [
    "V3dLrflipOutputs",
    "V_3D_LRFLIP_METADATA",
    "v_3d_lrflip",
    "v_3d_lrflip_execute",
    "v_3d_lrflip_params",
]
